# coding: utf-8

"""
    Returns and Refunds API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: returnsrefunds
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.returnsrefunds.models.channel_reason import ChannelReason
from linnworks_api.generated.returnsrefunds.models.itemized_refund_reason import ItemizedRefundReason
from linnworks_api.generated.returnsrefunds.models.order_details import OrderDetails
from linnworks_api.generated.returnsrefunds.models.order_refund_header import OrderRefundHeader
from linnworks_api.generated.returnsrefunds.models.post_sale_sub_status import PostSaleSubStatus
from linnworks_api.generated.returnsrefunds.models.verified_refund import VerifiedRefund
from typing import Optional, Set
from typing_extensions import Self

class RefundOptions(BaseModel):
    """
    RefundOptions
    """ # noqa: E501
    can_send_rejection_if_deleted: Optional[StrictBool] = Field(default=None, alias="CanSendRejectionIfDeleted")
    can_refund: Optional[StrictBool] = Field(default=None, alias="CanRefund")
    can_refund_internally: Optional[StrictBool] = Field(default=None, alias="CanRefundInternally")
    can_refund_items: Optional[StrictBool] = Field(default=None, alias="CanRefundItems")
    can_refund_services: Optional[StrictBool] = Field(default=None, alias="CanRefundServices")
    can_refund_shipping: Optional[StrictBool] = Field(default=None, alias="CanRefundShipping")
    can_refund_shipping_independently: Optional[StrictBool] = Field(default=None, alias="CanRefundShippingIndependently")
    can_refund_additionally: Optional[StrictBool] = Field(default=None, alias="CanRefundAdditionally")
    can_refund_free_text: Optional[StrictBool] = Field(default=None, alias="CanRefundFreeText")
    can_insufficient_refund_free_text: Optional[StrictBool] = Field(default=None, alias="CanInsufficientRefundFreeText")
    refund_free_text_or_note_max_length: Optional[StrictInt] = Field(default=None, alias="RefundFreeTextOrNoteMaxLength")
    sub_statuses: Optional[List[PostSaleSubStatus]] = Field(default=None, alias="SubStatuses")
    insufficient_refund_reasons: Optional[List[ChannelReason]] = Field(default=None, alias="InsufficientRefundReasons")
    item_refund_reasons: Optional[List[ChannelReason]] = Field(default=None, alias="ItemRefundReasons")
    service_refund_reasons: Optional[List[ChannelReason]] = Field(default=None, alias="ServiceRefundReasons")
    shipping_refund_reasons: Optional[List[ChannelReason]] = Field(default=None, alias="ShippingRefundReasons")
    itemized_refund_reasons: Optional[List[ItemizedRefundReason]] = Field(default=None, alias="ItemizedRefundReasons")
    rejection_reasons: Optional[List[ChannelReason]] = Field(default=None, alias="RejectionReasons")
    cannot_refund_reason: Optional[StrictStr] = Field(default=None, alias="CannotRefundReason")
    order: Optional[OrderDetails] = Field(default=None, alias="Order")
    refund_header: Optional[OrderRefundHeader] = Field(default=None, alias="RefundHeader")
    all_existing_refunds: Optional[List[VerifiedRefund]] = Field(default=None, alias="AllExistingRefunds")
    errors: Optional[List[StrictStr]] = Field(default=None, alias="Errors")
    __properties: ClassVar[List[str]] = ["CanSendRejectionIfDeleted", "CanRefund", "CanRefundInternally", "CanRefundItems", "CanRefundServices", "CanRefundShipping", "CanRefundShippingIndependently", "CanRefundAdditionally", "CanRefundFreeText", "CanInsufficientRefundFreeText", "RefundFreeTextOrNoteMaxLength", "SubStatuses", "InsufficientRefundReasons", "ItemRefundReasons", "ServiceRefundReasons", "ShippingRefundReasons", "ItemizedRefundReasons", "RejectionReasons", "CannotRefundReason", "Order", "RefundHeader", "AllExistingRefunds", "Errors"]

    @field_validator('cannot_refund_reason')
    def cannot_refund_reason_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['None', 'NotImplemented', 'DisabledInConfig', 'MissingOrderInLinnworks', 'OpenOrderInLinnworks', 'OrderIsFullyRefundedInLinnworks', 'NoNewRefundsSpecified', 'NoUpdatedRefundsSpecified', 'MultipleReferences', 'SubStatusTagNotInTheSystem', 'SubStatusTagIsNotActionable', 'MultipleSubStatusTags', 'RefundNotInSystem', 'Other']):
            raise ValueError("must be one of enum values ('None', 'NotImplemented', 'DisabledInConfig', 'MissingOrderInLinnworks', 'OpenOrderInLinnworks', 'OrderIsFullyRefundedInLinnworks', 'NoNewRefundsSpecified', 'NoUpdatedRefundsSpecified', 'MultipleReferences', 'SubStatusTagNotInTheSystem', 'SubStatusTagIsNotActionable', 'MultipleSubStatusTags', 'RefundNotInSystem', 'Other')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RefundOptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "can_refund",
            "can_refund_internally",
            "can_refund_items",
            "can_refund_services",
            "can_refund_shipping",
            "can_refund_shipping_independently",
            "can_refund_additionally",
            "can_refund_free_text",
            "can_insufficient_refund_free_text",
            "refund_free_text_or_note_max_length",
            "sub_statuses",
            "insufficient_refund_reasons",
            "item_refund_reasons",
            "service_refund_reasons",
            "shipping_refund_reasons",
            "itemized_refund_reasons",
            "errors",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in sub_statuses (list)
        _items = []
        if self.sub_statuses:
            for _item_sub_statuses in self.sub_statuses:
                if _item_sub_statuses:
                    _items.append(_item_sub_statuses.to_dict())
            _dict['SubStatuses'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in insufficient_refund_reasons (list)
        _items = []
        if self.insufficient_refund_reasons:
            for _item_insufficient_refund_reasons in self.insufficient_refund_reasons:
                if _item_insufficient_refund_reasons:
                    _items.append(_item_insufficient_refund_reasons.to_dict())
            _dict['InsufficientRefundReasons'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in item_refund_reasons (list)
        _items = []
        if self.item_refund_reasons:
            for _item_item_refund_reasons in self.item_refund_reasons:
                if _item_item_refund_reasons:
                    _items.append(_item_item_refund_reasons.to_dict())
            _dict['ItemRefundReasons'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in service_refund_reasons (list)
        _items = []
        if self.service_refund_reasons:
            for _item_service_refund_reasons in self.service_refund_reasons:
                if _item_service_refund_reasons:
                    _items.append(_item_service_refund_reasons.to_dict())
            _dict['ServiceRefundReasons'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in shipping_refund_reasons (list)
        _items = []
        if self.shipping_refund_reasons:
            for _item_shipping_refund_reasons in self.shipping_refund_reasons:
                if _item_shipping_refund_reasons:
                    _items.append(_item_shipping_refund_reasons.to_dict())
            _dict['ShippingRefundReasons'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in itemized_refund_reasons (list)
        _items = []
        if self.itemized_refund_reasons:
            for _item_itemized_refund_reasons in self.itemized_refund_reasons:
                if _item_itemized_refund_reasons:
                    _items.append(_item_itemized_refund_reasons.to_dict())
            _dict['ItemizedRefundReasons'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in rejection_reasons (list)
        _items = []
        if self.rejection_reasons:
            for _item_rejection_reasons in self.rejection_reasons:
                if _item_rejection_reasons:
                    _items.append(_item_rejection_reasons.to_dict())
            _dict['RejectionReasons'] = _items
        # override the default output from pydantic by calling `to_dict()` of order
        if self.order:
            _dict['Order'] = self.order.to_dict()
        # override the default output from pydantic by calling `to_dict()` of refund_header
        if self.refund_header:
            _dict['RefundHeader'] = self.refund_header.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in all_existing_refunds (list)
        _items = []
        if self.all_existing_refunds:
            for _item_all_existing_refunds in self.all_existing_refunds:
                if _item_all_existing_refunds:
                    _items.append(_item_all_existing_refunds.to_dict())
            _dict['AllExistingRefunds'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RefundOptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "CanSendRejectionIfDeleted": obj.get("CanSendRejectionIfDeleted"),
            "CanRefund": obj.get("CanRefund"),
            "CanRefundInternally": obj.get("CanRefundInternally"),
            "CanRefundItems": obj.get("CanRefundItems"),
            "CanRefundServices": obj.get("CanRefundServices"),
            "CanRefundShipping": obj.get("CanRefundShipping"),
            "CanRefundShippingIndependently": obj.get("CanRefundShippingIndependently"),
            "CanRefundAdditionally": obj.get("CanRefundAdditionally"),
            "CanRefundFreeText": obj.get("CanRefundFreeText"),
            "CanInsufficientRefundFreeText": obj.get("CanInsufficientRefundFreeText"),
            "RefundFreeTextOrNoteMaxLength": obj.get("RefundFreeTextOrNoteMaxLength"),
            "SubStatuses": [PostSaleSubStatus.from_dict(_item) for _item in obj["SubStatuses"]] if obj.get("SubStatuses") is not None else None,
            "InsufficientRefundReasons": [ChannelReason.from_dict(_item) for _item in obj["InsufficientRefundReasons"]] if obj.get("InsufficientRefundReasons") is not None else None,
            "ItemRefundReasons": [ChannelReason.from_dict(_item) for _item in obj["ItemRefundReasons"]] if obj.get("ItemRefundReasons") is not None else None,
            "ServiceRefundReasons": [ChannelReason.from_dict(_item) for _item in obj["ServiceRefundReasons"]] if obj.get("ServiceRefundReasons") is not None else None,
            "ShippingRefundReasons": [ChannelReason.from_dict(_item) for _item in obj["ShippingRefundReasons"]] if obj.get("ShippingRefundReasons") is not None else None,
            "ItemizedRefundReasons": [ItemizedRefundReason.from_dict(_item) for _item in obj["ItemizedRefundReasons"]] if obj.get("ItemizedRefundReasons") is not None else None,
            "RejectionReasons": [ChannelReason.from_dict(_item) for _item in obj["RejectionReasons"]] if obj.get("RejectionReasons") is not None else None,
            "CannotRefundReason": obj.get("CannotRefundReason"),
            "Order": OrderDetails.from_dict(obj["Order"]) if obj.get("Order") is not None else None,
            "RefundHeader": OrderRefundHeader.from_dict(obj["RefundHeader"]) if obj.get("RefundHeader") is not None else None,
            "AllExistingRefunds": [VerifiedRefund.from_dict(_item) for _item in obj["AllExistingRefunds"]] if obj.get("AllExistingRefunds") is not None else None,
            "Errors": obj.get("Errors")
        })
        return _obj


