# coding: utf-8

"""
    Rules Engine API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: rulesengine
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class EvaluatorDescriptor(BaseModel):
    """
    EvaluatorDescriptor
    """ # noqa: E501
    evaluator_type: Optional[StrictStr] = Field(default=None, alias="EvaluatorType")
    client_type: Optional[StrictStr] = Field(default=None, alias="ClientType")
    client_type_name: Optional[StrictStr] = Field(default=None, alias="ClientTypeName")
    evaluator_group: Optional[StrictStr] = Field(default=None, alias="EvaluatorGroup")
    description: Optional[StrictStr] = Field(default=None, alias="Description")
    group_index: Optional[StrictInt] = Field(default=None, alias="GroupIndex")
    eval_index: Optional[StrictInt] = Field(default=None, alias="EvalIndex")
    __properties: ClassVar[List[str]] = ["EvaluatorType", "ClientType", "ClientTypeName", "EvaluatorGroup", "Description", "GroupIndex", "EvalIndex"]

    @field_validator('evaluator_type')
    def evaluator_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Default', 'BetweenExclusive', 'BetweenInclusive', 'GreaterThan', 'GreaterThanOrEqualTo', 'LessThan', 'LessThanOrEqualTo', 'Equals', 'NotEquals', 'StartsWith', 'NotStartsWith', 'EndsWith', 'NotEndsWith', 'Contains', 'NotContains', 'RegexMatch', 'NotRegexMatch', 'InSet', 'NotInSet', 'StartsWithSetValue', 'NotStartsWithSetValue', 'EndsWithSetValue', 'NotEndsWithSetValue', 'ContainsSetValue', 'NotContainsSetValue', 'RegexMatchSetValue', 'NotRegexMatchSetValue']):
            raise ValueError("must be one of enum values ('Default', 'BetweenExclusive', 'BetweenInclusive', 'GreaterThan', 'GreaterThanOrEqualTo', 'LessThan', 'LessThanOrEqualTo', 'Equals', 'NotEquals', 'StartsWith', 'NotStartsWith', 'EndsWith', 'NotEndsWith', 'Contains', 'NotContains', 'RegexMatch', 'NotRegexMatch', 'InSet', 'NotInSet', 'StartsWithSetValue', 'NotStartsWithSetValue', 'EndsWithSetValue', 'NotEndsWithSetValue', 'ContainsSetValue', 'NotContainsSetValue', 'RegexMatchSetValue', 'NotRegexMatchSetValue')")
        return value

    @field_validator('client_type')
    def client_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['SingleValue', 'RangeValue', 'SetValue']):
            raise ValueError("must be one of enum values ('SingleValue', 'RangeValue', 'SetValue')")
        return value

    @field_validator('evaluator_group')
    def evaluator_group_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['BasicEquality', 'Range', 'Set', 'NumberEquality', 'StringEquality']):
            raise ValueError("must be one of enum values ('BasicEquality', 'Range', 'Set', 'NumberEquality', 'StringEquality')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EvaluatorDescriptor from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EvaluatorDescriptor from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "EvaluatorType": obj.get("EvaluatorType"),
            "ClientType": obj.get("ClientType"),
            "ClientTypeName": obj.get("ClientTypeName"),
            "EvaluatorGroup": obj.get("EvaluatorGroup"),
            "Description": obj.get("Description"),
            "GroupIndex": obj.get("GroupIndex"),
            "EvalIndex": obj.get("EvalIndex")
        })
        return _obj


