# coding: utf-8

"""
    Rules Engine API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: rulesengine
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class RuleHeaderBasic(BaseModel):
    """
    RuleHeaderBasic
    """ # noqa: E501
    pk_rule_id: Optional[StrictInt] = Field(default=None, alias="pkRuleId")
    rule_name: Optional[StrictStr] = Field(default=None, alias="RuleName")
    rule_type: Optional[StrictStr] = Field(default=None, alias="RuleType")
    enabled: Optional[StrictBool] = Field(default=None, alias="Enabled")
    run_order: Optional[StrictInt] = Field(default=None, alias="RunOrder")
    pk_rule_id_draft: Optional[StrictInt] = Field(default=None, alias="pkRuleId_Draft")
    draft: Optional[StrictBool] = Field(default=None, alias="Draft")
    rule_type_display_name: Optional[StrictStr] = Field(default=None, alias="RuleTypeDisplayName")
    __properties: ClassVar[List[str]] = ["pkRuleId", "RuleName", "RuleType", "Enabled", "RunOrder", "pkRuleId_Draft", "Draft", "RuleTypeDisplayName"]

    @field_validator('rule_type')
    def rule_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Test', 'Orders']):
            raise ValueError("must be one of enum values ('Test', 'Orders')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RuleHeaderBasic from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "rule_type_display_name",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RuleHeaderBasic from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pkRuleId": obj.get("pkRuleId"),
            "RuleName": obj.get("RuleName"),
            "RuleType": obj.get("RuleType"),
            "Enabled": obj.get("Enabled"),
            "RunOrder": obj.get("RunOrder"),
            "pkRuleId_Draft": obj.get("pkRuleId_Draft"),
            "Draft": obj.get("Draft"),
            "RuleTypeDisplayName": obj.get("RuleTypeDisplayName")
        })
        return _obj


