# coding: utf-8

"""
    Shipping service API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: shippingservice
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.shippingservice.models.printer_config import PrinterConfig
from typing import Optional, Set
from typing_extensions import Self

class SystemShippingAPIConfig(BaseModel):
    """
    SystemShippingAPIConfig
    """ # noqa: E501
    pk_shipping_api_config_id: Optional[StrictInt] = Field(default=None, alias="pkShippingAPIConfigId")
    vendor: Optional[StrictStr] = Field(default=None, alias="Vendor")
    vendor_friendly_name: Optional[StrictStr] = Field(default=None, alias="VendorFriendlyName")
    vendor_icon: Optional[StrictStr] = Field(default=None, alias="VendorIcon")
    account_id: Optional[StrictStr] = Field(default=None, alias="AccountId")
    label_format: Optional[StrictStr] = Field(default=None, alias="LabelFormat")
    services: Optional[StrictInt] = Field(default=None, alias="Services")
    manifest_pending: Optional[StrictBool] = Field(default=None, alias="ManifestPending")
    last_manifest_with_error_id: Optional[StrictInt] = Field(default=None, alias="LastManifestWithErrorId")
    read_only: Optional[StrictBool] = Field(default=None, alias="ReadOnly")
    status: Optional[StrictStr] = Field(default=None, alias="Status")
    printer_config: Optional[PrinterConfig] = Field(default=None, alias="PrinterConfig")
    quote_enabled: Optional[StrictBool] = Field(default=None, alias="QuoteEnabled")
    quote_only_included_services: Optional[StrictBool] = Field(default=None, alias="QuoteOnlyIncludedServices")
    __properties: ClassVar[List[str]] = ["pkShippingAPIConfigId", "Vendor", "VendorFriendlyName", "VendorIcon", "AccountId", "LabelFormat", "Services", "ManifestPending", "LastManifestWithErrorId", "ReadOnly", "Status", "PrinterConfig", "QuoteEnabled", "QuoteOnlyIncludedServices"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SystemShippingAPIConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of printer_config
        if self.printer_config:
            _dict['PrinterConfig'] = self.printer_config.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SystemShippingAPIConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pkShippingAPIConfigId": obj.get("pkShippingAPIConfigId"),
            "Vendor": obj.get("Vendor"),
            "VendorFriendlyName": obj.get("VendorFriendlyName"),
            "VendorIcon": obj.get("VendorIcon"),
            "AccountId": obj.get("AccountId"),
            "LabelFormat": obj.get("LabelFormat"),
            "Services": obj.get("Services"),
            "ManifestPending": obj.get("ManifestPending"),
            "LastManifestWithErrorId": obj.get("LastManifestWithErrorId"),
            "ReadOnly": obj.get("ReadOnly"),
            "Status": obj.get("Status"),
            "PrinterConfig": PrinterConfig.from_dict(obj["PrinterConfig"]) if obj.get("PrinterConfig") is not None else None,
            "QuoteEnabled": obj.get("QuoteEnabled"),
            "QuoteOnlyIncludedServices": obj.get("QuoteOnlyIncludedServices")
        })
        return _obj


