# coding: utf-8

"""
    Stock API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: stock
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class StockGetStockItemsFullRequest(BaseModel):
    """
    StockGetStockItemsFullRequest
    """ # noqa: E501
    keyword: Optional[StrictStr] = Field(default=None, description="Your seearch term")
    load_composite_parents: Optional[StrictBool] = Field(default=None, description="Whether you want to load composite parents or ignore them", alias="loadCompositeParents")
    load_variation_parents: Optional[StrictBool] = Field(default=None, description="Whether you want to load variation parents", alias="loadVariationParents")
    entries_per_page: Optional[StrictInt] = Field(default=None, description="The amount of entries you require. Maximum 200.", alias="entriesPerPage")
    page_number: Optional[StrictInt] = Field(default=None, description="The current page number you are requesting", alias="pageNumber")
    data_requirements: Optional[List[StrictStr]] = Field(default=None, description="The data you require. eg. StockLevels will load the stock levels for each location", alias="dataRequirements")
    search_types: Optional[List[StrictStr]] = Field(default=None, description="The parameters that you would like to search by", alias="searchTypes")
    __properties: ClassVar[List[str]] = ["keyword", "loadCompositeParents", "loadVariationParents", "entriesPerPage", "pageNumber", "dataRequirements", "searchTypes"]

    @field_validator('data_requirements')
    def data_requirements_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in set(['StockLevels', 'Pricing', 'Supplier', 'ShippingInformation', 'ChannelTitle', 'ChannelDescription', 'ChannelPrice', 'ExtendedProperties', 'Images']):
                raise ValueError("each list item must be one of ('StockLevels', 'Pricing', 'Supplier', 'ShippingInformation', 'ChannelTitle', 'ChannelDescription', 'ChannelPrice', 'ExtendedProperties', 'Images')")
        return value

    @field_validator('search_types')
    def search_types_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in set(['SKU', 'Title', 'Barcode']):
                raise ValueError("each list item must be one of ('SKU', 'Title', 'Barcode')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StockGetStockItemsFullRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StockGetStockItemsFullRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "keyword": obj.get("keyword"),
            "loadCompositeParents": obj.get("loadCompositeParents"),
            "loadVariationParents": obj.get("loadVariationParents"),
            "entriesPerPage": obj.get("entriesPerPage"),
            "pageNumber": obj.get("pageNumber"),
            "dataRequirements": obj.get("dataRequirements"),
            "searchTypes": obj.get("searchTypes")
        })
        return _obj


