# coding: utf-8

"""
    Stock API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: stock
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from linnworks_api.generated.stock.models.inventory_stock_location import InventoryStockLocation
from typing import Optional, Set
from typing_extensions import Self

class StockItemDuePO(BaseModel):
    """
    StockItemDuePO
    """ # noqa: E501
    supplier_name: Optional[StrictStr] = Field(default=None, alias="SupplierName")
    location: Optional[InventoryStockLocation] = Field(default=None, alias="Location")
    supplier_id: Optional[StrictStr] = Field(default=None, alias="SupplierId")
    date_of_purchase: Optional[datetime] = Field(default=None, alias="DateOfPurchase")
    quoted_delivery_date: Optional[datetime] = Field(default=None, alias="QuotedDeliveryDate")
    quantity: Optional[StrictInt] = Field(default=None, alias="Quantity")
    delivered: Optional[StrictInt] = Field(default=None, alias="Delivered")
    unit_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="UnitCost")
    stock_item_id: Optional[StrictStr] = Field(default=None, alias="StockItemId")
    stock_item_int_id: Optional[StrictInt] = Field(default=None, alias="StockItemIntId")
    __properties: ClassVar[List[str]] = ["SupplierName", "Location", "SupplierId", "DateOfPurchase", "QuotedDeliveryDate", "Quantity", "Delivered", "UnitCost", "StockItemId", "StockItemIntId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StockItemDuePO from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of location
        if self.location:
            _dict['Location'] = self.location.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StockItemDuePO from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "SupplierName": obj.get("SupplierName"),
            "Location": InventoryStockLocation.from_dict(obj["Location"]) if obj.get("Location") is not None else None,
            "SupplierId": obj.get("SupplierId"),
            "DateOfPurchase": obj.get("DateOfPurchase"),
            "QuotedDeliveryDate": obj.get("QuotedDeliveryDate"),
            "Quantity": obj.get("Quantity"),
            "Delivered": obj.get("Delivered"),
            "UnitCost": obj.get("UnitCost"),
            "StockItemId": obj.get("StockItemId"),
            "StockItemIntId": obj.get("StockItemIntId")
        })
        return _obj


