# coding: utf-8

"""
    Stock API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: stock
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from linnworks_api.generated.stock.models.batch_picking_wave_stock_items import BatchPickingWaveStockItems
from typing import Optional, Set
from typing_extensions import Self

class StockTakeItemWithError(BaseModel):
    """
    StockTakeItemWithError
    """ # noqa: E501
    bin_rack: Optional[StrictStr] = Field(default=None, description="(optional) Only applicable to non-batched and non-WMS locations. Singular BinRack will be updated for the given item for a given location. Will be ignored for a batched or WMS item.", alias="BinRack")
    picking_wave_items: Optional[List[BatchPickingWaveStockItems]] = Field(default=None, description="(optional) Pickwave items associated with the batch. This data will be used for concurrency check and validation of data.   Super important stuff when you are submitting batch inventory stock count in WMS location.   Order items will automatically be allocated to a specific batch when the order is placed/printed/added to pickwave. This will normally block stock count,   however it is possible to get the state of pickwave items, and if all items are picked from the location the user can still count them. When stock count is submitted  we need to also submit the state of the pickwave at the point of count, so we can compare state was and the state is, discount any stock from the count that was processed/shipped   If this parameter is not supplied and the batch is allocated to orders, the stock count for this item will be blocked and will not be submitted", alias="PickingWaveItems")
    errors: Optional[List[StrictStr]] = Field(default=None, description="List of errors for specific stock take item", alias="Errors")
    stock_item_id: Optional[StrictStr] = Field(default=None, description="Stock Item Id", alias="StockItemId")
    quantity: Optional[StrictInt] = Field(default=None, description="Current stock level", alias="Quantity")
    original_quantity: Optional[StrictInt] = Field(default=None, description="(Optional) Original quantity, used to validate if the original has changed since the items have been counted. If supplied and different to expected then an error will be returned.", alias="OriginalQuantity")
    stock_value: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="(optional) Stock value (unit cost * quantity). If not provided it will be calculated from current stock value", alias="StockValue")
    batch_inventory_id: Optional[StrictInt] = Field(default=None, description="(conditional) If item is batched or in WMS location, you must provide BatchInventoryId which is being updated.   If its newly discovered item, use BookInStockBatch call in Stock controller to create a new batch inventory", alias="BatchInventoryId")
    __properties: ClassVar[List[str]] = ["BinRack", "PickingWaveItems", "Errors", "StockItemId", "Quantity", "OriginalQuantity", "StockValue", "BatchInventoryId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StockTakeItemWithError from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in picking_wave_items (list)
        _items = []
        if self.picking_wave_items:
            for _item_picking_wave_items in self.picking_wave_items:
                if _item_picking_wave_items:
                    _items.append(_item_picking_wave_items.to_dict())
            _dict['PickingWaveItems'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StockTakeItemWithError from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "BinRack": obj.get("BinRack"),
            "PickingWaveItems": [BatchPickingWaveStockItems.from_dict(_item) for _item in obj["PickingWaveItems"]] if obj.get("PickingWaveItems") is not None else None,
            "Errors": obj.get("Errors"),
            "StockItemId": obj.get("StockItemId"),
            "Quantity": obj.get("Quantity"),
            "OriginalQuantity": obj.get("OriginalQuantity"),
            "StockValue": obj.get("StockValue"),
            "BatchInventoryId": obj.get("BatchInventoryId")
        })
        return _obj


