# coding: utf-8

"""
    Stock API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: stock
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class UpdateStockLevelsBulkRequestItem(BaseModel):
    """
    UpdateStockLevelsBulkRequestItem
    """ # noqa: E501
    sku: Optional[StrictStr] = Field(default=None, description="SKU - Optional if stock item id is provided", alias="SKU")
    stock_item_id: Optional[StrictStr] = Field(default=None, description="StockItemId - Optional if stock SKU is provided, calls will be faster if this is provided.", alias="StockItemId")
    stock_location_name: Optional[StrictStr] = Field(default=None, description="Stock location name, optional if StockLocationId is provided.", alias="StockLocationName")
    stock_location_id: Optional[StrictStr] = Field(default=None, description="Stock Location Id, optional if StockLocationName is provided, calls will be faster if this is provided.", alias="StockLocationId")
    stock_level: Optional[StrictInt] = Field(default=None, description="StockLevel - Optional", alias="StockLevel")
    stock_value: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="StockValue - Optional, if unit cost is provided then value will be calculated from this, otherwise existing stock value or purchase price will be used.", alias="StockValue")
    unit_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="UnitCost - Optional, if stock value is provided then value will be calculated from this, otherwise existing stock value or purchase price will be used.", alias="UnitCost")
    binrack: Optional[StrictStr] = Field(default=None, description="Binrack - Optional, if not provided or empty exisitng binrack will remain.", alias="Binrack")
    minimum_level: Optional[StrictInt] = Field(default=None, description="Minimum level - Optional", alias="MinimumLevel")
    row_index: Optional[StrictInt] = Field(default=None, description="RowIndex - Optional, can be used to marry up request items with response items.", alias="RowIndex")
    __properties: ClassVar[List[str]] = ["SKU", "StockItemId", "StockLocationName", "StockLocationId", "StockLevel", "StockValue", "UnitCost", "Binrack", "MinimumLevel", "RowIndex"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateStockLevelsBulkRequestItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateStockLevelsBulkRequestItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "SKU": obj.get("SKU"),
            "StockItemId": obj.get("StockItemId"),
            "StockLocationName": obj.get("StockLocationName"),
            "StockLocationId": obj.get("StockLocationId"),
            "StockLevel": obj.get("StockLevel"),
            "StockValue": obj.get("StockValue"),
            "UnitCost": obj.get("UnitCost"),
            "Binrack": obj.get("Binrack"),
            "MinimumLevel": obj.get("MinimumLevel"),
            "RowIndex": obj.get("RowIndex")
        })
        return _obj


