# coding: utf-8

"""
    Stock API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: stock
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.stock.models.stock_item_batch import StockItemBatch
from linnworks_api.generated.stock.models.warehouse_bin_rack import WarehouseBinRack
from typing import Optional, Set
from typing_extensions import Self

class WarehouseMoveDetailed(BaseModel):
    """
    WarehouseMoveDetailed
    """ # noqa: E501
    binrack_from: Optional[WarehouseBinRack] = Field(default=None, alias="BinrackFrom")
    binrack_destination: Optional[WarehouseBinRack] = Field(default=None, alias="BinrackDestination")
    batch: Optional[StockItemBatch] = Field(default=None, alias="Batch")
    move_id: Optional[StrictInt] = Field(default=None, alias="MoveId")
    batch_inventory_id: Optional[StrictInt] = Field(default=None, alias="BatchInventoryId")
    quantity: Optional[StrictInt] = Field(default=None, alias="Quantity")
    user_id: Optional[StrictStr] = Field(default=None, alias="UserId")
    user_name: Optional[StrictStr] = Field(default=None, alias="UserName")
    binrack_id_from: Optional[StrictInt] = Field(default=None, alias="BinrackIdFrom")
    binrack_id_destination: Optional[StrictInt] = Field(default=None, alias="BinrackIdDestination")
    tx_type: Optional[StrictStr] = Field(default=None, alias="TxType")
    job_id: Optional[StrictInt] = Field(default=None, alias="JobId")
    create_date: Optional[datetime] = Field(default=None, alias="CreateDate")
    batch_id: Optional[StrictInt] = Field(default=None, alias="BatchId")
    stock_location_id: Optional[StrictStr] = Field(default=None, alias="StockLocationId")
    tot_id: Optional[StrictInt] = Field(default=None, alias="TotId")
    __properties: ClassVar[List[str]] = ["BinrackFrom", "BinrackDestination", "Batch", "MoveId", "BatchInventoryId", "Quantity", "UserId", "UserName", "BinrackIdFrom", "BinrackIdDestination", "TxType", "JobId", "CreateDate", "BatchId", "StockLocationId", "TotId"]

    @field_validator('tx_type')
    def tx_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Open', 'InTransit']):
            raise ValueError("must be one of enum values ('Open', 'InTransit')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WarehouseMoveDetailed from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of binrack_from
        if self.binrack_from:
            _dict['BinrackFrom'] = self.binrack_from.to_dict()
        # override the default output from pydantic by calling `to_dict()` of binrack_destination
        if self.binrack_destination:
            _dict['BinrackDestination'] = self.binrack_destination.to_dict()
        # override the default output from pydantic by calling `to_dict()` of batch
        if self.batch:
            _dict['Batch'] = self.batch.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WarehouseMoveDetailed from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "BinrackFrom": WarehouseBinRack.from_dict(obj["BinrackFrom"]) if obj.get("BinrackFrom") is not None else None,
            "BinrackDestination": WarehouseBinRack.from_dict(obj["BinrackDestination"]) if obj.get("BinrackDestination") is not None else None,
            "Batch": StockItemBatch.from_dict(obj["Batch"]) if obj.get("Batch") is not None else None,
            "MoveId": obj.get("MoveId"),
            "BatchInventoryId": obj.get("BatchInventoryId"),
            "Quantity": obj.get("Quantity"),
            "UserId": obj.get("UserId"),
            "UserName": obj.get("UserName"),
            "BinrackIdFrom": obj.get("BinrackIdFrom"),
            "BinrackIdDestination": obj.get("BinrackIdDestination"),
            "TxType": obj.get("TxType"),
            "JobId": obj.get("JobId"),
            "CreateDate": obj.get("CreateDate"),
            "BatchId": obj.get("BatchId"),
            "StockLocationId": obj.get("StockLocationId"),
            "TotId": obj.get("TotId")
        })
        return _obj


