# coding: utf-8

"""
    Warehouse Transfer (Legacy) API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: warehousetransfer
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.warehousetransfer.models.warehouse_transfer_item_note import WarehouseTransferItemNote
from typing import Optional, Set
from typing_extensions import Self

class WarehouseTransferItem(BaseModel):
    """
    WarehouseTransferItem
    """ # noqa: E501
    pk_transfer_item_id: Optional[StrictStr] = Field(default=None, alias="PkTransferItemId")
    fk_stock_item_id: Optional[StrictStr] = Field(default=None, alias="FkStockItemId")
    sku: Optional[StrictStr] = Field(default=None, alias="SKU")
    barcode: Optional[StrictStr] = Field(default=None, alias="Barcode")
    item_title: Optional[StrictStr] = Field(default=None, alias="ItemTitle")
    requested_quantity: Optional[StrictInt] = Field(default=None, alias="RequestedQuantity")
    sent_quantity: Optional[StrictInt] = Field(default=None, alias="SentQuantity")
    received_quantity: Optional[StrictInt] = Field(default=None, alias="ReceivedQuantity")
    in_from_location_quantity: Optional[StrictInt] = Field(default=None, alias="InFromLocationQuantity")
    due_from_location_quantity: Optional[StrictInt] = Field(default=None, alias="DueFromLocationQuantity")
    in_to_location_quantity: Optional[StrictInt] = Field(default=None, alias="InToLocationQuantity")
    item_note_count: Optional[StrictInt] = Field(default=None, alias="ItemNoteCount")
    bin_rack_number: Optional[StrictStr] = Field(default=None, alias="BinRackNumber")
    pk_bin_id: Optional[StrictStr] = Field(default=None, alias="PkBinId")
    item_notes: Optional[List[WarehouseTransferItemNote]] = Field(default=None, alias="ItemNotes")
    __properties: ClassVar[List[str]] = ["PkTransferItemId", "FkStockItemId", "SKU", "Barcode", "ItemTitle", "RequestedQuantity", "SentQuantity", "ReceivedQuantity", "InFromLocationQuantity", "DueFromLocationQuantity", "InToLocationQuantity", "ItemNoteCount", "BinRackNumber", "PkBinId", "ItemNotes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WarehouseTransferItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in item_notes (list)
        _items = []
        if self.item_notes:
            for _item_item_notes in self.item_notes:
                if _item_item_notes:
                    _items.append(_item_item_notes.to_dict())
            _dict['ItemNotes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WarehouseTransferItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "PkTransferItemId": obj.get("PkTransferItemId"),
            "FkStockItemId": obj.get("FkStockItemId"),
            "SKU": obj.get("SKU"),
            "Barcode": obj.get("Barcode"),
            "ItemTitle": obj.get("ItemTitle"),
            "RequestedQuantity": obj.get("RequestedQuantity"),
            "SentQuantity": obj.get("SentQuantity"),
            "ReceivedQuantity": obj.get("ReceivedQuantity"),
            "InFromLocationQuantity": obj.get("InFromLocationQuantity"),
            "DueFromLocationQuantity": obj.get("DueFromLocationQuantity"),
            "InToLocationQuantity": obj.get("InToLocationQuantity"),
            "ItemNoteCount": obj.get("ItemNoteCount"),
            "BinRackNumber": obj.get("BinRackNumber"),
            "PkBinId": obj.get("PkBinId"),
            "ItemNotes": [WarehouseTransferItemNote.from_dict(_item) for _item in obj["ItemNotes"]] if obj.get("ItemNotes") is not None else None
        })
        return _obj


