# coding: utf-8

"""
    Warehouse Transfer

    Warehouse Transfer v1

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import StrictInt, StrictStr
from typing import List, Optional
from linnworks_api.generated.warehousetransfer_new.models.create_shipment_item_in_bulk_request import CreateShipmentItemInBulkRequest
from linnworks_api.generated.warehousetransfer_new.models.delete_shipment_item_request import DeleteShipmentItemRequest
from linnworks_api.generated.warehousetransfer_new.models.get_prep_instructions_by_shipment_item_ids_response import GetPrepInstructionsByShipmentItemIdsResponse
from linnworks_api.generated.warehousetransfer_new.models.get_prep_instructions_by_shipping_plan_id_response import GetPrepInstructionsByShippingPlanIdResponse
from linnworks_api.generated.warehousetransfer_new.models.shipment_item_response import ShipmentItemResponse
from linnworks_api.generated.warehousetransfer_new.models.update_amazon_shipment_item_pack_quantity_request import UpdateAmazonShipmentItemPackQuantityRequest
from linnworks_api.generated.warehousetransfer_new.models.update_amazon_shipment_item_quantity_request import UpdateAmazonShipmentItemQuantityRequest
from linnworks_api.generated.warehousetransfer_new.models.update_pack_quantity_request import UpdatePackQuantityRequest
from linnworks_api.generated.warehousetransfer_new.models.update_pack_size_quantity_request import UpdatePackSizeQuantityRequest
from linnworks_api.generated.warehousetransfer_new.models.update_quantity_request import UpdateQuantityRequest
from linnworks_api.generated.warehousetransfer_new.models.update_quantity_result import UpdateQuantityResult
from linnworks_api.generated.warehousetransfer_new.models.update_shipment_item_prep_instruction_owner_request import UpdateShipmentItemPrepInstructionOwnerRequest
from linnworks_api.generated.warehousetransfer_new.models.update_shipment_item_prep_instruction_request import UpdateShipmentItemPrepInstructionRequest
from linnworks_api.generated.warehousetransfer_new.models.update_shipment_item_request import UpdateShipmentItemRequest

from linnworks_api.generated.warehousetransfer_new.api_client import ApiClient, RequestSerialized
from linnworks_api.generated.warehousetransfer_new.api_response import ApiResponse
from linnworks_api.generated.warehousetransfer_new.rest import RESTResponseType


class FbaShipmentItemApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipmentitems_get(
        self,
        shipping_plan_id: StrictInt,
        shipping_item_id: Optional[List[StrictInt]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[ShipmentItemResponse]:
        """(Deprecated) GetShipmentItemsByIds

        Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id:  (required)
        :type shipping_plan_id: int
        :param shipping_item_id: 
        :type shipping_item_id: List[int]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipmentitems is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipmentitems_get_serialize(
            shipping_plan_id=shipping_plan_id,
            shipping_item_id=shipping_item_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[ShipmentItemResponse]",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipmentitems_get_with_http_info(
        self,
        shipping_plan_id: StrictInt,
        shipping_item_id: Optional[List[StrictInt]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[ShipmentItemResponse]]:
        """(Deprecated) GetShipmentItemsByIds

        Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id:  (required)
        :type shipping_plan_id: int
        :param shipping_item_id: 
        :type shipping_item_id: List[int]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipmentitems is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipmentitems_get_serialize(
            shipping_plan_id=shipping_plan_id,
            shipping_item_id=shipping_item_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[ShipmentItemResponse]",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipmentitems_get_without_preload_content(
        self,
        shipping_plan_id: StrictInt,
        shipping_item_id: Optional[List[StrictInt]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) GetShipmentItemsByIds

        Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id:  (required)
        :type shipping_plan_id: int
        :param shipping_item_id: 
        :type shipping_item_id: List[int]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipmentitems is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipmentitems_get_serialize(
            shipping_plan_id=shipping_plan_id,
            shipping_item_id=shipping_item_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[ShipmentItemResponse]",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipmentitems_get_serialize(
        self,
        shipping_plan_id,
        shipping_item_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'shippingItemId': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if shipping_plan_id is not None:
            _path_params['shippingPlanId'] = shipping_plan_id
        # process the query parameters
        if shipping_item_id is not None:
            
            _query_params.append(('shippingItemId', shipping_item_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Linnworks'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipmentitems',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_delete(
        self,
        shipping_plan_id: StrictStr,
        delete_shipment_item_request: Optional[DeleteShipmentItemRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """(Deprecated) DeleteShipmentItem

        Used to delete shipment items in batch<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id: (required)
        :type shipping_plan_id: str
        :param delete_shipment_item_request: 
        :type delete_shipment_item_request: DeleteShipmentItemRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("DELETE /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_delete_serialize(
            shipping_plan_id=shipping_plan_id,
            delete_shipment_item_request=delete_shipment_item_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_delete_with_http_info(
        self,
        shipping_plan_id: StrictStr,
        delete_shipment_item_request: Optional[DeleteShipmentItemRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """(Deprecated) DeleteShipmentItem

        Used to delete shipment items in batch<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id: (required)
        :type shipping_plan_id: str
        :param delete_shipment_item_request: 
        :type delete_shipment_item_request: DeleteShipmentItemRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("DELETE /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_delete_serialize(
            shipping_plan_id=shipping_plan_id,
            delete_shipment_item_request=delete_shipment_item_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_delete_without_preload_content(
        self,
        shipping_plan_id: StrictStr,
        delete_shipment_item_request: Optional[DeleteShipmentItemRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) DeleteShipmentItem

        Used to delete shipment items in batch<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id: (required)
        :type shipping_plan_id: str
        :param delete_shipment_item_request: 
        :type delete_shipment_item_request: DeleteShipmentItemRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("DELETE /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_delete_serialize(
            shipping_plan_id=shipping_plan_id,
            delete_shipment_item_request=delete_shipment_item_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_delete_serialize(
        self,
        shipping_plan_id,
        delete_shipment_item_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if shipping_plan_id is not None:
            _path_params['shippingPlanId'] = shipping_plan_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if delete_shipment_item_request is not None:
            _body_params = delete_shipment_item_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json-patch+json; x-api-version=1.0', 
                        'application/json; x-api-version=1.0', 
                        'text/json; x-api-version=1.0', 
                        'application/*+json; x-api-version=1.0'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Linnworks'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_get(
        self,
        shipping_plan_id: StrictInt,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[ShipmentItemResponse]:
        """(Deprecated) GetShipmentItems

        Used to get shipment items by shipping plan id<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id:  (required)
        :type shipping_plan_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_get_serialize(
            shipping_plan_id=shipping_plan_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[ShipmentItemResponse]",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_get_with_http_info(
        self,
        shipping_plan_id: StrictInt,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[ShipmentItemResponse]]:
        """(Deprecated) GetShipmentItems

        Used to get shipment items by shipping plan id<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id:  (required)
        :type shipping_plan_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_get_serialize(
            shipping_plan_id=shipping_plan_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[ShipmentItemResponse]",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_get_without_preload_content(
        self,
        shipping_plan_id: StrictInt,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) GetShipmentItems

        Used to get shipment items by shipping plan id<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id:  (required)
        :type shipping_plan_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_get_serialize(
            shipping_plan_id=shipping_plan_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[ShipmentItemResponse]",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_get_serialize(
        self,
        shipping_plan_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if shipping_plan_id is not None:
            _path_params['shippingPlanId'] = shipping_plan_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Linnworks'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_post(
        self,
        shipping_plan_id: StrictInt,
        create_shipment_item_in_bulk_request: Optional[CreateShipmentItemInBulkRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[ShipmentItemResponse]:
        """(Deprecated) CreateShipmentItemBatch

        Used to create shipment items in batch<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id:  (required)
        :type shipping_plan_id: int
        :param create_shipment_item_in_bulk_request: 
        :type create_shipment_item_in_bulk_request: CreateShipmentItemInBulkRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("POST /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_post_serialize(
            shipping_plan_id=shipping_plan_id,
            create_shipment_item_in_bulk_request=create_shipment_item_in_bulk_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[ShipmentItemResponse]",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_post_with_http_info(
        self,
        shipping_plan_id: StrictInt,
        create_shipment_item_in_bulk_request: Optional[CreateShipmentItemInBulkRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[ShipmentItemResponse]]:
        """(Deprecated) CreateShipmentItemBatch

        Used to create shipment items in batch<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id:  (required)
        :type shipping_plan_id: int
        :param create_shipment_item_in_bulk_request: 
        :type create_shipment_item_in_bulk_request: CreateShipmentItemInBulkRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("POST /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_post_serialize(
            shipping_plan_id=shipping_plan_id,
            create_shipment_item_in_bulk_request=create_shipment_item_in_bulk_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[ShipmentItemResponse]",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_post_without_preload_content(
        self,
        shipping_plan_id: StrictInt,
        create_shipment_item_in_bulk_request: Optional[CreateShipmentItemInBulkRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) CreateShipmentItemBatch

        Used to create shipment items in batch<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id:  (required)
        :type shipping_plan_id: int
        :param create_shipment_item_in_bulk_request: 
        :type create_shipment_item_in_bulk_request: CreateShipmentItemInBulkRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("POST /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_post_serialize(
            shipping_plan_id=shipping_plan_id,
            create_shipment_item_in_bulk_request=create_shipment_item_in_bulk_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[ShipmentItemResponse]",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_post_serialize(
        self,
        shipping_plan_id,
        create_shipment_item_in_bulk_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if shipping_plan_id is not None:
            _path_params['shippingPlanId'] = shipping_plan_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_shipment_item_in_bulk_request is not None:
            _body_params = create_shipment_item_in_bulk_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json-patch+json; x-api-version=1.0', 
                        'application/json; x-api-version=1.0', 
                        'text/json; x-api-version=1.0', 
                        'application/*+json; x-api-version=1.0'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Linnworks'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_prep_instruction_by_shipmentitemids_get(
        self,
        shipping_plan_id: StrictInt,
        shipment_item_ids: Optional[List[StrictInt]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetPrepInstructionsByShipmentItemIdsResponse:
        """(Deprecated) GetPrepInstructionsByShipmentItemIds

        Used to retrieve prepare instructions for sku list<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id: (required)
        :type shipping_plan_id: int
        :param shipment_item_ids:
        :type shipment_item_ids: List[int]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems/prep-instruction-by-shipmentitemids is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_prep_instruction_by_shipmentitemids_get_serialize(
            shipping_plan_id=shipping_plan_id,
            shipment_item_ids=shipment_item_ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetPrepInstructionsByShipmentItemIdsResponse",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_prep_instruction_by_shipmentitemids_get_with_http_info(
        self,
        shipping_plan_id: StrictInt,
        shipment_item_ids: Optional[List[StrictInt]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetPrepInstructionsByShipmentItemIdsResponse]:
        """(Deprecated) GetPrepInstructionsByShipmentItemIds

        Used to retrieve prepare instructions for sku list<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id: (required)
        :type shipping_plan_id: int
        :param shipment_item_ids:
        :type shipment_item_ids: List[int]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems/prep-instruction-by-shipmentitemids is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_prep_instruction_by_shipmentitemids_get_serialize(
            shipping_plan_id=shipping_plan_id,
            shipment_item_ids=shipment_item_ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetPrepInstructionsByShipmentItemIdsResponse",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_prep_instruction_by_shipmentitemids_get_without_preload_content(
        self,
        shipping_plan_id: StrictInt,
        shipment_item_ids: Optional[List[StrictInt]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) GetPrepInstructionsByShipmentItemIds

        Used to retrieve prepare instructions for sku list<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id: (required)
        :type shipping_plan_id: int
        :param shipment_item_ids:
        :type shipment_item_ids: List[int]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems/prep-instruction-by-shipmentitemids is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_prep_instruction_by_shipmentitemids_get_serialize(
            shipping_plan_id=shipping_plan_id,
            shipment_item_ids=shipment_item_ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetPrepInstructionsByShipmentItemIdsResponse",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_prep_instruction_by_shipmentitemids_get_serialize(
        self,
        shipping_plan_id,
        shipment_item_ids,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'shipmentItemIds': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if shipping_plan_id is not None:
            _path_params['shippingPlanId'] = shipping_plan_id
        # process the query parameters
        if shipment_item_ids is not None:
            
            _query_params.append(('shipmentItemIds', shipment_item_ids))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Linnworks'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems/prep-instruction-by-shipmentitemids',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_prep_instruction_get(
        self,
        shipping_plan_id: StrictInt,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetPrepInstructionsByShippingPlanIdResponse:
        """(Deprecated) GetPrepInstructionsByShippingPlanId

        Used to retrieve prepare instructions for sku list<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id: (required)
        :type shipping_plan_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems/prep-instruction is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_prep_instruction_get_serialize(
            shipping_plan_id=shipping_plan_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetPrepInstructionsByShippingPlanIdResponse",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_prep_instruction_get_with_http_info(
        self,
        shipping_plan_id: StrictInt,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetPrepInstructionsByShippingPlanIdResponse]:
        """(Deprecated) GetPrepInstructionsByShippingPlanId

        Used to retrieve prepare instructions for sku list<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id: (required)
        :type shipping_plan_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems/prep-instruction is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_prep_instruction_get_serialize(
            shipping_plan_id=shipping_plan_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetPrepInstructionsByShippingPlanIdResponse",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_prep_instruction_get_without_preload_content(
        self,
        shipping_plan_id: StrictInt,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) GetPrepInstructionsByShippingPlanId

        Used to retrieve prepare instructions for sku list<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id: (required)
        :type shipping_plan_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems/prep-instruction is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_prep_instruction_get_serialize(
            shipping_plan_id=shipping_plan_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetPrepInstructionsByShippingPlanIdResponse",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_prep_instruction_get_serialize(
        self,
        shipping_plan_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if shipping_plan_id is not None:
            _path_params['shippingPlanId'] = shipping_plan_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Linnworks'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems/prep-instruction',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_shipment_item_id_amazon_pack_quantity_put(
        self,
        shipping_plan_id: StrictInt,
        shipment_item_id: StrictInt,
        update_amazon_shipment_item_pack_quantity_request: Optional[UpdateAmazonShipmentItemPackQuantityRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """(Deprecated) UpdateAmazonShipmentItemPackQuantity

        Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id:  (required)
        :type shipping_plan_id: int
        :param shipment_item_id:  (required)
        :type shipment_item_id: int
        :param update_amazon_shipment_item_pack_quantity_request: 
        :type update_amazon_shipment_item_pack_quantity_request: UpdateAmazonShipmentItemPackQuantityRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems/{shipmentItemId}/amazon-pack-quantity is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_shipment_item_id_amazon_pack_quantity_put_serialize(
            shipping_plan_id=shipping_plan_id,
            shipment_item_id=shipment_item_id,
            update_amazon_shipment_item_pack_quantity_request=update_amazon_shipment_item_pack_quantity_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_shipment_item_id_amazon_pack_quantity_put_with_http_info(
        self,
        shipping_plan_id: StrictInt,
        shipment_item_id: StrictInt,
        update_amazon_shipment_item_pack_quantity_request: Optional[UpdateAmazonShipmentItemPackQuantityRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """(Deprecated) UpdateAmazonShipmentItemPackQuantity

        Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id:  (required)
        :type shipping_plan_id: int
        :param shipment_item_id:  (required)
        :type shipment_item_id: int
        :param update_amazon_shipment_item_pack_quantity_request: 
        :type update_amazon_shipment_item_pack_quantity_request: UpdateAmazonShipmentItemPackQuantityRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems/{shipmentItemId}/amazon-pack-quantity is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_shipment_item_id_amazon_pack_quantity_put_serialize(
            shipping_plan_id=shipping_plan_id,
            shipment_item_id=shipment_item_id,
            update_amazon_shipment_item_pack_quantity_request=update_amazon_shipment_item_pack_quantity_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_shipment_item_id_amazon_pack_quantity_put_without_preload_content(
        self,
        shipping_plan_id: StrictInt,
        shipment_item_id: StrictInt,
        update_amazon_shipment_item_pack_quantity_request: Optional[UpdateAmazonShipmentItemPackQuantityRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) UpdateAmazonShipmentItemPackQuantity

        Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id:  (required)
        :type shipping_plan_id: int
        :param shipment_item_id:  (required)
        :type shipment_item_id: int
        :param update_amazon_shipment_item_pack_quantity_request: 
        :type update_amazon_shipment_item_pack_quantity_request: UpdateAmazonShipmentItemPackQuantityRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems/{shipmentItemId}/amazon-pack-quantity is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_shipment_item_id_amazon_pack_quantity_put_serialize(
            shipping_plan_id=shipping_plan_id,
            shipment_item_id=shipment_item_id,
            update_amazon_shipment_item_pack_quantity_request=update_amazon_shipment_item_pack_quantity_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_shipment_item_id_amazon_pack_quantity_put_serialize(
        self,
        shipping_plan_id,
        shipment_item_id,
        update_amazon_shipment_item_pack_quantity_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if shipping_plan_id is not None:
            _path_params['shippingPlanId'] = shipping_plan_id
        if shipment_item_id is not None:
            _path_params['shipmentItemId'] = shipment_item_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_amazon_shipment_item_pack_quantity_request is not None:
            _body_params = update_amazon_shipment_item_pack_quantity_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json-patch+json; x-api-version=1.0', 
                        'application/json; x-api-version=1.0', 
                        'text/json; x-api-version=1.0', 
                        'application/*+json; x-api-version=1.0'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Linnworks'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems/{shipmentItemId}/amazon-pack-quantity',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_shipment_item_id_amazon_quantity_put(
        self,
        shipping_plan_id: StrictInt,
        shipment_item_id: StrictInt,
        update_amazon_shipment_item_quantity_request: Optional[UpdateAmazonShipmentItemQuantityRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """(Deprecated) UpdateAmazonShipmentItemQuantity

        Used to update quantity to ship in shipment item and on amazon<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id: (required)
        :type shipping_plan_id: int
        :param shipment_item_id: (required)
        :type shipment_item_id: int
        :param update_amazon_shipment_item_quantity_request: 
        :type update_amazon_shipment_item_quantity_request: UpdateAmazonShipmentItemQuantityRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems/{shipmentItemId}/amazon-quantity is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_shipment_item_id_amazon_quantity_put_serialize(
            shipping_plan_id=shipping_plan_id,
            shipment_item_id=shipment_item_id,
            update_amazon_shipment_item_quantity_request=update_amazon_shipment_item_quantity_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_shipment_item_id_amazon_quantity_put_with_http_info(
        self,
        shipping_plan_id: StrictInt,
        shipment_item_id: StrictInt,
        update_amazon_shipment_item_quantity_request: Optional[UpdateAmazonShipmentItemQuantityRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """(Deprecated) UpdateAmazonShipmentItemQuantity

        Used to update quantity to ship in shipment item and on amazon<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id: (required)
        :type shipping_plan_id: int
        :param shipment_item_id: (required)
        :type shipment_item_id: int
        :param update_amazon_shipment_item_quantity_request: 
        :type update_amazon_shipment_item_quantity_request: UpdateAmazonShipmentItemQuantityRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems/{shipmentItemId}/amazon-quantity is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_shipment_item_id_amazon_quantity_put_serialize(
            shipping_plan_id=shipping_plan_id,
            shipment_item_id=shipment_item_id,
            update_amazon_shipment_item_quantity_request=update_amazon_shipment_item_quantity_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_shipment_item_id_amazon_quantity_put_without_preload_content(
        self,
        shipping_plan_id: StrictInt,
        shipment_item_id: StrictInt,
        update_amazon_shipment_item_quantity_request: Optional[UpdateAmazonShipmentItemQuantityRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) UpdateAmazonShipmentItemQuantity

        Used to update quantity to ship in shipment item and on amazon<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id: (required)
        :type shipping_plan_id: int
        :param shipment_item_id: (required)
        :type shipment_item_id: int
        :param update_amazon_shipment_item_quantity_request: 
        :type update_amazon_shipment_item_quantity_request: UpdateAmazonShipmentItemQuantityRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems/{shipmentItemId}/amazon-quantity is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_shipment_item_id_amazon_quantity_put_serialize(
            shipping_plan_id=shipping_plan_id,
            shipment_item_id=shipment_item_id,
            update_amazon_shipment_item_quantity_request=update_amazon_shipment_item_quantity_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_shipment_item_id_amazon_quantity_put_serialize(
        self,
        shipping_plan_id,
        shipment_item_id,
        update_amazon_shipment_item_quantity_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if shipping_plan_id is not None:
            _path_params['shippingPlanId'] = shipping_plan_id
        if shipment_item_id is not None:
            _path_params['shipmentItemId'] = shipment_item_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_amazon_shipment_item_quantity_request is not None:
            _body_params = update_amazon_shipment_item_quantity_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json-patch+json; x-api-version=1.0', 
                        'application/json; x-api-version=1.0', 
                        'text/json; x-api-version=1.0', 
                        'application/*+json; x-api-version=1.0'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Linnworks'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems/{shipmentItemId}/amazon-quantity',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_shipment_item_id_pack_quantity_put(
        self,
        shipping_plan_id: StrictInt,
        shipment_item_id: StrictInt,
        update_pack_quantity_request: Optional[UpdatePackQuantityRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> UpdateQuantityResult:
        """(Deprecated) UpdatePackQuantity

        Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id:  (required)
        :type shipping_plan_id: int
        :param shipment_item_id:  (required)
        :type shipment_item_id: int
        :param update_pack_quantity_request: 
        :type update_pack_quantity_request: UpdatePackQuantityRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems/{shipmentItemId}/pack-quantity is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_shipment_item_id_pack_quantity_put_serialize(
            shipping_plan_id=shipping_plan_id,
            shipment_item_id=shipment_item_id,
            update_pack_quantity_request=update_pack_quantity_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateQuantityResult",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_shipment_item_id_pack_quantity_put_with_http_info(
        self,
        shipping_plan_id: StrictInt,
        shipment_item_id: StrictInt,
        update_pack_quantity_request: Optional[UpdatePackQuantityRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[UpdateQuantityResult]:
        """(Deprecated) UpdatePackQuantity

        Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id:  (required)
        :type shipping_plan_id: int
        :param shipment_item_id:  (required)
        :type shipment_item_id: int
        :param update_pack_quantity_request: 
        :type update_pack_quantity_request: UpdatePackQuantityRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems/{shipmentItemId}/pack-quantity is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_shipment_item_id_pack_quantity_put_serialize(
            shipping_plan_id=shipping_plan_id,
            shipment_item_id=shipment_item_id,
            update_pack_quantity_request=update_pack_quantity_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateQuantityResult",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_shipment_item_id_pack_quantity_put_without_preload_content(
        self,
        shipping_plan_id: StrictInt,
        shipment_item_id: StrictInt,
        update_pack_quantity_request: Optional[UpdatePackQuantityRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) UpdatePackQuantity

        Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id:  (required)
        :type shipping_plan_id: int
        :param shipment_item_id:  (required)
        :type shipment_item_id: int
        :param update_pack_quantity_request: 
        :type update_pack_quantity_request: UpdatePackQuantityRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems/{shipmentItemId}/pack-quantity is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_shipment_item_id_pack_quantity_put_serialize(
            shipping_plan_id=shipping_plan_id,
            shipment_item_id=shipment_item_id,
            update_pack_quantity_request=update_pack_quantity_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateQuantityResult",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_shipment_item_id_pack_quantity_put_serialize(
        self,
        shipping_plan_id,
        shipment_item_id,
        update_pack_quantity_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if shipping_plan_id is not None:
            _path_params['shippingPlanId'] = shipping_plan_id
        if shipment_item_id is not None:
            _path_params['shipmentItemId'] = shipment_item_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_pack_quantity_request is not None:
            _body_params = update_pack_quantity_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json-patch+json; x-api-version=1.0', 
                        'application/json; x-api-version=1.0', 
                        'text/json; x-api-version=1.0', 
                        'application/*+json; x-api-version=1.0'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Linnworks'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems/{shipmentItemId}/pack-quantity',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_shipment_item_id_pack_size_put(
        self,
        shipping_plan_id: StrictInt,
        shipment_item_id: StrictInt,
        update_pack_size_quantity_request: Optional[UpdatePackSizeQuantityRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bool:
        """(Deprecated) UpdatePackSize

        Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id:  (required)
        :type shipping_plan_id: int
        :param shipment_item_id:  (required)
        :type shipment_item_id: int
        :param update_pack_size_quantity_request: 
        :type update_pack_size_quantity_request: UpdatePackSizeQuantityRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems/{shipmentItemId}/pack-size is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_shipment_item_id_pack_size_put_serialize(
            shipping_plan_id=shipping_plan_id,
            shipment_item_id=shipment_item_id,
            update_pack_size_quantity_request=update_pack_size_quantity_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bool",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_shipment_item_id_pack_size_put_with_http_info(
        self,
        shipping_plan_id: StrictInt,
        shipment_item_id: StrictInt,
        update_pack_size_quantity_request: Optional[UpdatePackSizeQuantityRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bool]:
        """(Deprecated) UpdatePackSize

        Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id:  (required)
        :type shipping_plan_id: int
        :param shipment_item_id:  (required)
        :type shipment_item_id: int
        :param update_pack_size_quantity_request: 
        :type update_pack_size_quantity_request: UpdatePackSizeQuantityRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems/{shipmentItemId}/pack-size is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_shipment_item_id_pack_size_put_serialize(
            shipping_plan_id=shipping_plan_id,
            shipment_item_id=shipment_item_id,
            update_pack_size_quantity_request=update_pack_size_quantity_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bool",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_shipment_item_id_pack_size_put_without_preload_content(
        self,
        shipping_plan_id: StrictInt,
        shipment_item_id: StrictInt,
        update_pack_size_quantity_request: Optional[UpdatePackSizeQuantityRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) UpdatePackSize

        Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id:  (required)
        :type shipping_plan_id: int
        :param shipment_item_id:  (required)
        :type shipment_item_id: int
        :param update_pack_size_quantity_request: 
        :type update_pack_size_quantity_request: UpdatePackSizeQuantityRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems/{shipmentItemId}/pack-size is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_shipment_item_id_pack_size_put_serialize(
            shipping_plan_id=shipping_plan_id,
            shipment_item_id=shipment_item_id,
            update_pack_size_quantity_request=update_pack_size_quantity_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bool",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_shipment_item_id_pack_size_put_serialize(
        self,
        shipping_plan_id,
        shipment_item_id,
        update_pack_size_quantity_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if shipping_plan_id is not None:
            _path_params['shippingPlanId'] = shipping_plan_id
        if shipment_item_id is not None:
            _path_params['shipmentItemId'] = shipment_item_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_pack_size_quantity_request is not None:
            _body_params = update_pack_size_quantity_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json-patch+json; x-api-version=1.0', 
                        'application/json; x-api-version=1.0', 
                        'text/json; x-api-version=1.0', 
                        'application/*+json; x-api-version=1.0'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Linnworks'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems/{shipmentItemId}/pack-size',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_shipment_item_id_put(
        self,
        shipment_item_id: StrictInt,
        shipping_plan_id: StrictStr,
        update_shipment_item_request: Optional[UpdateShipmentItemRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """(Deprecated) UpdateShipmentItem

        Used to update shipment item<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipment_item_id:  (required)
        :type shipment_item_id: int
        :param shipping_plan_id: (required)
        :type shipping_plan_id: str
        :param update_shipment_item_request: 
        :type update_shipment_item_request: UpdateShipmentItemRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems/{shipmentItemId} is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_shipment_item_id_put_serialize(
            shipment_item_id=shipment_item_id,
            shipping_plan_id=shipping_plan_id,
            update_shipment_item_request=update_shipment_item_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_shipment_item_id_put_with_http_info(
        self,
        shipment_item_id: StrictInt,
        shipping_plan_id: StrictStr,
        update_shipment_item_request: Optional[UpdateShipmentItemRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """(Deprecated) UpdateShipmentItem

        Used to update shipment item<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipment_item_id:  (required)
        :type shipment_item_id: int
        :param shipping_plan_id: (required)
        :type shipping_plan_id: str
        :param update_shipment_item_request: 
        :type update_shipment_item_request: UpdateShipmentItemRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems/{shipmentItemId} is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_shipment_item_id_put_serialize(
            shipment_item_id=shipment_item_id,
            shipping_plan_id=shipping_plan_id,
            update_shipment_item_request=update_shipment_item_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_shipment_item_id_put_without_preload_content(
        self,
        shipment_item_id: StrictInt,
        shipping_plan_id: StrictStr,
        update_shipment_item_request: Optional[UpdateShipmentItemRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) UpdateShipmentItem

        Used to update shipment item<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipment_item_id:  (required)
        :type shipment_item_id: int
        :param shipping_plan_id: (required)
        :type shipping_plan_id: str
        :param update_shipment_item_request: 
        :type update_shipment_item_request: UpdateShipmentItemRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems/{shipmentItemId} is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_shipment_item_id_put_serialize(
            shipment_item_id=shipment_item_id,
            shipping_plan_id=shipping_plan_id,
            update_shipment_item_request=update_shipment_item_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_shipment_item_id_put_serialize(
        self,
        shipment_item_id,
        shipping_plan_id,
        update_shipment_item_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if shipment_item_id is not None:
            _path_params['shipmentItemId'] = shipment_item_id
        if shipping_plan_id is not None:
            _path_params['shippingPlanId'] = shipping_plan_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_shipment_item_request is not None:
            _body_params = update_shipment_item_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json-patch+json; x-api-version=1.0', 
                        'application/json; x-api-version=1.0', 
                        'text/json; x-api-version=1.0', 
                        'application/*+json; x-api-version=1.0'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Linnworks'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems/{shipmentItemId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_shipment_item_id_quantity_put(
        self,
        shipping_plan_id: StrictStr,
        shipment_item_id: StrictStr,
        update_quantity_request: Optional[UpdateQuantityRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """(Deprecated) UpdateQuantity

        Used to update quantity to ship in shipment item<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id: (required)
        :type shipping_plan_id: str
        :param shipment_item_id: (required)
        :type shipment_item_id: str
        :param update_quantity_request: 
        :type update_quantity_request: UpdateQuantityRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems/{shipmentItemId}/quantity is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_shipment_item_id_quantity_put_serialize(
            shipping_plan_id=shipping_plan_id,
            shipment_item_id=shipment_item_id,
            update_quantity_request=update_quantity_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_shipment_item_id_quantity_put_with_http_info(
        self,
        shipping_plan_id: StrictStr,
        shipment_item_id: StrictStr,
        update_quantity_request: Optional[UpdateQuantityRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """(Deprecated) UpdateQuantity

        Used to update quantity to ship in shipment item<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id: (required)
        :type shipping_plan_id: str
        :param shipment_item_id: (required)
        :type shipment_item_id: str
        :param update_quantity_request: 
        :type update_quantity_request: UpdateQuantityRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems/{shipmentItemId}/quantity is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_shipment_item_id_quantity_put_serialize(
            shipping_plan_id=shipping_plan_id,
            shipment_item_id=shipment_item_id,
            update_quantity_request=update_quantity_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_shipment_item_id_quantity_put_without_preload_content(
        self,
        shipping_plan_id: StrictStr,
        shipment_item_id: StrictStr,
        update_quantity_request: Optional[UpdateQuantityRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) UpdateQuantity

        Used to update quantity to ship in shipment item<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id: (required)
        :type shipping_plan_id: str
        :param shipment_item_id: (required)
        :type shipment_item_id: str
        :param update_quantity_request: 
        :type update_quantity_request: UpdateQuantityRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems/{shipmentItemId}/quantity is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_shipment_item_id_quantity_put_serialize(
            shipping_plan_id=shipping_plan_id,
            shipment_item_id=shipment_item_id,
            update_quantity_request=update_quantity_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_shipment_item_id_quantity_put_serialize(
        self,
        shipping_plan_id,
        shipment_item_id,
        update_quantity_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if shipping_plan_id is not None:
            _path_params['shippingPlanId'] = shipping_plan_id
        if shipment_item_id is not None:
            _path_params['shipmentItemId'] = shipment_item_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_quantity_request is not None:
            _body_params = update_quantity_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json-patch+json; x-api-version=1.0', 
                        'application/json; x-api-version=1.0', 
                        'text/json; x-api-version=1.0', 
                        'application/*+json; x-api-version=1.0'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Linnworks'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems/{shipmentItemId}/quantity',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_update_shipment_item_prep_instruction_owner_put(
        self,
        shipping_plan_id: StrictStr,
        update_shipment_item_prep_instruction_owner_request: Optional[UpdateShipmentItemPrepInstructionOwnerRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """(Deprecated) UpdateShippingItemWhoLabelPrep

        update prep owner for shipment item<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id: (required)
        :type shipping_plan_id: str
        :param update_shipment_item_prep_instruction_owner_request: 
        :type update_shipment_item_prep_instruction_owner_request: UpdateShipmentItemPrepInstructionOwnerRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems/update-shipment-item-prep-instruction-owner is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_update_shipment_item_prep_instruction_owner_put_serialize(
            shipping_plan_id=shipping_plan_id,
            update_shipment_item_prep_instruction_owner_request=update_shipment_item_prep_instruction_owner_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_update_shipment_item_prep_instruction_owner_put_with_http_info(
        self,
        shipping_plan_id: StrictStr,
        update_shipment_item_prep_instruction_owner_request: Optional[UpdateShipmentItemPrepInstructionOwnerRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """(Deprecated) UpdateShippingItemWhoLabelPrep

        update prep owner for shipment item<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id: (required)
        :type shipping_plan_id: str
        :param update_shipment_item_prep_instruction_owner_request: 
        :type update_shipment_item_prep_instruction_owner_request: UpdateShipmentItemPrepInstructionOwnerRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems/update-shipment-item-prep-instruction-owner is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_update_shipment_item_prep_instruction_owner_put_serialize(
            shipping_plan_id=shipping_plan_id,
            update_shipment_item_prep_instruction_owner_request=update_shipment_item_prep_instruction_owner_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_update_shipment_item_prep_instruction_owner_put_without_preload_content(
        self,
        shipping_plan_id: StrictStr,
        update_shipment_item_prep_instruction_owner_request: Optional[UpdateShipmentItemPrepInstructionOwnerRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) UpdateShippingItemWhoLabelPrep

        update prep owner for shipment item<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id: (required)
        :type shipping_plan_id: str
        :param update_shipment_item_prep_instruction_owner_request: 
        :type update_shipment_item_prep_instruction_owner_request: UpdateShipmentItemPrepInstructionOwnerRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems/update-shipment-item-prep-instruction-owner is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_update_shipment_item_prep_instruction_owner_put_serialize(
            shipping_plan_id=shipping_plan_id,
            update_shipment_item_prep_instruction_owner_request=update_shipment_item_prep_instruction_owner_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_update_shipment_item_prep_instruction_owner_put_serialize(
        self,
        shipping_plan_id,
        update_shipment_item_prep_instruction_owner_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if shipping_plan_id is not None:
            _path_params['shippingPlanId'] = shipping_plan_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_shipment_item_prep_instruction_owner_request is not None:
            _body_params = update_shipment_item_prep_instruction_owner_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json-patch+json; x-api-version=1.0', 
                        'application/json; x-api-version=1.0', 
                        'text/json; x-api-version=1.0', 
                        'application/*+json; x-api-version=1.0'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Linnworks'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems/update-shipment-item-prep-instruction-owner',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_update_shipment_item_prep_instruction_put(
        self,
        shipping_plan_id: StrictStr,
        update_shipment_item_prep_instruction_request: Optional[UpdateShipmentItemPrepInstructionRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """(Deprecated) UpdateShipmentItemPrepInstruction

        update all prep instructions for shipment item<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id: (required)
        :type shipping_plan_id: str
        :param update_shipment_item_prep_instruction_request: 
        :type update_shipment_item_prep_instruction_request: UpdateShipmentItemPrepInstructionRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems/update-shipment-item-prep-instruction is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_update_shipment_item_prep_instruction_put_serialize(
            shipping_plan_id=shipping_plan_id,
            update_shipment_item_prep_instruction_request=update_shipment_item_prep_instruction_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_update_shipment_item_prep_instruction_put_with_http_info(
        self,
        shipping_plan_id: StrictStr,
        update_shipment_item_prep_instruction_request: Optional[UpdateShipmentItemPrepInstructionRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """(Deprecated) UpdateShipmentItemPrepInstruction

        update all prep instructions for shipment item<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id: (required)
        :type shipping_plan_id: str
        :param update_shipment_item_prep_instruction_request: 
        :type update_shipment_item_prep_instruction_request: UpdateShipmentItemPrepInstructionRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems/update-shipment-item-prep-instruction is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_update_shipment_item_prep_instruction_put_serialize(
            shipping_plan_id=shipping_plan_id,
            update_shipment_item_prep_instruction_request=update_shipment_item_prep_instruction_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_update_shipment_item_prep_instruction_put_without_preload_content(
        self,
        shipping_plan_id: StrictStr,
        update_shipment_item_prep_instruction_request: Optional[UpdateShipmentItemPrepInstructionRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) UpdateShipmentItemPrepInstruction

        update all prep instructions for shipment item<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id: (required)
        :type shipping_plan_id: str
        :param update_shipment_item_prep_instruction_request: 
        :type update_shipment_item_prep_instruction_request: UpdateShipmentItemPrepInstructionRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems/update-shipment-item-prep-instruction is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_update_shipment_item_prep_instruction_put_serialize(
            shipping_plan_id=shipping_plan_id,
            update_shipment_item_prep_instruction_request=update_shipment_item_prep_instruction_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_update_shipment_item_prep_instruction_put_serialize(
        self,
        shipping_plan_id,
        update_shipment_item_prep_instruction_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if shipping_plan_id is not None:
            _path_params['shippingPlanId'] = shipping_plan_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_shipment_item_prep_instruction_request is not None:
            _body_params = update_shipment_item_prep_instruction_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json-patch+json; x-api-version=1.0', 
                        'application/json; x-api-version=1.0', 
                        'text/json; x-api-version=1.0', 
                        'application/*+json; x-api-version=1.0'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Linnworks'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems/update-shipment-item-prep-instruction',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_update_shipping_plan_prep_instruction_put(
        self,
        shipping_plan_id: StrictInt,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """(Deprecated) UpdateShippingPlanPrepInstructionsByShippingPlanId

        Used to retrieve prepare instructions for sku list from Amazon and saves to db<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id: (required)
        :type shipping_plan_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems/update-shipping-plan-prep-instruction is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_update_shipping_plan_prep_instruction_put_serialize(
            shipping_plan_id=shipping_plan_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_update_shipping_plan_prep_instruction_put_with_http_info(
        self,
        shipping_plan_id: StrictInt,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """(Deprecated) UpdateShippingPlanPrepInstructionsByShippingPlanId

        Used to retrieve prepare instructions for sku list from Amazon and saves to db<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id: (required)
        :type shipping_plan_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems/update-shipping-plan-prep-instruction is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_update_shipping_plan_prep_instruction_put_serialize(
            shipping_plan_id=shipping_plan_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_update_shipping_plan_prep_instruction_put_without_preload_content(
        self,
        shipping_plan_id: StrictInt,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) UpdateShippingPlanPrepInstructionsByShippingPlanId

        Used to retrieve prepare instructions for sku list from Amazon and saves to db<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id: (required)
        :type shipping_plan_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems/update-shipping-plan-prep-instruction is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_update_shipping_plan_prep_instruction_put_serialize(
            shipping_plan_id=shipping_plan_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipmentitems_update_shipping_plan_prep_instruction_put_serialize(
        self,
        shipping_plan_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if shipping_plan_id is not None:
            _path_params['shippingPlanId'] = shipping_plan_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Linnworks'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/shipmentitems/update-shipping-plan-prep-instruction',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


