# coding: utf-8

"""
    Warehouse Transfer

    Warehouse Transfer v1

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import StrictInt, StrictStr
from typing import Optional
from linnworks_api.generated.warehousetransfer_new.models.amazon_page_type import AmazonPageType
from linnworks_api.generated.warehousetransfer_new.models.amazon_transport_document_response_model import AmazonTransportDocumentResponseModel
from linnworks_api.generated.warehousetransfer_new.models.save_transport_content_request import SaveTransportContentRequest

from linnworks_api.generated.warehousetransfer_new.api_client import ApiClient, RequestSerialized
from linnworks_api.generated.warehousetransfer_new.api_response import ApiResponse
from linnworks_api.generated.warehousetransfer_new.rest import RESTResponseType


class FbaShipmentTransportApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_billoflading_get(
        self,
        shipment_id: StrictInt,
        shipping_plan_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AmazonTransportDocumentResponseModel:
        """(Deprecated) GetBillOfLading

        Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipment_id:  (required)
        :type shipment_id: int
        :param shipping_plan_id: (required)
        :type shipping_plan_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/{shipmentId}/transport/billoflading is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_billoflading_get_serialize(
            shipment_id=shipment_id,
            shipping_plan_id=shipping_plan_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AmazonTransportDocumentResponseModel",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_billoflading_get_with_http_info(
        self,
        shipment_id: StrictInt,
        shipping_plan_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AmazonTransportDocumentResponseModel]:
        """(Deprecated) GetBillOfLading

        Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipment_id:  (required)
        :type shipment_id: int
        :param shipping_plan_id: (required)
        :type shipping_plan_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/{shipmentId}/transport/billoflading is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_billoflading_get_serialize(
            shipment_id=shipment_id,
            shipping_plan_id=shipping_plan_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AmazonTransportDocumentResponseModel",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_billoflading_get_without_preload_content(
        self,
        shipment_id: StrictInt,
        shipping_plan_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) GetBillOfLading

        Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipment_id:  (required)
        :type shipment_id: int
        :param shipping_plan_id: (required)
        :type shipping_plan_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/{shipmentId}/transport/billoflading is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_billoflading_get_serialize(
            shipment_id=shipment_id,
            shipping_plan_id=shipping_plan_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AmazonTransportDocumentResponseModel",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_billoflading_get_serialize(
        self,
        shipment_id,
        shipping_plan_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if shipment_id is not None:
            _path_params['shipmentId'] = shipment_id
        if shipping_plan_id is not None:
            _path_params['shippingPlanId'] = shipping_plan_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Linnworks'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/{shipmentId}/transport/billoflading',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_confirm_put(
        self,
        shipment_id: StrictInt,
        shipping_plan_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """(Deprecated) ConfirmTransportRequest

        Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipment_id:  (required)
        :type shipment_id: int
        :param shipping_plan_id: (required)
        :type shipping_plan_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/{shipmentId}/transport/confirm is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_confirm_put_serialize(
            shipment_id=shipment_id,
            shipping_plan_id=shipping_plan_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_confirm_put_with_http_info(
        self,
        shipment_id: StrictInt,
        shipping_plan_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """(Deprecated) ConfirmTransportRequest

        Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipment_id:  (required)
        :type shipment_id: int
        :param shipping_plan_id: (required)
        :type shipping_plan_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/{shipmentId}/transport/confirm is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_confirm_put_serialize(
            shipment_id=shipment_id,
            shipping_plan_id=shipping_plan_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_confirm_put_without_preload_content(
        self,
        shipment_id: StrictInt,
        shipping_plan_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) ConfirmTransportRequest

        Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipment_id:  (required)
        :type shipment_id: int
        :param shipping_plan_id: (required)
        :type shipping_plan_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/{shipmentId}/transport/confirm is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_confirm_put_serialize(
            shipment_id=shipment_id,
            shipping_plan_id=shipping_plan_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_confirm_put_serialize(
        self,
        shipment_id,
        shipping_plan_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if shipment_id is not None:
            _path_params['shipmentId'] = shipment_id
        if shipping_plan_id is not None:
            _path_params['shippingPlanId'] = shipping_plan_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Linnworks'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/{shipmentId}/transport/confirm',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_estimate_put(
        self,
        shipment_id: StrictInt,
        shipping_plan_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """(Deprecated) EstimateTransportContent

        Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipment_id:  (required)
        :type shipment_id: int
        :param shipping_plan_id: (required)
        :type shipping_plan_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/{shipmentId}/transport/estimate is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_estimate_put_serialize(
            shipment_id=shipment_id,
            shipping_plan_id=shipping_plan_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_estimate_put_with_http_info(
        self,
        shipment_id: StrictInt,
        shipping_plan_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """(Deprecated) EstimateTransportContent

        Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipment_id:  (required)
        :type shipment_id: int
        :param shipping_plan_id: (required)
        :type shipping_plan_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/{shipmentId}/transport/estimate is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_estimate_put_serialize(
            shipment_id=shipment_id,
            shipping_plan_id=shipping_plan_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_estimate_put_without_preload_content(
        self,
        shipment_id: StrictInt,
        shipping_plan_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) EstimateTransportContent

        Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipment_id:  (required)
        :type shipment_id: int
        :param shipping_plan_id: (required)
        :type shipping_plan_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/{shipmentId}/transport/estimate is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_estimate_put_serialize(
            shipment_id=shipment_id,
            shipping_plan_id=shipping_plan_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_estimate_put_serialize(
        self,
        shipment_id,
        shipping_plan_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if shipment_id is not None:
            _path_params['shipmentId'] = shipment_id
        if shipping_plan_id is not None:
            _path_params['shippingPlanId'] = shipping_plan_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Linnworks'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/{shipmentId}/transport/estimate',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_palletlabels_page_type_get(
        self,
        shipment_id: StrictInt,
        page_type: AmazonPageType,
        shipping_plan_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AmazonTransportDocumentResponseModel:
        """(Deprecated) GetPalletLabelsRequest

        Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipment_id:  (required)
        :type shipment_id: int
        :param page_type:  (required)
        :type page_type: AmazonPageType
        :param shipping_plan_id: (required)
        :type shipping_plan_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/{shipmentId}/transport/palletlabels/{pageType} is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_palletlabels_page_type_get_serialize(
            shipment_id=shipment_id,
            page_type=page_type,
            shipping_plan_id=shipping_plan_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AmazonTransportDocumentResponseModel",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_palletlabels_page_type_get_with_http_info(
        self,
        shipment_id: StrictInt,
        page_type: AmazonPageType,
        shipping_plan_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AmazonTransportDocumentResponseModel]:
        """(Deprecated) GetPalletLabelsRequest

        Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipment_id:  (required)
        :type shipment_id: int
        :param page_type:  (required)
        :type page_type: AmazonPageType
        :param shipping_plan_id: (required)
        :type shipping_plan_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/{shipmentId}/transport/palletlabels/{pageType} is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_palletlabels_page_type_get_serialize(
            shipment_id=shipment_id,
            page_type=page_type,
            shipping_plan_id=shipping_plan_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AmazonTransportDocumentResponseModel",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_palletlabels_page_type_get_without_preload_content(
        self,
        shipment_id: StrictInt,
        page_type: AmazonPageType,
        shipping_plan_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) GetPalletLabelsRequest

        Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipment_id:  (required)
        :type shipment_id: int
        :param page_type:  (required)
        :type page_type: AmazonPageType
        :param shipping_plan_id: (required)
        :type shipping_plan_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/{shipmentId}/transport/palletlabels/{pageType} is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_palletlabels_page_type_get_serialize(
            shipment_id=shipment_id,
            page_type=page_type,
            shipping_plan_id=shipping_plan_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AmazonTransportDocumentResponseModel",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_palletlabels_page_type_get_serialize(
        self,
        shipment_id,
        page_type,
        shipping_plan_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if shipment_id is not None:
            _path_params['shipmentId'] = shipment_id
        if page_type is not None:
            _path_params['pageType'] = page_type.value
        if shipping_plan_id is not None:
            _path_params['shippingPlanId'] = shipping_plan_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Linnworks'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/{shipmentId}/transport/palletlabels/{pageType}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_put(
        self,
        shipment_id: StrictInt,
        shipping_plan_id: StrictStr,
        save_transport_content_request: Optional[SaveTransportContentRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """(Deprecated) SubmitTransportContent

        Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipment_id:  (required)
        :type shipment_id: int
        :param shipping_plan_id: (required)
        :type shipping_plan_id: str
        :param save_transport_content_request: 
        :type save_transport_content_request: SaveTransportContentRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/{shipmentId}/transport is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_put_serialize(
            shipment_id=shipment_id,
            shipping_plan_id=shipping_plan_id,
            save_transport_content_request=save_transport_content_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_put_with_http_info(
        self,
        shipment_id: StrictInt,
        shipping_plan_id: StrictStr,
        save_transport_content_request: Optional[SaveTransportContentRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """(Deprecated) SubmitTransportContent

        Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipment_id:  (required)
        :type shipment_id: int
        :param shipping_plan_id: (required)
        :type shipping_plan_id: str
        :param save_transport_content_request: 
        :type save_transport_content_request: SaveTransportContentRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/{shipmentId}/transport is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_put_serialize(
            shipment_id=shipment_id,
            shipping_plan_id=shipping_plan_id,
            save_transport_content_request=save_transport_content_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_put_without_preload_content(
        self,
        shipment_id: StrictInt,
        shipping_plan_id: StrictStr,
        save_transport_content_request: Optional[SaveTransportContentRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) SubmitTransportContent

        Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipment_id:  (required)
        :type shipment_id: int
        :param shipping_plan_id: (required)
        :type shipping_plan_id: str
        :param save_transport_content_request: 
        :type save_transport_content_request: SaveTransportContentRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/{shipmentId}/transport is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_put_serialize(
            shipment_id=shipment_id,
            shipping_plan_id=shipping_plan_id,
            save_transport_content_request=save_transport_content_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_put_serialize(
        self,
        shipment_id,
        shipping_plan_id,
        save_transport_content_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if shipment_id is not None:
            _path_params['shipmentId'] = shipment_id
        if shipping_plan_id is not None:
            _path_params['shippingPlanId'] = shipping_plan_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if save_transport_content_request is not None:
            _body_params = save_transport_content_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json-patch+json; x-api-version=1.0', 
                        'application/json; x-api-version=1.0', 
                        'text/json; x-api-version=1.0', 
                        'application/*+json; x-api-version=1.0'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Linnworks'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/{shipmentId}/transport',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_uniquepackagelabels_page_type_get(
        self,
        shipment_id: StrictInt,
        page_type: AmazonPageType,
        shipping_plan_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AmazonTransportDocumentResponseModel:
        """(Deprecated) GetUniquePackageLabels

        Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipment_id:  (required)
        :type shipment_id: int
        :param page_type:  (required)
        :type page_type: AmazonPageType
        :param shipping_plan_id: (required)
        :type shipping_plan_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/{shipmentId}/transport/uniquepackagelabels/{pageType} is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_uniquepackagelabels_page_type_get_serialize(
            shipment_id=shipment_id,
            page_type=page_type,
            shipping_plan_id=shipping_plan_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AmazonTransportDocumentResponseModel",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_uniquepackagelabels_page_type_get_with_http_info(
        self,
        shipment_id: StrictInt,
        page_type: AmazonPageType,
        shipping_plan_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AmazonTransportDocumentResponseModel]:
        """(Deprecated) GetUniquePackageLabels

        Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipment_id:  (required)
        :type shipment_id: int
        :param page_type:  (required)
        :type page_type: AmazonPageType
        :param shipping_plan_id: (required)
        :type shipping_plan_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/{shipmentId}/transport/uniquepackagelabels/{pageType} is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_uniquepackagelabels_page_type_get_serialize(
            shipment_id=shipment_id,
            page_type=page_type,
            shipping_plan_id=shipping_plan_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AmazonTransportDocumentResponseModel",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_uniquepackagelabels_page_type_get_without_preload_content(
        self,
        shipment_id: StrictInt,
        page_type: AmazonPageType,
        shipping_plan_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) GetUniquePackageLabels

        Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipment_id:  (required)
        :type shipment_id: int
        :param page_type:  (required)
        :type page_type: AmazonPageType
        :param shipping_plan_id: (required)
        :type shipping_plan_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/{shipmentId}/transport/uniquepackagelabels/{pageType} is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_uniquepackagelabels_page_type_get_serialize(
            shipment_id=shipment_id,
            page_type=page_type,
            shipping_plan_id=shipping_plan_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AmazonTransportDocumentResponseModel",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_uniquepackagelabels_page_type_get_serialize(
        self,
        shipment_id,
        page_type,
        shipping_plan_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if shipment_id is not None:
            _path_params['shipmentId'] = shipment_id
        if page_type is not None:
            _path_params['pageType'] = page_type.value
        if shipping_plan_id is not None:
            _path_params['shippingPlanId'] = shipping_plan_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Linnworks'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/{shipmentId}/transport/uniquepackagelabels/{pageType}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_void_put(
        self,
        shipment_id: StrictInt,
        shipping_plan_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """(Deprecated) VoidTransportRequest

        Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipment_id:  (required)
        :type shipment_id: int
        :param shipping_plan_id: (required)
        :type shipping_plan_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/{shipmentId}/transport/void is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_void_put_serialize(
            shipment_id=shipment_id,
            shipping_plan_id=shipping_plan_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_void_put_with_http_info(
        self,
        shipment_id: StrictInt,
        shipping_plan_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """(Deprecated) VoidTransportRequest

        Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipment_id:  (required)
        :type shipment_id: int
        :param shipping_plan_id: (required)
        :type shipping_plan_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/{shipmentId}/transport/void is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_void_put_serialize(
            shipment_id=shipment_id,
            shipping_plan_id=shipping_plan_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_void_put_without_preload_content(
        self,
        shipment_id: StrictInt,
        shipping_plan_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) VoidTransportRequest

        Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipment_id:  (required)
        :type shipment_id: int
        :param shipping_plan_id: (required)
        :type shipping_plan_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/{shipmentId}/transport/void is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_void_put_serialize(
            shipment_id=shipment_id,
            shipping_plan_id=shipping_plan_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _warehousetransfer_fbainbound_shippingplans_shipping_plan_id_shipments_shipment_id_transport_void_put_serialize(
        self,
        shipment_id,
        shipping_plan_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if shipment_id is not None:
            _path_params['shipmentId'] = shipment_id
        if shipping_plan_id is not None:
            _path_params['shippingPlanId'] = shipping_plan_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Linnworks'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/shipments/{shipmentId}/transport/void',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


