# coding: utf-8

"""
    Warehouse Transfer

    Warehouse Transfer v1

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import StrictInt, StrictStr
from typing import Optional
from linnworks_api.generated.warehousetransfer_new.models.create_shipping_plan_request import CreateShippingPlanRequest
from linnworks_api.generated.warehousetransfer_new.models.get_shipping_plan_by_id_response import GetShippingPlanByIdResponse
from linnworks_api.generated.warehousetransfer_new.models.get_shipping_plan_cards_response import GetShippingPlanCardsResponse
from linnworks_api.generated.warehousetransfer_new.models.update_from_location_fba_request import UpdateFromLocationFbaRequest
from linnworks_api.generated.warehousetransfer_new.models.update_packing_type_request import UpdatePackingTypeRequest
from linnworks_api.generated.warehousetransfer_new.models.update_shipping_plan_request import UpdateShippingPlanRequest
from linnworks_api.generated.warehousetransfer_new.models.update_to_location_fba_request import UpdateToLocationFbaRequest
from linnworks_api.generated.warehousetransfer_new.models.update_to_location_response import UpdateToLocationResponse

from linnworks_api.generated.warehousetransfer_new.api_client import ApiClient, RequestSerialized
from linnworks_api.generated.warehousetransfer_new.api_response import ApiResponse
from linnworks_api.generated.warehousetransfer_new.rest import RESTResponseType


class FbaShippingPlanApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def get_shipping_plan_by_id(
        self,
        id: StrictInt,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetShippingPlanByIdResponse:
        """(Deprecated) GetShippingPlanById

        Used to get shipping plan with shipments and shipping items<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param id:  (required)
        :type id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /warehousetransfer/fbainbound/shippingplans/{id} is deprecated.", DeprecationWarning)

        _param = self._get_shipping_plan_by_id_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetShippingPlanByIdResponse",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_shipping_plan_by_id_with_http_info(
        self,
        id: StrictInt,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetShippingPlanByIdResponse]:
        """(Deprecated) GetShippingPlanById

        Used to get shipping plan with shipments and shipping items<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param id:  (required)
        :type id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /warehousetransfer/fbainbound/shippingplans/{id} is deprecated.", DeprecationWarning)

        _param = self._get_shipping_plan_by_id_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetShippingPlanByIdResponse",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_shipping_plan_by_id_without_preload_content(
        self,
        id: StrictInt,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) GetShippingPlanById

        Used to get shipping plan with shipments and shipping items<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param id:  (required)
        :type id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /warehousetransfer/fbainbound/shippingplans/{id} is deprecated.", DeprecationWarning)

        _param = self._get_shipping_plan_by_id_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetShippingPlanByIdResponse",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_shipping_plan_by_id_serialize(
        self,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Linnworks'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/warehousetransfer/fbainbound/shippingplans/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def warehousetransfer_fbainbound_shippingplans_id_delete(
        self,
        id: StrictInt,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """(Deprecated) DeleteShippingPlan

        Used to delete just shipping plan without related info<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param id:  (required)
        :type id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("DELETE /warehousetransfer/fbainbound/shippingplans/{id} is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_id_delete_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_id_delete_with_http_info(
        self,
        id: StrictInt,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """(Deprecated) DeleteShippingPlan

        Used to delete just shipping plan without related info<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param id:  (required)
        :type id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("DELETE /warehousetransfer/fbainbound/shippingplans/{id} is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_id_delete_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_id_delete_without_preload_content(
        self,
        id: StrictInt,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) DeleteShippingPlan

        Used to delete just shipping plan without related info<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param id:  (required)
        :type id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("DELETE /warehousetransfer/fbainbound/shippingplans/{id} is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_id_delete_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _warehousetransfer_fbainbound_shippingplans_id_delete_serialize(
        self,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Linnworks'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/warehousetransfer/fbainbound/shippingplans/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def warehousetransfer_fbainbound_shippingplans_id_put(
        self,
        id: StrictInt,
        update_shipping_plan_request: Optional[UpdateShippingPlanRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """(Deprecated) UpdateShippingPlan

        Used to update shipping plan<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param id:  (required)
        :type id: int
        :param update_shipping_plan_request: 
        :type update_shipping_plan_request: UpdateShippingPlanRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{id} is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_id_put_serialize(
            id=id,
            update_shipping_plan_request=update_shipping_plan_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_id_put_with_http_info(
        self,
        id: StrictInt,
        update_shipping_plan_request: Optional[UpdateShippingPlanRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """(Deprecated) UpdateShippingPlan

        Used to update shipping plan<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param id:  (required)
        :type id: int
        :param update_shipping_plan_request: 
        :type update_shipping_plan_request: UpdateShippingPlanRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{id} is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_id_put_serialize(
            id=id,
            update_shipping_plan_request=update_shipping_plan_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_id_put_without_preload_content(
        self,
        id: StrictInt,
        update_shipping_plan_request: Optional[UpdateShippingPlanRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) UpdateShippingPlan

        Used to update shipping plan<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param id:  (required)
        :type id: int
        :param update_shipping_plan_request: 
        :type update_shipping_plan_request: UpdateShippingPlanRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{id} is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_id_put_serialize(
            id=id,
            update_shipping_plan_request=update_shipping_plan_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _warehousetransfer_fbainbound_shippingplans_id_put_serialize(
        self,
        id,
        update_shipping_plan_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_shipping_plan_request is not None:
            _body_params = update_shipping_plan_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json-patch+json; x-api-version=1.0', 
                        'application/json; x-api-version=1.0', 
                        'text/json; x-api-version=1.0', 
                        'application/*+json; x-api-version=1.0'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Linnworks'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/warehousetransfer/fbainbound/shippingplans/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def warehousetransfer_fbainbound_shippingplans_post(
        self,
        create_shipping_plan_request: Optional[CreateShippingPlanRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """(Deprecated) CreateShippingPlan

        Used to create shipping plan with default shipment<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param create_shipping_plan_request: 
        :type create_shipping_plan_request: CreateShippingPlanRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("POST /warehousetransfer/fbainbound/shippingplans is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_post_serialize(
            create_shipping_plan_request=create_shipping_plan_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_post_with_http_info(
        self,
        create_shipping_plan_request: Optional[CreateShippingPlanRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """(Deprecated) CreateShippingPlan

        Used to create shipping plan with default shipment<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param create_shipping_plan_request: 
        :type create_shipping_plan_request: CreateShippingPlanRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("POST /warehousetransfer/fbainbound/shippingplans is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_post_serialize(
            create_shipping_plan_request=create_shipping_plan_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_post_without_preload_content(
        self,
        create_shipping_plan_request: Optional[CreateShippingPlanRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) CreateShippingPlan

        Used to create shipping plan with default shipment<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param create_shipping_plan_request: 
        :type create_shipping_plan_request: CreateShippingPlanRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("POST /warehousetransfer/fbainbound/shippingplans is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_post_serialize(
            create_shipping_plan_request=create_shipping_plan_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _warehousetransfer_fbainbound_shippingplans_post_serialize(
        self,
        create_shipping_plan_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_shipping_plan_request is not None:
            _body_params = create_shipping_plan_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json-patch+json; x-api-version=1.0', 
                        'application/json; x-api-version=1.0', 
                        'text/json; x-api-version=1.0', 
                        'application/*+json; x-api-version=1.0'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Linnworks'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/warehousetransfer/fbainbound/shippingplans',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_from_location_put(
        self,
        shipping_plan_id: StrictInt,
        update_from_location_fba_request: Optional[UpdateFromLocationFbaRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """(Deprecated) UpdateFromLocation

        Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id:  (required)
        :type shipping_plan_id: int
        :param update_from_location_fba_request: 
        :type update_from_location_fba_request: UpdateFromLocationFbaRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/from-location is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_from_location_put_serialize(
            shipping_plan_id=shipping_plan_id,
            update_from_location_fba_request=update_from_location_fba_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_from_location_put_with_http_info(
        self,
        shipping_plan_id: StrictInt,
        update_from_location_fba_request: Optional[UpdateFromLocationFbaRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """(Deprecated) UpdateFromLocation

        Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id:  (required)
        :type shipping_plan_id: int
        :param update_from_location_fba_request: 
        :type update_from_location_fba_request: UpdateFromLocationFbaRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/from-location is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_from_location_put_serialize(
            shipping_plan_id=shipping_plan_id,
            update_from_location_fba_request=update_from_location_fba_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_from_location_put_without_preload_content(
        self,
        shipping_plan_id: StrictInt,
        update_from_location_fba_request: Optional[UpdateFromLocationFbaRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) UpdateFromLocation

        Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id:  (required)
        :type shipping_plan_id: int
        :param update_from_location_fba_request: 
        :type update_from_location_fba_request: UpdateFromLocationFbaRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/from-location is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_from_location_put_serialize(
            shipping_plan_id=shipping_plan_id,
            update_from_location_fba_request=update_from_location_fba_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _warehousetransfer_fbainbound_shippingplans_shipping_plan_id_from_location_put_serialize(
        self,
        shipping_plan_id,
        update_from_location_fba_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if shipping_plan_id is not None:
            _path_params['shippingPlanId'] = shipping_plan_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_from_location_fba_request is not None:
            _body_params = update_from_location_fba_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json-patch+json; x-api-version=1.0', 
                        'application/json; x-api-version=1.0', 
                        'text/json; x-api-version=1.0', 
                        'application/*+json; x-api-version=1.0'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Linnworks'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/from-location',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_packing_type_put(
        self,
        shipping_plan_id: StrictInt,
        update_packing_type_request: Optional[UpdatePackingTypeRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """(Deprecated) UpdatePackingType

        Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id:  (required)
        :type shipping_plan_id: int
        :param update_packing_type_request: 
        :type update_packing_type_request: UpdatePackingTypeRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/packing-type is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_packing_type_put_serialize(
            shipping_plan_id=shipping_plan_id,
            update_packing_type_request=update_packing_type_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_packing_type_put_with_http_info(
        self,
        shipping_plan_id: StrictInt,
        update_packing_type_request: Optional[UpdatePackingTypeRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """(Deprecated) UpdatePackingType

        Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id:  (required)
        :type shipping_plan_id: int
        :param update_packing_type_request: 
        :type update_packing_type_request: UpdatePackingTypeRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/packing-type is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_packing_type_put_serialize(
            shipping_plan_id=shipping_plan_id,
            update_packing_type_request=update_packing_type_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_packing_type_put_without_preload_content(
        self,
        shipping_plan_id: StrictInt,
        update_packing_type_request: Optional[UpdatePackingTypeRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) UpdatePackingType

        Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id:  (required)
        :type shipping_plan_id: int
        :param update_packing_type_request: 
        :type update_packing_type_request: UpdatePackingTypeRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/packing-type is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_packing_type_put_serialize(
            shipping_plan_id=shipping_plan_id,
            update_packing_type_request=update_packing_type_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _warehousetransfer_fbainbound_shippingplans_shipping_plan_id_packing_type_put_serialize(
        self,
        shipping_plan_id,
        update_packing_type_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if shipping_plan_id is not None:
            _path_params['shippingPlanId'] = shipping_plan_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_packing_type_request is not None:
            _body_params = update_packing_type_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json-patch+json; x-api-version=1.0', 
                        'application/json; x-api-version=1.0', 
                        'text/json; x-api-version=1.0', 
                        'application/*+json; x-api-version=1.0'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Linnworks'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/packing-type',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_sellercentralurl_get(
        self,
        shipping_plan_id: StrictInt,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> str:
        """(Deprecated) GetSellerCentralUrl

        Used to get seller central url from shipping plan<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id:  (required)
        :type shipping_plan_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/sellercentralurl is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_sellercentralurl_get_serialize(
            shipping_plan_id=shipping_plan_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "str",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_sellercentralurl_get_with_http_info(
        self,
        shipping_plan_id: StrictInt,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[str]:
        """(Deprecated) GetSellerCentralUrl

        Used to get seller central url from shipping plan<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id:  (required)
        :type shipping_plan_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/sellercentralurl is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_sellercentralurl_get_serialize(
            shipping_plan_id=shipping_plan_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "str",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_sellercentralurl_get_without_preload_content(
        self,
        shipping_plan_id: StrictInt,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) GetSellerCentralUrl

        Used to get seller central url from shipping plan<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id:  (required)
        :type shipping_plan_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/sellercentralurl is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_sellercentralurl_get_serialize(
            shipping_plan_id=shipping_plan_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "str",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _warehousetransfer_fbainbound_shippingplans_shipping_plan_id_sellercentralurl_get_serialize(
        self,
        shipping_plan_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if shipping_plan_id is not None:
            _path_params['shippingPlanId'] = shipping_plan_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Linnworks'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/sellercentralurl',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_submit_put(
        self,
        shipping_plan_id: StrictInt,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetShippingPlanCardsResponse:
        """(Deprecated) SubmitShippingPlan

        Used to update shipping plan items (sellerSku and quantity)<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id: (required)
        :type shipping_plan_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/submit is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_submit_put_serialize(
            shipping_plan_id=shipping_plan_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetShippingPlanCardsResponse",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_submit_put_with_http_info(
        self,
        shipping_plan_id: StrictInt,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetShippingPlanCardsResponse]:
        """(Deprecated) SubmitShippingPlan

        Used to update shipping plan items (sellerSku and quantity)<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id: (required)
        :type shipping_plan_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/submit is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_submit_put_serialize(
            shipping_plan_id=shipping_plan_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetShippingPlanCardsResponse",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_submit_put_without_preload_content(
        self,
        shipping_plan_id: StrictInt,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) SubmitShippingPlan

        Used to update shipping plan items (sellerSku and quantity)<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id: (required)
        :type shipping_plan_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/submit is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_submit_put_serialize(
            shipping_plan_id=shipping_plan_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetShippingPlanCardsResponse",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _warehousetransfer_fbainbound_shippingplans_shipping_plan_id_submit_put_serialize(
        self,
        shipping_plan_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if shipping_plan_id is not None:
            _path_params['shippingPlanId'] = shipping_plan_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Linnworks'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/submit',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_to_location_put(
        self,
        shipping_plan_id: StrictInt,
        update_to_location_fba_request: Optional[UpdateToLocationFbaRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> UpdateToLocationResponse:
        """(Deprecated) UpdateToLocation

        Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id:  (required)
        :type shipping_plan_id: int
        :param update_to_location_fba_request: 
        :type update_to_location_fba_request: UpdateToLocationFbaRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/to-location is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_to_location_put_serialize(
            shipping_plan_id=shipping_plan_id,
            update_to_location_fba_request=update_to_location_fba_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateToLocationResponse",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_to_location_put_with_http_info(
        self,
        shipping_plan_id: StrictInt,
        update_to_location_fba_request: Optional[UpdateToLocationFbaRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[UpdateToLocationResponse]:
        """(Deprecated) UpdateToLocation

        Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id:  (required)
        :type shipping_plan_id: int
        :param update_to_location_fba_request: 
        :type update_to_location_fba_request: UpdateToLocationFbaRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/to-location is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_to_location_put_serialize(
            shipping_plan_id=shipping_plan_id,
            update_to_location_fba_request=update_to_location_fba_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateToLocationResponse",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_to_location_put_without_preload_content(
        self,
        shipping_plan_id: StrictInt,
        update_to_location_fba_request: Optional[UpdateToLocationFbaRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) UpdateToLocation

        Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id:  (required)
        :type shipping_plan_id: int
        :param update_to_location_fba_request: 
        :type update_to_location_fba_request: UpdateToLocationFbaRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/to-location is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_to_location_put_serialize(
            shipping_plan_id=shipping_plan_id,
            update_to_location_fba_request=update_to_location_fba_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateToLocationResponse",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _warehousetransfer_fbainbound_shippingplans_shipping_plan_id_to_location_put_serialize(
        self,
        shipping_plan_id,
        update_to_location_fba_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if shipping_plan_id is not None:
            _path_params['shippingPlanId'] = shipping_plan_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_to_location_fba_request is not None:
            _body_params = update_to_location_fba_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json-patch+json; x-api-version=1.0', 
                        'application/json; x-api-version=1.0', 
                        'text/json; x-api-version=1.0', 
                        'application/*+json; x-api-version=1.0'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Linnworks'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/to-location',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_topleveldomain_get(
        self,
        shipping_plan_id: StrictInt,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> str:
        """(Deprecated) GetAmazonTopLevelDomain

        Used to get amazon top level domain from shipping plan<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id:  (required)
        :type shipping_plan_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/topleveldomain is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_topleveldomain_get_serialize(
            shipping_plan_id=shipping_plan_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "str",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_topleveldomain_get_with_http_info(
        self,
        shipping_plan_id: StrictInt,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[str]:
        """(Deprecated) GetAmazonTopLevelDomain

        Used to get amazon top level domain from shipping plan<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id:  (required)
        :type shipping_plan_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/topleveldomain is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_topleveldomain_get_serialize(
            shipping_plan_id=shipping_plan_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "str",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def warehousetransfer_fbainbound_shippingplans_shipping_plan_id_topleveldomain_get_without_preload_content(
        self,
        shipping_plan_id: StrictInt,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) GetAmazonTopLevelDomain

        Used to get amazon top level domain from shipping plan<br>Deprecated - please use v2 - [API Docs v2](https://apidocs.linnworks.net/v2/)

        :param shipping_plan_id:  (required)
        :type shipping_plan_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/topleveldomain is deprecated.", DeprecationWarning)

        _param = self._warehousetransfer_fbainbound_shippingplans_shipping_plan_id_topleveldomain_get_serialize(
            shipping_plan_id=shipping_plan_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "str",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _warehousetransfer_fbainbound_shippingplans_shipping_plan_id_topleveldomain_get_serialize(
        self,
        shipping_plan_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if shipping_plan_id is not None:
            _path_params['shippingPlanId'] = shipping_plan_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Linnworks'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/warehousetransfer/fbainbound/shippingplans/{shippingPlanId}/topleveldomain',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


