# coding: utf-8

"""
    Warehouse Transfer

    Warehouse Transfer v1

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictStr
from typing import Optional
from typing_extensions import Annotated
from linnworks_api.generated.warehousetransfer_new.models.stock_item_model_generic_paged_result import StockItemModelGenericPagedResult
from linnworks_api.generated.warehousetransfer_new.models.warehouse_transfer_stock_item_model_generic_paged_result import WarehouseTransferStockItemModelGenericPagedResult

from linnworks_api.generated.warehousetransfer_new.api_client import ApiClient, RequestSerialized
from linnworks_api.generated.warehousetransfer_new.api_response import ApiResponse
from linnworks_api.generated.warehousetransfer_new.rest import RESTResponseType


class StockItemApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def warehousetransfer_stock_find_warehouse_transfer_stock_items_get(
        self,
        keyword: Optional[StrictStr] = None,
        from_location_id: Optional[StrictStr] = None,
        to_location_id: Optional[StrictStr] = None,
        entries_per_page: Optional[Annotated[int, Field(le=200, strict=True, ge=1)]] = None,
        page_number: Optional[Annotated[int, Field(le=2147483647, strict=True, ge=1)]] = None,
        sort_column: Optional[StrictStr] = None,
        sort_direction: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> WarehouseTransferStockItemModelGenericPagedResult:
        """FindWarehouseTransferStockItems

        Used to get stock items for warehouse transfer

        :param keyword:
        :type keyword: str
        :param from_location_id:
        :type from_location_id: str
        :param to_location_id:
        :type to_location_id: str
        :param entries_per_page:
        :type entries_per_page: int
        :param page_number:
        :type page_number: int
        :param sort_column:
        :type sort_column: str
        :param sort_direction:
        :type sort_direction: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._warehousetransfer_stock_find_warehouse_transfer_stock_items_get_serialize(
            keyword=keyword,
            from_location_id=from_location_id,
            to_location_id=to_location_id,
            entries_per_page=entries_per_page,
            page_number=page_number,
            sort_column=sort_column,
            sort_direction=sort_direction,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "WarehouseTransferStockItemModelGenericPagedResult",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def warehousetransfer_stock_find_warehouse_transfer_stock_items_get_with_http_info(
        self,
        keyword: Optional[StrictStr] = None,
        from_location_id: Optional[StrictStr] = None,
        to_location_id: Optional[StrictStr] = None,
        entries_per_page: Optional[Annotated[int, Field(le=200, strict=True, ge=1)]] = None,
        page_number: Optional[Annotated[int, Field(le=2147483647, strict=True, ge=1)]] = None,
        sort_column: Optional[StrictStr] = None,
        sort_direction: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[WarehouseTransferStockItemModelGenericPagedResult]:
        """FindWarehouseTransferStockItems

        Used to get stock items for warehouse transfer

        :param keyword:
        :type keyword: str
        :param from_location_id:
        :type from_location_id: str
        :param to_location_id:
        :type to_location_id: str
        :param entries_per_page:
        :type entries_per_page: int
        :param page_number:
        :type page_number: int
        :param sort_column:
        :type sort_column: str
        :param sort_direction:
        :type sort_direction: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._warehousetransfer_stock_find_warehouse_transfer_stock_items_get_serialize(
            keyword=keyword,
            from_location_id=from_location_id,
            to_location_id=to_location_id,
            entries_per_page=entries_per_page,
            page_number=page_number,
            sort_column=sort_column,
            sort_direction=sort_direction,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "WarehouseTransferStockItemModelGenericPagedResult",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def warehousetransfer_stock_find_warehouse_transfer_stock_items_get_without_preload_content(
        self,
        keyword: Optional[StrictStr] = None,
        from_location_id: Optional[StrictStr] = None,
        to_location_id: Optional[StrictStr] = None,
        entries_per_page: Optional[Annotated[int, Field(le=200, strict=True, ge=1)]] = None,
        page_number: Optional[Annotated[int, Field(le=2147483647, strict=True, ge=1)]] = None,
        sort_column: Optional[StrictStr] = None,
        sort_direction: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """FindWarehouseTransferStockItems

        Used to get stock items for warehouse transfer

        :param keyword:
        :type keyword: str
        :param from_location_id:
        :type from_location_id: str
        :param to_location_id:
        :type to_location_id: str
        :param entries_per_page:
        :type entries_per_page: int
        :param page_number:
        :type page_number: int
        :param sort_column:
        :type sort_column: str
        :param sort_direction:
        :type sort_direction: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._warehousetransfer_stock_find_warehouse_transfer_stock_items_get_serialize(
            keyword=keyword,
            from_location_id=from_location_id,
            to_location_id=to_location_id,
            entries_per_page=entries_per_page,
            page_number=page_number,
            sort_column=sort_column,
            sort_direction=sort_direction,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "WarehouseTransferStockItemModelGenericPagedResult",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _warehousetransfer_stock_find_warehouse_transfer_stock_items_get_serialize(
        self,
        keyword,
        from_location_id,
        to_location_id,
        entries_per_page,
        page_number,
        sort_column,
        sort_direction,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if keyword is not None:
            
            _query_params.append(('keyword', keyword))
            
        if from_location_id is not None:
            
            _query_params.append(('fromLocationId', from_location_id))
            
        if to_location_id is not None:
            
            _query_params.append(('toLocationId', to_location_id))
            
        if entries_per_page is not None:
            
            _query_params.append(('entriesPerPage', entries_per_page))
            
        if page_number is not None:
            
            _query_params.append(('pageNumber', page_number))
            
        if sort_column is not None:
            
            _query_params.append(('sortColumn', sort_column))
            
        if sort_direction is not None:
            
            _query_params.append(('sortDirection', sort_direction))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Linnworks'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/warehousetransfer/stock/FindWarehouseTransferStockItems',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def warehousetransfer_stock_get(
        self,
        keyword: Optional[StrictStr] = None,
        from_location_id: Optional[StrictStr] = None,
        channel_id: Optional[Annotated[int, Field(le=2147483647, strict=True, ge=1)]] = None,
        sort_column: Optional[StrictStr] = None,
        sort_direction: Optional[StrictStr] = None,
        entries_per_page: Optional[Annotated[int, Field(le=200, strict=True, ge=1)]] = None,
        page_number: Optional[Annotated[int, Field(le=2147483647, strict=True, ge=1)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> StockItemModelGenericPagedResult:
        """FindStockItem

        Used to get shipment items by shipping plan id

        :param keyword:
        :type keyword: str
        :param from_location_id:
        :type from_location_id: str
        :param channel_id:
        :type channel_id: int
        :param sort_column:
        :type sort_column: str
        :param sort_direction:
        :type sort_direction: str
        :param entries_per_page:
        :type entries_per_page: int
        :param page_number:
        :type page_number: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._warehousetransfer_stock_get_serialize(
            keyword=keyword,
            from_location_id=from_location_id,
            channel_id=channel_id,
            sort_column=sort_column,
            sort_direction=sort_direction,
            entries_per_page=entries_per_page,
            page_number=page_number,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "StockItemModelGenericPagedResult",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def warehousetransfer_stock_get_with_http_info(
        self,
        keyword: Optional[StrictStr] = None,
        from_location_id: Optional[StrictStr] = None,
        channel_id: Optional[Annotated[int, Field(le=2147483647, strict=True, ge=1)]] = None,
        sort_column: Optional[StrictStr] = None,
        sort_direction: Optional[StrictStr] = None,
        entries_per_page: Optional[Annotated[int, Field(le=200, strict=True, ge=1)]] = None,
        page_number: Optional[Annotated[int, Field(le=2147483647, strict=True, ge=1)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[StockItemModelGenericPagedResult]:
        """FindStockItem

        Used to get shipment items by shipping plan id

        :param keyword:
        :type keyword: str
        :param from_location_id:
        :type from_location_id: str
        :param channel_id:
        :type channel_id: int
        :param sort_column:
        :type sort_column: str
        :param sort_direction:
        :type sort_direction: str
        :param entries_per_page:
        :type entries_per_page: int
        :param page_number:
        :type page_number: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._warehousetransfer_stock_get_serialize(
            keyword=keyword,
            from_location_id=from_location_id,
            channel_id=channel_id,
            sort_column=sort_column,
            sort_direction=sort_direction,
            entries_per_page=entries_per_page,
            page_number=page_number,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "StockItemModelGenericPagedResult",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def warehousetransfer_stock_get_without_preload_content(
        self,
        keyword: Optional[StrictStr] = None,
        from_location_id: Optional[StrictStr] = None,
        channel_id: Optional[Annotated[int, Field(le=2147483647, strict=True, ge=1)]] = None,
        sort_column: Optional[StrictStr] = None,
        sort_direction: Optional[StrictStr] = None,
        entries_per_page: Optional[Annotated[int, Field(le=200, strict=True, ge=1)]] = None,
        page_number: Optional[Annotated[int, Field(le=2147483647, strict=True, ge=1)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """FindStockItem

        Used to get shipment items by shipping plan id

        :param keyword:
        :type keyword: str
        :param from_location_id:
        :type from_location_id: str
        :param channel_id:
        :type channel_id: int
        :param sort_column:
        :type sort_column: str
        :param sort_direction:
        :type sort_direction: str
        :param entries_per_page:
        :type entries_per_page: int
        :param page_number:
        :type page_number: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._warehousetransfer_stock_get_serialize(
            keyword=keyword,
            from_location_id=from_location_id,
            channel_id=channel_id,
            sort_column=sort_column,
            sort_direction=sort_direction,
            entries_per_page=entries_per_page,
            page_number=page_number,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "StockItemModelGenericPagedResult",
            '201': None,
            '204': None,
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _warehousetransfer_stock_get_serialize(
        self,
        keyword,
        from_location_id,
        channel_id,
        sort_column,
        sort_direction,
        entries_per_page,
        page_number,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if keyword is not None:
            
            _query_params.append(('keyword', keyword))
            
        if from_location_id is not None:
            
            _query_params.append(('fromLocationId', from_location_id))
            
        if channel_id is not None:
            
            _query_params.append(('channelId', channel_id))
            
        if sort_column is not None:
            
            _query_params.append(('sortColumn', sort_column))
            
        if sort_direction is not None:
            
            _query_params.append(('sortDirection', sort_direction))
            
        if entries_per_page is not None:
            
            _query_params.append(('entriesPerPage', entries_per_page))
            
        if page_number is not None:
            
            _query_params.append(('pageNumber', page_number))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Linnworks'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/warehousetransfer/stock',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


