# coding: utf-8

"""
    Warehouse Transfer

    Warehouse Transfer v1

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.warehousetransfer_new.models.shipment_search_model import ShipmentSearchModel
from linnworks_api.generated.warehousetransfer_new.models.stock_item_search_model import StockItemSearchModel
from typing import Optional, Set
from typing_extensions import Self

class GetShippingPlanCardsResponse(BaseModel):
    """
    GetShippingPlanCardsResponse
    """ # noqa: E501
    channel_id: Optional[StrictInt] = Field(default=None, alias="channelId")
    create_date: Optional[datetime] = Field(default=None, alias="createDate")
    update_date: Optional[datetime] = Field(default=None, alias="updateDate")
    from_location: Optional[StrictStr] = Field(default=None, alias="fromLocation")
    id: Optional[StrictInt] = None
    shipping_plan_id: Optional[StrictInt] = Field(default=None, alias="shippingPlanId")
    packing_type: Optional[StrictInt] = Field(default=None, alias="packingType")
    plan_id: Optional[StrictStr] = Field(default=None, alias="planId")
    shipment_id: Optional[StrictStr] = Field(default=None, alias="shipmentId")
    shipment_items_count: Optional[StrictInt] = Field(default=None, alias="shipmentItemsCount")
    shipment_received: Optional[StrictInt] = Field(default=None, alias="shipmentReceived")
    shipment_shipped: Optional[StrictInt] = Field(default=None, alias="shipmentShipped")
    ship_to: Optional[StrictStr] = Field(default=None, alias="shipTo")
    status: Optional[StrictInt] = None
    to_location: Optional[StrictStr] = Field(default=None, alias="toLocation")
    type: Optional[StrictInt] = None
    items: Optional[List[StockItemSearchModel]] = None
    shipments: Optional[List[ShipmentSearchModel]] = None
    __properties: ClassVar[List[str]] = ["channelId", "createDate", "updateDate", "fromLocation", "id", "shippingPlanId", "packingType", "planId", "shipmentId", "shipmentItemsCount", "shipmentReceived", "shipmentShipped", "shipTo", "status", "toLocation", "type", "items", "shipments"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetShippingPlanCardsResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in items (list)
        _items = []
        if self.items:
            for _item_items in self.items:
                if _item_items:
                    _items.append(_item_items.to_dict())
            _dict['items'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in shipments (list)
        _items = []
        if self.shipments:
            for _item_shipments in self.shipments:
                if _item_shipments:
                    _items.append(_item_shipments.to_dict())
            _dict['shipments'] = _items
        # set to None if plan_id (nullable) is None
        # and model_fields_set contains the field
        if self.plan_id is None and "plan_id" in self.model_fields_set:
            _dict['planId'] = None

        # set to None if shipment_id (nullable) is None
        # and model_fields_set contains the field
        if self.shipment_id is None and "shipment_id" in self.model_fields_set:
            _dict['shipmentId'] = None

        # set to None if ship_to (nullable) is None
        # and model_fields_set contains the field
        if self.ship_to is None and "ship_to" in self.model_fields_set:
            _dict['shipTo'] = None

        # set to None if items (nullable) is None
        # and model_fields_set contains the field
        if self.items is None and "items" in self.model_fields_set:
            _dict['items'] = None

        # set to None if shipments (nullable) is None
        # and model_fields_set contains the field
        if self.shipments is None and "shipments" in self.model_fields_set:
            _dict['shipments'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetShippingPlanCardsResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "channelId": obj.get("channelId"),
            "createDate": obj.get("createDate"),
            "updateDate": obj.get("updateDate"),
            "fromLocation": obj.get("fromLocation"),
            "id": obj.get("id"),
            "shippingPlanId": obj.get("shippingPlanId"),
            "packingType": obj.get("packingType"),
            "planId": obj.get("planId"),
            "shipmentId": obj.get("shipmentId"),
            "shipmentItemsCount": obj.get("shipmentItemsCount"),
            "shipmentReceived": obj.get("shipmentReceived"),
            "shipmentShipped": obj.get("shipmentShipped"),
            "shipTo": obj.get("shipTo"),
            "status": obj.get("status"),
            "toLocation": obj.get("toLocation"),
            "type": obj.get("type"),
            "items": [StockItemSearchModel.from_dict(_item) for _item in obj["items"]] if obj.get("items") is not None else None,
            "shipments": [ShipmentSearchModel.from_dict(_item) for _item in obj["shipments"]] if obj.get("shipments") is not None else None
        })
        return _obj


