# coding: utf-8

"""
    Warehouse Transfer

    Warehouse Transfer v1

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.warehousetransfer_new.models.csv_separator_type import CsvSeparatorType
from linnworks_api.generated.warehousetransfer_new.models.import_column_stock_transfer_mapping_model import ImportColumnStockTransferMappingModel
from typing import Optional, Set
from typing_extensions import Self

class ImportStockTransferSettingModel(BaseModel):
    """
    ImportStockTransferSettingModel
    """ # noqa: E501
    separator_type: Optional[CsvSeparatorType] = Field(default=None, alias="separatorType")
    contains_columns: Optional[StrictBool] = Field(default=None, alias="containsColumns")
    column_mappings: Optional[List[ImportColumnStockTransferMappingModel]] = Field(default=None, alias="columnMappings")
    __properties: ClassVar[List[str]] = ["separatorType", "containsColumns", "columnMappings"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ImportStockTransferSettingModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in column_mappings (list)
        _items = []
        if self.column_mappings:
            for _item_column_mappings in self.column_mappings:
                if _item_column_mappings:
                    _items.append(_item_column_mappings.to_dict())
            _dict['columnMappings'] = _items
        # set to None if column_mappings (nullable) is None
        # and model_fields_set contains the field
        if self.column_mappings is None and "column_mappings" in self.model_fields_set:
            _dict['columnMappings'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ImportStockTransferSettingModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "separatorType": obj.get("separatorType"),
            "containsColumns": obj.get("containsColumns"),
            "columnMappings": [ImportColumnStockTransferMappingModel.from_dict(_item) for _item in obj["columnMappings"]] if obj.get("columnMappings") is not None else None
        })
        return _obj


