# coding: utf-8

"""
    Warehouse Transfer

    Warehouse Transfer v1

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from linnworks_api.generated.warehousetransfer_new.models.batch_status import BatchStatus
from typing import Optional, Set
from typing_extensions import Self

class ItemNewReceivedBatchModel(BaseModel):
    """
    ItemNewReceivedBatchModel
    """ # noqa: E501
    batch_id: Optional[StrictInt] = Field(default=None, alias="batchId")
    batch_inventory_id: Optional[StrictInt] = Field(default=None, alias="batchInventoryId")
    stock_item_id: Optional[StrictStr] = Field(default=None, alias="stockItemId")
    available_quantity: Optional[StrictInt] = Field(default=None, alias="availableQuantity")
    batch_number: Optional[StrictStr] = Field(default=None, alias="batchNumber")
    batch_status: Optional[BatchStatus] = Field(default=None, alias="batchStatus")
    expiry_date: Optional[datetime] = Field(default=None, alias="expiryDate")
    sell_by: Optional[datetime] = Field(default=None, alias="sellBy")
    priority_sequence: Optional[StrictInt] = Field(default=None, alias="prioritySequence")
    unit_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="unitCost")
    quantity: Optional[StrictInt] = None
    bin_rack: Optional[StrictStr] = Field(default=None, alias="binRack")
    binrack_id: Optional[StrictInt] = Field(default=None, alias="binrackId")
    stock_value: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="stockValue")
    __properties: ClassVar[List[str]] = ["batchId", "batchInventoryId", "stockItemId", "availableQuantity", "batchNumber", "batchStatus", "expiryDate", "sellBy", "prioritySequence", "unitCost", "quantity", "binRack", "binrackId", "stockValue"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ItemNewReceivedBatchModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "stock_value",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if batch_number (nullable) is None
        # and model_fields_set contains the field
        if self.batch_number is None and "batch_number" in self.model_fields_set:
            _dict['batchNumber'] = None

        # set to None if bin_rack (nullable) is None
        # and model_fields_set contains the field
        if self.bin_rack is None and "bin_rack" in self.model_fields_set:
            _dict['binRack'] = None

        # set to None if binrack_id (nullable) is None
        # and model_fields_set contains the field
        if self.binrack_id is None and "binrack_id" in self.model_fields_set:
            _dict['binrackId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ItemNewReceivedBatchModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "batchId": obj.get("batchId"),
            "batchInventoryId": obj.get("batchInventoryId"),
            "stockItemId": obj.get("stockItemId"),
            "availableQuantity": obj.get("availableQuantity"),
            "batchNumber": obj.get("batchNumber"),
            "batchStatus": obj.get("batchStatus"),
            "expiryDate": obj.get("expiryDate"),
            "sellBy": obj.get("sellBy"),
            "prioritySequence": obj.get("prioritySequence"),
            "unitCost": obj.get("unitCost"),
            "quantity": obj.get("quantity"),
            "binRack": obj.get("binRack"),
            "binrackId": obj.get("binrackId"),
            "stockValue": obj.get("stockValue")
        })
        return _obj


