# coding: utf-8

"""
    Warehouse Transfer

    Warehouse Transfer v1

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.warehousetransfer_new.models.item_new_received_batch_model import ItemNewReceivedBatchModel
from linnworks_api.generated.warehousetransfer_new.models.item_updated_received_batch_model import ItemUpdatedReceivedBatchModel
from typing import Optional, Set
from typing_extensions import Self

class ItemReceivedBatchesModel(BaseModel):
    """
    ItemReceivedBatchesModel
    """ # noqa: E501
    added_batches: Optional[List[ItemNewReceivedBatchModel]] = Field(default=None, alias="addedBatches")
    added_batch_inventories: Optional[List[ItemNewReceivedBatchModel]] = Field(default=None, alias="addedBatchInventories")
    updated_batches: Optional[List[ItemUpdatedReceivedBatchModel]] = Field(default=None, alias="updatedBatches")
    deleted_batches: Optional[List[StrictInt]] = Field(default=None, alias="deletedBatches")
    __properties: ClassVar[List[str]] = ["addedBatches", "addedBatchInventories", "updatedBatches", "deletedBatches"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ItemReceivedBatchesModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in added_batches (list)
        _items = []
        if self.added_batches:
            for _item_added_batches in self.added_batches:
                if _item_added_batches:
                    _items.append(_item_added_batches.to_dict())
            _dict['addedBatches'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in added_batch_inventories (list)
        _items = []
        if self.added_batch_inventories:
            for _item_added_batch_inventories in self.added_batch_inventories:
                if _item_added_batch_inventories:
                    _items.append(_item_added_batch_inventories.to_dict())
            _dict['addedBatchInventories'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in updated_batches (list)
        _items = []
        if self.updated_batches:
            for _item_updated_batches in self.updated_batches:
                if _item_updated_batches:
                    _items.append(_item_updated_batches.to_dict())
            _dict['updatedBatches'] = _items
        # set to None if added_batches (nullable) is None
        # and model_fields_set contains the field
        if self.added_batches is None and "added_batches" in self.model_fields_set:
            _dict['addedBatches'] = None

        # set to None if added_batch_inventories (nullable) is None
        # and model_fields_set contains the field
        if self.added_batch_inventories is None and "added_batch_inventories" in self.model_fields_set:
            _dict['addedBatchInventories'] = None

        # set to None if updated_batches (nullable) is None
        # and model_fields_set contains the field
        if self.updated_batches is None and "updated_batches" in self.model_fields_set:
            _dict['updatedBatches'] = None

        # set to None if deleted_batches (nullable) is None
        # and model_fields_set contains the field
        if self.deleted_batches is None and "deleted_batches" in self.model_fields_set:
            _dict['deletedBatches'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ItemReceivedBatchesModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "addedBatches": [ItemNewReceivedBatchModel.from_dict(_item) for _item in obj["addedBatches"]] if obj.get("addedBatches") is not None else None,
            "addedBatchInventories": [ItemNewReceivedBatchModel.from_dict(_item) for _item in obj["addedBatchInventories"]] if obj.get("addedBatchInventories") is not None else None,
            "updatedBatches": [ItemUpdatedReceivedBatchModel.from_dict(_item) for _item in obj["updatedBatches"]] if obj.get("updatedBatches") is not None else None,
            "deletedBatches": obj.get("deletedBatches")
        })
        return _obj


