# coding: utf-8

"""
    Warehouse Transfer

    Warehouse Transfer v1

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.warehousetransfer_new.models.amazon_shipment_carrier_type import AmazonShipmentCarrierType
from typing import Optional, Set
from typing_extensions import Self

class ShipmentPackageLabelTypeModel(BaseModel):
    """
    ShipmentPackageLabelTypeModel
    """ # noqa: E501
    amazon_page_type: Optional[StrictStr] = Field(default=None, alias="amazonPageType")
    countries: Optional[List[StrictStr]] = None
    carrier_types: Optional[List[AmazonShipmentCarrierType]] = Field(default=None, alias="carrierTypes")
    shipment_carrier: Optional[StrictStr] = Field(default=None, alias="shipmentCarrier")
    paper_size_info: Optional[StrictStr] = Field(default=None, alias="paperSizeInfo")
    is_visible_for_pallet: Optional[StrictBool] = Field(default=None, alias="isVisibleForPallet")
    __properties: ClassVar[List[str]] = ["amazonPageType", "countries", "carrierTypes", "shipmentCarrier", "paperSizeInfo", "isVisibleForPallet"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ShipmentPackageLabelTypeModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if amazon_page_type (nullable) is None
        # and model_fields_set contains the field
        if self.amazon_page_type is None and "amazon_page_type" in self.model_fields_set:
            _dict['amazonPageType'] = None

        # set to None if countries (nullable) is None
        # and model_fields_set contains the field
        if self.countries is None and "countries" in self.model_fields_set:
            _dict['countries'] = None

        # set to None if carrier_types (nullable) is None
        # and model_fields_set contains the field
        if self.carrier_types is None and "carrier_types" in self.model_fields_set:
            _dict['carrierTypes'] = None

        # set to None if shipment_carrier (nullable) is None
        # and model_fields_set contains the field
        if self.shipment_carrier is None and "shipment_carrier" in self.model_fields_set:
            _dict['shipmentCarrier'] = None

        # set to None if paper_size_info (nullable) is None
        # and model_fields_set contains the field
        if self.paper_size_info is None and "paper_size_info" in self.model_fields_set:
            _dict['paperSizeInfo'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ShipmentPackageLabelTypeModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "amazonPageType": obj.get("amazonPageType"),
            "countries": obj.get("countries"),
            "carrierTypes": obj.get("carrierTypes"),
            "shipmentCarrier": obj.get("shipmentCarrier"),
            "paperSizeInfo": obj.get("paperSizeInfo"),
            "isVisibleForPallet": obj.get("isVisibleForPallet")
        })
        return _obj


