# coding: utf-8

"""
    Warehouse Transfer

    Warehouse Transfer v1

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.warehousetransfer_new.models.shipment_item_response import ShipmentItemResponse
from linnworks_api.generated.warehousetransfer_new.models.who_preps import WhoPreps
from typing import Optional, Set
from typing_extensions import Self

class ShipmentResponse(BaseModel):
    """
    ShipmentResponse
    """ # noqa: E501
    create_date: Optional[datetime] = Field(default=None, alias="createDate")
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    shipment_id: Optional[StrictStr] = Field(default=None, alias="shipmentId")
    shipping_items: Optional[List[ShipmentItemResponse]] = Field(default=None, alias="shippingItems")
    shipping_plan_id: Optional[StrictInt] = Field(default=None, alias="shippingPlanId")
    ship_to: Optional[StrictStr] = Field(default=None, alias="shipTo")
    status_id: Optional[StrictInt] = Field(default=None, alias="statusId")
    who_preps: Optional[WhoPreps] = Field(default=None, alias="whoPreps")
    update_date: Optional[datetime] = Field(default=None, alias="updateDate")
    warehouse_address: Optional[StrictStr] = Field(default=None, alias="warehouseAddress")
    is_converted_to_send_to_amazon: Optional[StrictBool] = Field(default=None, alias="isConvertedToSendToAmazon")
    __properties: ClassVar[List[str]] = ["createDate", "id", "name", "shipmentId", "shippingItems", "shippingPlanId", "shipTo", "statusId", "whoPreps", "updateDate", "warehouseAddress", "isConvertedToSendToAmazon"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ShipmentResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in shipping_items (list)
        _items = []
        if self.shipping_items:
            for _item_shipping_items in self.shipping_items:
                if _item_shipping_items:
                    _items.append(_item_shipping_items.to_dict())
            _dict['shippingItems'] = _items
        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if shipment_id (nullable) is None
        # and model_fields_set contains the field
        if self.shipment_id is None and "shipment_id" in self.model_fields_set:
            _dict['shipmentId'] = None

        # set to None if shipping_items (nullable) is None
        # and model_fields_set contains the field
        if self.shipping_items is None and "shipping_items" in self.model_fields_set:
            _dict['shippingItems'] = None

        # set to None if ship_to (nullable) is None
        # and model_fields_set contains the field
        if self.ship_to is None and "ship_to" in self.model_fields_set:
            _dict['shipTo'] = None

        # set to None if warehouse_address (nullable) is None
        # and model_fields_set contains the field
        if self.warehouse_address is None and "warehouse_address" in self.model_fields_set:
            _dict['warehouseAddress'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ShipmentResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "createDate": obj.get("createDate"),
            "id": obj.get("id"),
            "name": obj.get("name"),
            "shipmentId": obj.get("shipmentId"),
            "shippingItems": [ShipmentItemResponse.from_dict(_item) for _item in obj["shippingItems"]] if obj.get("shippingItems") is not None else None,
            "shippingPlanId": obj.get("shippingPlanId"),
            "shipTo": obj.get("shipTo"),
            "statusId": obj.get("statusId"),
            "whoPreps": obj.get("whoPreps"),
            "updateDate": obj.get("updateDate"),
            "warehouseAddress": obj.get("warehouseAddress"),
            "isConvertedToSendToAmazon": obj.get("isConvertedToSendToAmazon")
        })
        return _obj


