# coding: utf-8

"""
    Warehouse Transfer

    Warehouse Transfer v1

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.warehousetransfer_new.models.shipment_pallet_update_model import ShipmentPalletUpdateModel
from typing import Optional, Set
from typing_extensions import Self

class UpdateShipmentPalletRequest(BaseModel):
    """
    UpdateShipmentPalletRequest
    """ # noqa: E501
    shipment_id: Optional[StrictInt] = Field(default=None, alias="shipmentId")
    shipping_plan_id: Optional[StrictInt] = Field(default=None, alias="shippingPlanId")
    shipment_pallets: Optional[List[ShipmentPalletUpdateModel]] = Field(default=None, alias="shipmentPallets")
    __properties: ClassVar[List[str]] = ["shipmentId", "shippingPlanId", "shipmentPallets"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateShipmentPalletRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in shipment_pallets (list)
        _items = []
        if self.shipment_pallets:
            for _item_shipment_pallets in self.shipment_pallets:
                if _item_shipment_pallets:
                    _items.append(_item_shipment_pallets.to_dict())
            _dict['shipmentPallets'] = _items
        # set to None if shipment_pallets (nullable) is None
        # and model_fields_set contains the field
        if self.shipment_pallets is None and "shipment_pallets" in self.model_fields_set:
            _dict['shipmentPallets'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateShipmentPalletRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "shipmentId": obj.get("shipmentId"),
            "shippingPlanId": obj.get("shippingPlanId"),
            "shipmentPallets": [ShipmentPalletUpdateModel.from_dict(_item) for _item in obj["shipmentPallets"]] if obj.get("shipmentPallets") is not None else None
        })
        return _obj


