# coding: utf-8

"""
    Warehouse Transfer

    Warehouse Transfer v1

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.warehousetransfer_new.models.transfer_status import TransferStatus
from linnworks_api.generated.warehousetransfer_new.models.transfer_type import TransferType
from typing import Optional, Set
from typing_extensions import Self

class WarehouseTransferViewModel(BaseModel):
    """
    WarehouseTransferViewModel
    """ # noqa: E501
    pk_transfer_id: Optional[StrictInt] = Field(default=None, alias="pkTransferId")
    from_location_id: Optional[StrictStr] = Field(default=None, alias="fromLocationId")
    to_location_id: Optional[StrictStr] = Field(default=None, alias="toLocationId")
    from_location: Optional[StrictStr] = Field(default=None, alias="fromLocation")
    to_location: Optional[StrictStr] = Field(default=None, alias="toLocation")
    status: Optional[TransferStatus] = None
    transfer_type: Optional[TransferType] = Field(default=None, alias="transferType")
    reference_number: Optional[StrictStr] = Field(default=None, alias="referenceNumber")
    create_date: Optional[datetime] = Field(default=None, alias="createDate")
    update_date: Optional[datetime] = Field(default=None, alias="updateDate")
    number_of_items: Optional[StrictInt] = Field(default=None, alias="numberOfItems")
    total_requested_quantity: Optional[StrictInt] = Field(default=None, alias="totalRequestedQuantity")
    total_received_quantity: Optional[StrictInt] = Field(default=None, alias="totalReceivedQuantity")
    total_sent_quantity: Optional[StrictInt] = Field(default=None, alias="totalSentQuantity")
    __properties: ClassVar[List[str]] = ["pkTransferId", "fromLocationId", "toLocationId", "fromLocation", "toLocation", "status", "transferType", "referenceNumber", "createDate", "updateDate", "numberOfItems", "totalRequestedQuantity", "totalReceivedQuantity", "totalSentQuantity"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WarehouseTransferViewModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if from_location (nullable) is None
        # and model_fields_set contains the field
        if self.from_location is None and "from_location" in self.model_fields_set:
            _dict['fromLocation'] = None

        # set to None if to_location (nullable) is None
        # and model_fields_set contains the field
        if self.to_location is None and "to_location" in self.model_fields_set:
            _dict['toLocation'] = None

        # set to None if reference_number (nullable) is None
        # and model_fields_set contains the field
        if self.reference_number is None and "reference_number" in self.model_fields_set:
            _dict['referenceNumber'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WarehouseTransferViewModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pkTransferId": obj.get("pkTransferId"),
            "fromLocationId": obj.get("fromLocationId"),
            "toLocationId": obj.get("toLocationId"),
            "fromLocation": obj.get("fromLocation"),
            "toLocation": obj.get("toLocation"),
            "status": obj.get("status"),
            "transferType": obj.get("transferType"),
            "referenceNumber": obj.get("referenceNumber"),
            "createDate": obj.get("createDate"),
            "updateDate": obj.get("updateDate"),
            "numberOfItems": obj.get("numberOfItems"),
            "totalRequestedQuantity": obj.get("totalRequestedQuantity"),
            "totalReceivedQuantity": obj.get("totalReceivedQuantity"),
            "totalSentQuantity": obj.get("totalSentQuantity")
        })
        return _obj


