# coding: utf-8

"""
    Warehouse Transfer

    Warehouse Transfer v2

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import StrictInt
from typing import List
from linnworks_api.generated.warehousetransfer_v2.models.add_shipment_box_item_model import AddShipmentBoxItemModel
from linnworks_api.generated.warehousetransfer_v2.models.get_shipment_box_items_response import GetShipmentBoxItemsResponse
from linnworks_api.generated.warehousetransfer_v2.models.shipment_box_item_model import ShipmentBoxItemModel
from linnworks_api.generated.warehousetransfer_v2.models.update_shipment_box_item_model import UpdateShipmentBoxItemModel

from linnworks_api.generated.warehousetransfer_v2.api_client import ApiClient, RequestSerialized
from linnworks_api.generated.warehousetransfer_v2.api_response import ApiResponse
from linnworks_api.generated.warehousetransfer_v2.rest import RESTResponseType


class ShipmentBoxItemApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def warehousetransfer_fba_inbound_shipping_plans_shipping_plan_id_box_items_delete(
        self,
        shipping_plan_id: StrictInt,
        shipment_box_item_ids: List[StrictInt],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """DeleteShipmentBoxItems


        :param shipping_plan_id: (required)
        :type shipping_plan_id: int
        :param shipment_box_item_ids: (required)
        :type shipment_box_item_ids: List[int]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._warehousetransfer_fba_inbound_shipping_plans_shipping_plan_id_box_items_delete_serialize(
            shipping_plan_id=shipping_plan_id,
            shipment_box_item_ids=shipment_box_item_ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '404': "int",
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '204': None,
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def warehousetransfer_fba_inbound_shipping_plans_shipping_plan_id_box_items_delete_with_http_info(
        self,
        shipping_plan_id: StrictInt,
        shipment_box_item_ids: List[StrictInt],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """DeleteShipmentBoxItems


        :param shipping_plan_id: (required)
        :type shipping_plan_id: int
        :param shipment_box_item_ids: (required)
        :type shipment_box_item_ids: List[int]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._warehousetransfer_fba_inbound_shipping_plans_shipping_plan_id_box_items_delete_serialize(
            shipping_plan_id=shipping_plan_id,
            shipment_box_item_ids=shipment_box_item_ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '404': "int",
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '204': None,
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def warehousetransfer_fba_inbound_shipping_plans_shipping_plan_id_box_items_delete_without_preload_content(
        self,
        shipping_plan_id: StrictInt,
        shipment_box_item_ids: List[StrictInt],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """DeleteShipmentBoxItems


        :param shipping_plan_id: (required)
        :type shipping_plan_id: int
        :param shipment_box_item_ids: (required)
        :type shipment_box_item_ids: List[int]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._warehousetransfer_fba_inbound_shipping_plans_shipping_plan_id_box_items_delete_serialize(
            shipping_plan_id=shipping_plan_id,
            shipment_box_item_ids=shipment_box_item_ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '404': "int",
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '204': None,
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _warehousetransfer_fba_inbound_shipping_plans_shipping_plan_id_box_items_delete_serialize(
        self,
        shipping_plan_id,
        shipment_box_item_ids,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'shipmentBoxItemIds': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if shipping_plan_id is not None:
            _path_params['shippingPlanId'] = shipping_plan_id
        # process the query parameters
        if shipment_box_item_ids is not None:
            
            _query_params.append(('shipmentBoxItemIds', shipment_box_item_ids))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Linnworks'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/warehousetransfer/fba-inbound/shipping-plans/{shippingPlanId}/box-items',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def warehousetransfer_fba_inbound_shipping_plans_shipping_plan_id_box_items_packing_groups_packing_group_id_get(
        self,
        shipping_plan_id: StrictInt,
        packing_group_id: StrictInt,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetShipmentBoxItemsResponse:
        """GetShipmentBoxItems


        :param shipping_plan_id: (required)
        :type shipping_plan_id: int
        :param packing_group_id: (required)
        :type packing_group_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._warehousetransfer_fba_inbound_shipping_plans_shipping_plan_id_box_items_packing_groups_packing_group_id_get_serialize(
            shipping_plan_id=shipping_plan_id,
            packing_group_id=packing_group_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetShipmentBoxItemsResponse",
            '404': "ProblemDetails",
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def warehousetransfer_fba_inbound_shipping_plans_shipping_plan_id_box_items_packing_groups_packing_group_id_get_with_http_info(
        self,
        shipping_plan_id: StrictInt,
        packing_group_id: StrictInt,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetShipmentBoxItemsResponse]:
        """GetShipmentBoxItems


        :param shipping_plan_id: (required)
        :type shipping_plan_id: int
        :param packing_group_id: (required)
        :type packing_group_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._warehousetransfer_fba_inbound_shipping_plans_shipping_plan_id_box_items_packing_groups_packing_group_id_get_serialize(
            shipping_plan_id=shipping_plan_id,
            packing_group_id=packing_group_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetShipmentBoxItemsResponse",
            '404': "ProblemDetails",
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def warehousetransfer_fba_inbound_shipping_plans_shipping_plan_id_box_items_packing_groups_packing_group_id_get_without_preload_content(
        self,
        shipping_plan_id: StrictInt,
        packing_group_id: StrictInt,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """GetShipmentBoxItems


        :param shipping_plan_id: (required)
        :type shipping_plan_id: int
        :param packing_group_id: (required)
        :type packing_group_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._warehousetransfer_fba_inbound_shipping_plans_shipping_plan_id_box_items_packing_groups_packing_group_id_get_serialize(
            shipping_plan_id=shipping_plan_id,
            packing_group_id=packing_group_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetShipmentBoxItemsResponse",
            '404': "ProblemDetails",
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _warehousetransfer_fba_inbound_shipping_plans_shipping_plan_id_box_items_packing_groups_packing_group_id_get_serialize(
        self,
        shipping_plan_id,
        packing_group_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if shipping_plan_id is not None:
            _path_params['shippingPlanId'] = shipping_plan_id
        if packing_group_id is not None:
            _path_params['packingGroupId'] = packing_group_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Linnworks'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/warehousetransfer/fba-inbound/shipping-plans/{shippingPlanId}/box-items/packing-groups/{packingGroupId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def warehousetransfer_fba_inbound_shipping_plans_shipping_plan_id_box_items_post(
        self,
        shipping_plan_id: StrictInt,
        add_shipment_box_item_model: List[AddShipmentBoxItemModel],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[ShipmentBoxItemModel]:
        """AddShipmentBoxItems


        :param shipping_plan_id: (required)
        :type shipping_plan_id: int
        :param add_shipment_box_item_model: (required)
        :type add_shipment_box_item_model: List[AddShipmentBoxItemModel]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._warehousetransfer_fba_inbound_shipping_plans_shipping_plan_id_box_items_post_serialize(
            shipping_plan_id=shipping_plan_id,
            add_shipment_box_item_model=add_shipment_box_item_model,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[ShipmentBoxItemModel]",
            '404': "ProblemDetails",
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def warehousetransfer_fba_inbound_shipping_plans_shipping_plan_id_box_items_post_with_http_info(
        self,
        shipping_plan_id: StrictInt,
        add_shipment_box_item_model: List[AddShipmentBoxItemModel],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[ShipmentBoxItemModel]]:
        """AddShipmentBoxItems


        :param shipping_plan_id: (required)
        :type shipping_plan_id: int
        :param add_shipment_box_item_model: (required)
        :type add_shipment_box_item_model: List[AddShipmentBoxItemModel]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._warehousetransfer_fba_inbound_shipping_plans_shipping_plan_id_box_items_post_serialize(
            shipping_plan_id=shipping_plan_id,
            add_shipment_box_item_model=add_shipment_box_item_model,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[ShipmentBoxItemModel]",
            '404': "ProblemDetails",
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def warehousetransfer_fba_inbound_shipping_plans_shipping_plan_id_box_items_post_without_preload_content(
        self,
        shipping_plan_id: StrictInt,
        add_shipment_box_item_model: List[AddShipmentBoxItemModel],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """AddShipmentBoxItems


        :param shipping_plan_id: (required)
        :type shipping_plan_id: int
        :param add_shipment_box_item_model: (required)
        :type add_shipment_box_item_model: List[AddShipmentBoxItemModel]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._warehousetransfer_fba_inbound_shipping_plans_shipping_plan_id_box_items_post_serialize(
            shipping_plan_id=shipping_plan_id,
            add_shipment_box_item_model=add_shipment_box_item_model,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[ShipmentBoxItemModel]",
            '404': "ProblemDetails",
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _warehousetransfer_fba_inbound_shipping_plans_shipping_plan_id_box_items_post_serialize(
        self,
        shipping_plan_id,
        add_shipment_box_item_model,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'AddShipmentBoxItemModel': '',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if shipping_plan_id is not None:
            _path_params['shippingPlanId'] = shipping_plan_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if add_shipment_box_item_model is not None:
            _body_params = add_shipment_box_item_model


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json-patch+json; x-api-version=2.0', 
                        'application/json; x-api-version=2.0', 
                        'text/json; x-api-version=2.0', 
                        'application/*+json; x-api-version=2.0'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Linnworks'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/warehousetransfer/fba-inbound/shipping-plans/{shippingPlanId}/box-items',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def warehousetransfer_fba_inbound_shipping_plans_shipping_plan_id_box_items_put(
        self,
        shipping_plan_id: StrictInt,
        update_shipment_box_item_model: List[UpdateShipmentBoxItemModel],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[ShipmentBoxItemModel]:
        """UpdateShipmentBoxItems


        :param shipping_plan_id: (required)
        :type shipping_plan_id: int
        :param update_shipment_box_item_model: (required)
        :type update_shipment_box_item_model: List[UpdateShipmentBoxItemModel]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._warehousetransfer_fba_inbound_shipping_plans_shipping_plan_id_box_items_put_serialize(
            shipping_plan_id=shipping_plan_id,
            update_shipment_box_item_model=update_shipment_box_item_model,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[ShipmentBoxItemModel]",
            '404': "ProblemDetails",
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def warehousetransfer_fba_inbound_shipping_plans_shipping_plan_id_box_items_put_with_http_info(
        self,
        shipping_plan_id: StrictInt,
        update_shipment_box_item_model: List[UpdateShipmentBoxItemModel],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[ShipmentBoxItemModel]]:
        """UpdateShipmentBoxItems


        :param shipping_plan_id: (required)
        :type shipping_plan_id: int
        :param update_shipment_box_item_model: (required)
        :type update_shipment_box_item_model: List[UpdateShipmentBoxItemModel]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._warehousetransfer_fba_inbound_shipping_plans_shipping_plan_id_box_items_put_serialize(
            shipping_plan_id=shipping_plan_id,
            update_shipment_box_item_model=update_shipment_box_item_model,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[ShipmentBoxItemModel]",
            '404': "ProblemDetails",
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def warehousetransfer_fba_inbound_shipping_plans_shipping_plan_id_box_items_put_without_preload_content(
        self,
        shipping_plan_id: StrictInt,
        update_shipment_box_item_model: List[UpdateShipmentBoxItemModel],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """UpdateShipmentBoxItems


        :param shipping_plan_id: (required)
        :type shipping_plan_id: int
        :param update_shipment_box_item_model: (required)
        :type update_shipment_box_item_model: List[UpdateShipmentBoxItemModel]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._warehousetransfer_fba_inbound_shipping_plans_shipping_plan_id_box_items_put_serialize(
            shipping_plan_id=shipping_plan_id,
            update_shipment_box_item_model=update_shipment_box_item_model,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[ShipmentBoxItemModel]",
            '404': "ProblemDetails",
            '400': "ProblemDetails",
            '405': "ProblemDetails",
            '401': "ProblemDetails",
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _warehousetransfer_fba_inbound_shipping_plans_shipping_plan_id_box_items_put_serialize(
        self,
        shipping_plan_id,
        update_shipment_box_item_model,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'UpdateShipmentBoxItemModel': '',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if shipping_plan_id is not None:
            _path_params['shippingPlanId'] = shipping_plan_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_shipment_box_item_model is not None:
            _body_params = update_shipment_box_item_model


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json-patch+json; x-api-version=2.0', 
                        'application/json; x-api-version=2.0', 
                        'text/json; x-api-version=2.0', 
                        'application/*+json; x-api-version=2.0'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Linnworks'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/warehousetransfer/fba-inbound/shipping-plans/{shippingPlanId}/box-items',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


