# linnworks_api.generated.warehousetransfer_v2.TransferCardsApi

All URIs are relative to *https://eu-api.linnworks.net/v2*

Method | HTTP request | Description
------------- | ------------- | -------------
[**warehousetransfer_fba_inbound_transfer_cards_refresh_post**](TransferCardsApi.md#warehousetransfer_fba_inbound_transfer_cards_refresh_post) | **POST** /warehousetransfer/fba-inbound/transfer-cards/refresh | RequestShipmentCardsUpdate
[**warehousetransfer_fba_inbound_transfer_cards_shipments_get**](TransferCardsApi.md#warehousetransfer_fba_inbound_transfer_cards_shipments_get) | **GET** /warehousetransfer/fba-inbound/transfer-cards/shipments | GetShipmentCards
[**warehousetransfer_fba_inbound_transfer_cards_shipping_plans_get**](TransferCardsApi.md#warehousetransfer_fba_inbound_transfer_cards_shipping_plans_get) | **GET** /warehousetransfer/fba-inbound/transfer-cards/shipping-plans | GetShippingPlanCards
[**warehousetransfer_fba_inbound_transfer_cards_shipping_plans_shipping_plan_id_get**](TransferCardsApi.md#warehousetransfer_fba_inbound_transfer_cards_shipping_plans_shipping_plan_id_get) | **GET** /warehousetransfer/fba-inbound/transfer-cards/shipping-plans/{shippingPlanId} | GetShippingPlanCardById


# **warehousetransfer_fba_inbound_transfer_cards_refresh_post**
> warehousetransfer_fba_inbound_transfer_cards_refresh_post()

RequestShipmentCardsUpdate

### Example

* Api Key Authentication (Linnworks):

```python
import linnworks_api.generated.warehousetransfer_v2
from linnworks_api.generated.warehousetransfer_v2.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-api.linnworks.net/v2
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer_v2.Configuration(
    host = "https://eu-api.linnworks.net/v2"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: Linnworks
configuration.api_key['Linnworks'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Linnworks'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer_v2.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer_v2.TransferCardsApi(api_client)

    try:
        # RequestShipmentCardsUpdate
        api_instance.warehousetransfer_fba_inbound_transfer_cards_refresh_post()
    except Exception as e:
        print("Exception when calling TransferCardsApi->warehousetransfer_fba_inbound_transfer_cards_refresh_post: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

void (empty response body)

### Authorization

[Linnworks](../README.md#Linnworks)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**405** | Method Not Allowed |  -  |
**401** | Unauthorized |  -  |
**403** | Forbidden |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **warehousetransfer_fba_inbound_transfer_cards_shipments_get**
> GetShipmentCardsResponse warehousetransfer_fba_inbound_transfer_cards_shipments_get()

GetShipmentCards

### Example

* Api Key Authentication (Linnworks):

```python
import linnworks_api.generated.warehousetransfer_v2
from linnworks_api.generated.warehousetransfer_v2.models.get_shipment_cards_response import GetShipmentCardsResponse
from linnworks_api.generated.warehousetransfer_v2.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-api.linnworks.net/v2
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer_v2.Configuration(
    host = "https://eu-api.linnworks.net/v2"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: Linnworks
configuration.api_key['Linnworks'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Linnworks'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer_v2.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer_v2.TransferCardsApi(api_client)

    try:
        # GetShipmentCards
        api_response = api_instance.warehousetransfer_fba_inbound_transfer_cards_shipments_get()
        print("The response of TransferCardsApi->warehousetransfer_fba_inbound_transfer_cards_shipments_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling TransferCardsApi->warehousetransfer_fba_inbound_transfer_cards_shipments_get: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**GetShipmentCardsResponse**](GetShipmentCardsResponse.md)

### Authorization

[Linnworks](../README.md#Linnworks)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**405** | Method Not Allowed |  -  |
**401** | Unauthorized |  -  |
**403** | Forbidden |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **warehousetransfer_fba_inbound_transfer_cards_shipping_plans_get**
> List[GetShippingPlanCardsResponse] warehousetransfer_fba_inbound_transfer_cards_shipping_plans_get()

GetShippingPlanCards

### Example

* Api Key Authentication (Linnworks):

```python
import linnworks_api.generated.warehousetransfer_v2
from linnworks_api.generated.warehousetransfer_v2.models.get_shipping_plan_cards_response import GetShippingPlanCardsResponse
from linnworks_api.generated.warehousetransfer_v2.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-api.linnworks.net/v2
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer_v2.Configuration(
    host = "https://eu-api.linnworks.net/v2"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: Linnworks
configuration.api_key['Linnworks'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Linnworks'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer_v2.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer_v2.TransferCardsApi(api_client)

    try:
        # GetShippingPlanCards
        api_response = api_instance.warehousetransfer_fba_inbound_transfer_cards_shipping_plans_get()
        print("The response of TransferCardsApi->warehousetransfer_fba_inbound_transfer_cards_shipping_plans_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling TransferCardsApi->warehousetransfer_fba_inbound_transfer_cards_shipping_plans_get: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**List[GetShippingPlanCardsResponse]**](GetShippingPlanCardsResponse.md)

### Authorization

[Linnworks](../README.md#Linnworks)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**405** | Method Not Allowed |  -  |
**401** | Unauthorized |  -  |
**403** | Forbidden |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **warehousetransfer_fba_inbound_transfer_cards_shipping_plans_shipping_plan_id_get**
> GetShippingPlanCardsResponse warehousetransfer_fba_inbound_transfer_cards_shipping_plans_shipping_plan_id_get(shipping_plan_id)

GetShippingPlanCardById

### Example

* Api Key Authentication (Linnworks):

```python
import linnworks_api.generated.warehousetransfer_v2
from linnworks_api.generated.warehousetransfer_v2.models.get_shipping_plan_cards_response import GetShippingPlanCardsResponse
from linnworks_api.generated.warehousetransfer_v2.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-api.linnworks.net/v2
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer_v2.Configuration(
    host = "https://eu-api.linnworks.net/v2"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: Linnworks
configuration.api_key['Linnworks'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Linnworks'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer_v2.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer_v2.TransferCardsApi(api_client)
    shipping_plan_id = 56 # int | 

    try:
        # GetShippingPlanCardById
        api_response = api_instance.warehousetransfer_fba_inbound_transfer_cards_shipping_plans_shipping_plan_id_get(shipping_plan_id)
        print("The response of TransferCardsApi->warehousetransfer_fba_inbound_transfer_cards_shipping_plans_shipping_plan_id_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling TransferCardsApi->warehousetransfer_fba_inbound_transfer_cards_shipping_plans_shipping_plan_id_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **shipping_plan_id** | **int**|  | 

### Return type

[**GetShippingPlanCardsResponse**](GetShippingPlanCardsResponse.md)

### Authorization

[Linnworks](../README.md#Linnworks)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**405** | Method Not Allowed |  -  |
**401** | Unauthorized |  -  |
**403** | Forbidden |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

