# coding: utf-8

"""
    Warehouse Transfer

    Warehouse Transfer v2

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.warehousetransfer_v2.models.shipment_box_item_extended_model import ShipmentBoxItemExtendedModel
from linnworks_api.generated.warehousetransfer_v2.models.unit_of_measurement import UnitOfMeasurement
from linnworks_api.generated.warehousetransfer_v2.models.unit_of_weight import UnitOfWeight
from typing import Optional, Set
from typing_extensions import Self

class GetShipmentBoxItemsResponse(BaseModel):
    """
    GetShipmentBoxItemsResponse
    """ # noqa: E501
    box_items: Optional[List[ShipmentBoxItemExtendedModel]] = Field(default=None, alias="boxItems")
    weight_unit: Optional[UnitOfWeight] = Field(default=None, alias="weightUnit")
    dimension_unit: Optional[UnitOfMeasurement] = Field(default=None, alias="dimensionUnit")
    __properties: ClassVar[List[str]] = ["boxItems", "weightUnit", "dimensionUnit"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetShipmentBoxItemsResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in box_items (list)
        _items = []
        if self.box_items:
            for _item_box_items in self.box_items:
                if _item_box_items:
                    _items.append(_item_box_items.to_dict())
            _dict['boxItems'] = _items
        # set to None if box_items (nullable) is None
        # and model_fields_set contains the field
        if self.box_items is None and "box_items" in self.model_fields_set:
            _dict['boxItems'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetShipmentBoxItemsResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "boxItems": [ShipmentBoxItemExtendedModel.from_dict(_item) for _item in obj["boxItems"]] if obj.get("boxItems") is not None else None,
            "weightUnit": obj.get("weightUnit"),
            "dimensionUnit": obj.get("dimensionUnit")
        })
        return _obj


