# coding: utf-8

"""
    Warehouse Transfer

    Warehouse Transfer v2

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.warehousetransfer_v2.models.shipment_response import ShipmentResponse
from linnworks_api.generated.warehousetransfer_v2.models.shipping_plan_status import ShippingPlanStatus
from typing import Optional, Set
from typing_extensions import Self

class GetShippingPlanByIdResponse(BaseModel):
    """
    GetShippingPlanByIdResponse
    """ # noqa: E501
    channel_id: Optional[StrictInt] = Field(default=None, alias="channelId")
    default_shipment_id: Optional[StrictStr] = Field(default=None, alias="defaultShipmentId")
    from_location: Optional[StrictStr] = Field(default=None, alias="fromLocation")
    id: Optional[StrictInt] = None
    is_packing_info_known: Optional[StrictBool] = Field(default=None, alias="isPackingInfoKnown")
    plan_id: Optional[StrictStr] = Field(default=None, alias="planId")
    shipment_items_count: Optional[StrictInt] = Field(default=None, alias="shipmentItemsCount")
    shipments: Optional[List[ShipmentResponse]] = None
    status: Optional[ShippingPlanStatus] = None
    to_location: Optional[StrictStr] = Field(default=None, alias="toLocation")
    placement_option_id: Optional[StrictStr] = Field(default=None, alias="placementOptionId")
    __properties: ClassVar[List[str]] = ["channelId", "defaultShipmentId", "fromLocation", "id", "isPackingInfoKnown", "planId", "shipmentItemsCount", "shipments", "status", "toLocation", "placementOptionId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetShippingPlanByIdResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in shipments (list)
        _items = []
        if self.shipments:
            for _item_shipments in self.shipments:
                if _item_shipments:
                    _items.append(_item_shipments.to_dict())
            _dict['shipments'] = _items
        # set to None if default_shipment_id (nullable) is None
        # and model_fields_set contains the field
        if self.default_shipment_id is None and "default_shipment_id" in self.model_fields_set:
            _dict['defaultShipmentId'] = None

        # set to None if is_packing_info_known (nullable) is None
        # and model_fields_set contains the field
        if self.is_packing_info_known is None and "is_packing_info_known" in self.model_fields_set:
            _dict['isPackingInfoKnown'] = None

        # set to None if plan_id (nullable) is None
        # and model_fields_set contains the field
        if self.plan_id is None and "plan_id" in self.model_fields_set:
            _dict['planId'] = None

        # set to None if shipments (nullable) is None
        # and model_fields_set contains the field
        if self.shipments is None and "shipments" in self.model_fields_set:
            _dict['shipments'] = None

        # set to None if placement_option_id (nullable) is None
        # and model_fields_set contains the field
        if self.placement_option_id is None and "placement_option_id" in self.model_fields_set:
            _dict['placementOptionId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetShippingPlanByIdResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "channelId": obj.get("channelId"),
            "defaultShipmentId": obj.get("defaultShipmentId"),
            "fromLocation": obj.get("fromLocation"),
            "id": obj.get("id"),
            "isPackingInfoKnown": obj.get("isPackingInfoKnown"),
            "planId": obj.get("planId"),
            "shipmentItemsCount": obj.get("shipmentItemsCount"),
            "shipments": [ShipmentResponse.from_dict(_item) for _item in obj["shipments"]] if obj.get("shipments") is not None else None,
            "status": obj.get("status"),
            "toLocation": obj.get("toLocation"),
            "placementOptionId": obj.get("placementOptionId")
        })
        return _obj


