# coding: utf-8

"""
    Warehouse Transfer

    Warehouse Transfer v2

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.warehousetransfer_v2.models.shipment_search_model import ShipmentSearchModel
from linnworks_api.generated.warehousetransfer_v2.models.shipping_plan_status import ShippingPlanStatus
from linnworks_api.generated.warehousetransfer_v2.models.stock_item_search_model import StockItemSearchModel
from linnworks_api.generated.warehousetransfer_v2.models.transfer_card import TransferCard
from typing import Optional, Set
from typing_extensions import Self

class GetShippingPlanCardsResponse(BaseModel):
    """
    GetShippingPlanCardsResponse
    """ # noqa: E501
    channel_id: Optional[StrictInt] = Field(default=None, alias="channelId")
    create_date: Optional[datetime] = Field(default=None, alias="createDate")
    update_date: Optional[datetime] = Field(default=None, alias="updateDate")
    from_location: Optional[StrictStr] = Field(default=None, alias="fromLocation")
    id: Optional[StrictInt] = None
    shipping_plan_id: Optional[StrictInt] = Field(default=None, alias="shippingPlanId")
    inbound_plan_id: Optional[StrictStr] = Field(default=None, alias="inboundPlanId")
    is_packing_info_known: Optional[StrictBool] = Field(default=None, alias="isPackingInfoKnown")
    plan_id: Optional[StrictStr] = Field(default=None, alias="planId")
    shipment_items_count: Optional[StrictInt] = Field(default=None, alias="shipmentItemsCount")
    shipment_received: Optional[StrictInt] = Field(default=None, alias="shipmentReceived")
    shipment_shipped: Optional[StrictInt] = Field(default=None, alias="shipmentShipped")
    status: Optional[ShippingPlanStatus] = None
    to_location: Optional[StrictStr] = Field(default=None, alias="toLocation")
    type: Optional[TransferCard] = None
    items: Optional[List[StockItemSearchModel]] = None
    shipments: Optional[List[ShipmentSearchModel]] = None
    placement_option_id: Optional[StrictStr] = Field(default=None, alias="placementOptionId")
    __properties: ClassVar[List[str]] = ["channelId", "createDate", "updateDate", "fromLocation", "id", "shippingPlanId", "inboundPlanId", "isPackingInfoKnown", "planId", "shipmentItemsCount", "shipmentReceived", "shipmentShipped", "status", "toLocation", "type", "items", "shipments", "placementOptionId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetShippingPlanCardsResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in items (list)
        _items = []
        if self.items:
            for _item_items in self.items:
                if _item_items:
                    _items.append(_item_items.to_dict())
            _dict['items'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in shipments (list)
        _items = []
        if self.shipments:
            for _item_shipments in self.shipments:
                if _item_shipments:
                    _items.append(_item_shipments.to_dict())
            _dict['shipments'] = _items
        # set to None if inbound_plan_id (nullable) is None
        # and model_fields_set contains the field
        if self.inbound_plan_id is None and "inbound_plan_id" in self.model_fields_set:
            _dict['inboundPlanId'] = None

        # set to None if plan_id (nullable) is None
        # and model_fields_set contains the field
        if self.plan_id is None and "plan_id" in self.model_fields_set:
            _dict['planId'] = None

        # set to None if items (nullable) is None
        # and model_fields_set contains the field
        if self.items is None and "items" in self.model_fields_set:
            _dict['items'] = None

        # set to None if shipments (nullable) is None
        # and model_fields_set contains the field
        if self.shipments is None and "shipments" in self.model_fields_set:
            _dict['shipments'] = None

        # set to None if placement_option_id (nullable) is None
        # and model_fields_set contains the field
        if self.placement_option_id is None and "placement_option_id" in self.model_fields_set:
            _dict['placementOptionId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetShippingPlanCardsResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "channelId": obj.get("channelId"),
            "createDate": obj.get("createDate"),
            "updateDate": obj.get("updateDate"),
            "fromLocation": obj.get("fromLocation"),
            "id": obj.get("id"),
            "shippingPlanId": obj.get("shippingPlanId"),
            "inboundPlanId": obj.get("inboundPlanId"),
            "isPackingInfoKnown": obj.get("isPackingInfoKnown"),
            "planId": obj.get("planId"),
            "shipmentItemsCount": obj.get("shipmentItemsCount"),
            "shipmentReceived": obj.get("shipmentReceived"),
            "shipmentShipped": obj.get("shipmentShipped"),
            "status": obj.get("status"),
            "toLocation": obj.get("toLocation"),
            "type": obj.get("type"),
            "items": [StockItemSearchModel.from_dict(_item) for _item in obj["items"]] if obj.get("items") is not None else None,
            "shipments": [ShipmentSearchModel.from_dict(_item) for _item in obj["shipments"]] if obj.get("shipments") is not None else None,
            "placementOptionId": obj.get("placementOptionId")
        })
        return _obj


