# coding: utf-8

"""
    Warehouse Transfer

    Warehouse Transfer v2

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.warehousetransfer_v2.models.prep_instructions_model import PrepInstructionsModel
from typing import Optional, Set
from typing_extensions import Self

class ItemModel(BaseModel):
    """
    ItemModel
    """ # noqa: E501
    asin: Optional[StrictStr] = None
    fnsku: Optional[StrictStr] = None
    label_owner: Optional[StrictStr] = Field(default=None, alias="labelOwner")
    manufacturing_lot_code: Optional[StrictStr] = Field(default=None, alias="manufacturingLotCode")
    msku: Optional[StrictStr] = None
    quantity: Optional[StrictInt] = None
    thumbnail_source: Optional[StrictStr] = Field(default=None, alias="thumbnailSource")
    title: Optional[StrictStr] = None
    stock_item_id: Optional[StrictStr] = Field(default=None, alias="stockItemId")
    prep_instructions: Optional[List[PrepInstructionsModel]] = Field(default=None, alias="prepInstructions")
    __properties: ClassVar[List[str]] = ["asin", "fnsku", "labelOwner", "manufacturingLotCode", "msku", "quantity", "thumbnailSource", "title", "stockItemId", "prepInstructions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ItemModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in prep_instructions (list)
        _items = []
        if self.prep_instructions:
            for _item_prep_instructions in self.prep_instructions:
                if _item_prep_instructions:
                    _items.append(_item_prep_instructions.to_dict())
            _dict['prepInstructions'] = _items
        # set to None if asin (nullable) is None
        # and model_fields_set contains the field
        if self.asin is None and "asin" in self.model_fields_set:
            _dict['asin'] = None

        # set to None if fnsku (nullable) is None
        # and model_fields_set contains the field
        if self.fnsku is None and "fnsku" in self.model_fields_set:
            _dict['fnsku'] = None

        # set to None if label_owner (nullable) is None
        # and model_fields_set contains the field
        if self.label_owner is None and "label_owner" in self.model_fields_set:
            _dict['labelOwner'] = None

        # set to None if manufacturing_lot_code (nullable) is None
        # and model_fields_set contains the field
        if self.manufacturing_lot_code is None and "manufacturing_lot_code" in self.model_fields_set:
            _dict['manufacturingLotCode'] = None

        # set to None if msku (nullable) is None
        # and model_fields_set contains the field
        if self.msku is None and "msku" in self.model_fields_set:
            _dict['msku'] = None

        # set to None if quantity (nullable) is None
        # and model_fields_set contains the field
        if self.quantity is None and "quantity" in self.model_fields_set:
            _dict['quantity'] = None

        # set to None if thumbnail_source (nullable) is None
        # and model_fields_set contains the field
        if self.thumbnail_source is None and "thumbnail_source" in self.model_fields_set:
            _dict['thumbnailSource'] = None

        # set to None if title (nullable) is None
        # and model_fields_set contains the field
        if self.title is None and "title" in self.model_fields_set:
            _dict['title'] = None

        # set to None if prep_instructions (nullable) is None
        # and model_fields_set contains the field
        if self.prep_instructions is None and "prep_instructions" in self.model_fields_set:
            _dict['prepInstructions'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ItemModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "asin": obj.get("asin"),
            "fnsku": obj.get("fnsku"),
            "labelOwner": obj.get("labelOwner"),
            "manufacturingLotCode": obj.get("manufacturingLotCode"),
            "msku": obj.get("msku"),
            "quantity": obj.get("quantity"),
            "thumbnailSource": obj.get("thumbnailSource"),
            "title": obj.get("title"),
            "stockItemId": obj.get("stockItemId"),
            "prepInstructions": [PrepInstructionsModel.from_dict(_item) for _item in obj["prepInstructions"]] if obj.get("prepInstructions") is not None else None
        })
        return _obj


