# coding: utf-8

"""
    Warehouse Transfer

    Warehouse Transfer v2

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.warehousetransfer_v2.models.operation_problem_model import OperationProblemModel
from linnworks_api.generated.warehousetransfer_v2.models.operation_status import OperationStatus
from linnworks_api.generated.warehousetransfer_v2.models.operation_type import OperationType
from typing import Optional, Set
from typing_extensions import Self

class OperationModel(BaseModel):
    """
    OperationModel
    """ # noqa: E501
    id: Optional[StrictStr] = None
    entity_id: Optional[StrictInt] = Field(default=None, alias="entityId")
    status: Optional[OperationStatus] = None
    type: Optional[OperationType] = None
    created_date: Optional[datetime] = Field(default=None, alias="createdDate")
    problems: Optional[List[OperationProblemModel]] = None
    __properties: ClassVar[List[str]] = ["id", "entityId", "status", "type", "createdDate", "problems"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OperationModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in problems (list)
        _items = []
        if self.problems:
            for _item_problems in self.problems:
                if _item_problems:
                    _items.append(_item_problems.to_dict())
            _dict['problems'] = _items
        # set to None if problems (nullable) is None
        # and model_fields_set contains the field
        if self.problems is None and "problems" in self.model_fields_set:
            _dict['problems'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OperationModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "entityId": obj.get("entityId"),
            "status": obj.get("status"),
            "type": obj.get("type"),
            "createdDate": obj.get("createdDate"),
            "problems": [OperationProblemModel.from_dict(_item) for _item in obj["problems"]] if obj.get("problems") is not None else None
        })
        return _obj


