# coding: utf-8

"""
    Warehouse Transfer

    Warehouse Transfer v2

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.warehousetransfer_v2.models.incentive_model import IncentiveModel
from linnworks_api.generated.warehousetransfer_v2.models.option_status import OptionStatus
from linnworks_api.generated.warehousetransfer_v2.models.shipment_amazon_model import ShipmentAmazonModel
from typing import Optional, Set
from typing_extensions import Self

class PlacementOptionModel(BaseModel):
    """
    PlacementOptionModel
    """ # noqa: E501
    placement_option_id: Optional[StrictStr] = Field(default=None, alias="placementOptionId")
    expiration_date: Optional[datetime] = Field(default=None, alias="expirationDate")
    status: Optional[OptionStatus] = None
    fees: Optional[List[IncentiveModel]] = None
    discounts: Optional[List[IncentiveModel]] = None
    shipments: Optional[List[ShipmentAmazonModel]] = None
    __properties: ClassVar[List[str]] = ["placementOptionId", "expirationDate", "status", "fees", "discounts", "shipments"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PlacementOptionModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in fees (list)
        _items = []
        if self.fees:
            for _item_fees in self.fees:
                if _item_fees:
                    _items.append(_item_fees.to_dict())
            _dict['fees'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in discounts (list)
        _items = []
        if self.discounts:
            for _item_discounts in self.discounts:
                if _item_discounts:
                    _items.append(_item_discounts.to_dict())
            _dict['discounts'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in shipments (list)
        _items = []
        if self.shipments:
            for _item_shipments in self.shipments:
                if _item_shipments:
                    _items.append(_item_shipments.to_dict())
            _dict['shipments'] = _items
        # set to None if placement_option_id (nullable) is None
        # and model_fields_set contains the field
        if self.placement_option_id is None and "placement_option_id" in self.model_fields_set:
            _dict['placementOptionId'] = None

        # set to None if expiration_date (nullable) is None
        # and model_fields_set contains the field
        if self.expiration_date is None and "expiration_date" in self.model_fields_set:
            _dict['expirationDate'] = None

        # set to None if fees (nullable) is None
        # and model_fields_set contains the field
        if self.fees is None and "fees" in self.model_fields_set:
            _dict['fees'] = None

        # set to None if discounts (nullable) is None
        # and model_fields_set contains the field
        if self.discounts is None and "discounts" in self.model_fields_set:
            _dict['discounts'] = None

        # set to None if shipments (nullable) is None
        # and model_fields_set contains the field
        if self.shipments is None and "shipments" in self.model_fields_set:
            _dict['shipments'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PlacementOptionModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "placementOptionId": obj.get("placementOptionId"),
            "expirationDate": obj.get("expirationDate"),
            "status": obj.get("status"),
            "fees": [IncentiveModel.from_dict(_item) for _item in obj["fees"]] if obj.get("fees") is not None else None,
            "discounts": [IncentiveModel.from_dict(_item) for _item in obj["discounts"]] if obj.get("discounts") is not None else None,
            "shipments": [ShipmentAmazonModel.from_dict(_item) for _item in obj["shipments"]] if obj.get("shipments") is not None else None
        })
        return _obj


