# coding: utf-8

"""
    Warehouse Transfer

    Warehouse Transfer v2

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.warehousetransfer_v2.models.item_model import ItemModel
from typing import Optional, Set
from typing_extensions import Self

class ShipmentAmazonModel(BaseModel):
    """
    ShipmentAmazonModel
    """ # noqa: E501
    placement_option_id: Optional[StrictStr] = Field(default=None, alias="placementOptionId")
    shipment_id: Optional[StrictStr] = Field(default=None, alias="shipmentId")
    name: Optional[StrictStr] = None
    shipping_items: Optional[List[ItemModel]] = Field(default=None, alias="shippingItems")
    warehouse_id: Optional[StrictStr] = Field(default=None, alias="warehouseId")
    warehouse_address: Optional[StrictStr] = Field(default=None, alias="warehouseAddress")
    __properties: ClassVar[List[str]] = ["placementOptionId", "shipmentId", "name", "shippingItems", "warehouseId", "warehouseAddress"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ShipmentAmazonModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in shipping_items (list)
        _items = []
        if self.shipping_items:
            for _item_shipping_items in self.shipping_items:
                if _item_shipping_items:
                    _items.append(_item_shipping_items.to_dict())
            _dict['shippingItems'] = _items
        # set to None if placement_option_id (nullable) is None
        # and model_fields_set contains the field
        if self.placement_option_id is None and "placement_option_id" in self.model_fields_set:
            _dict['placementOptionId'] = None

        # set to None if shipment_id (nullable) is None
        # and model_fields_set contains the field
        if self.shipment_id is None and "shipment_id" in self.model_fields_set:
            _dict['shipmentId'] = None

        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if shipping_items (nullable) is None
        # and model_fields_set contains the field
        if self.shipping_items is None and "shipping_items" in self.model_fields_set:
            _dict['shippingItems'] = None

        # set to None if warehouse_id (nullable) is None
        # and model_fields_set contains the field
        if self.warehouse_id is None and "warehouse_id" in self.model_fields_set:
            _dict['warehouseId'] = None

        # set to None if warehouse_address (nullable) is None
        # and model_fields_set contains the field
        if self.warehouse_address is None and "warehouse_address" in self.model_fields_set:
            _dict['warehouseAddress'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ShipmentAmazonModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "placementOptionId": obj.get("placementOptionId"),
            "shipmentId": obj.get("shipmentId"),
            "name": obj.get("name"),
            "shippingItems": [ItemModel.from_dict(_item) for _item in obj["shippingItems"]] if obj.get("shippingItems") is not None else None,
            "warehouseId": obj.get("warehouseId"),
            "warehouseAddress": obj.get("warehouseAddress")
        })
        return _obj


