# coding: utf-8

"""
    Authenticate API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: auth
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.auth.models.status_details import StatusDetails
from typing import Optional, Set
from typing_extensions import Self

class BaseSession(BaseModel):
    """
    BaseSession
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, alias="Id")
    entity_id: Optional[StrictStr] = Field(default=None, alias="EntityId")
    database_name: Optional[StrictStr] = Field(default=None, alias="DatabaseName")
    database_server: Optional[StrictStr] = Field(default=None, alias="DatabaseServer")
    private_database_server: Optional[StrictStr] = Field(default=None, alias="PrivateDatabaseServer")
    database_user: Optional[StrictStr] = Field(default=None, alias="DatabaseUser")
    database_password: Optional[StrictStr] = Field(default=None, alias="DatabasePassword")
    app_name: Optional[StrictStr] = Field(default=None, alias="AppName")
    sid_registration: Optional[StrictStr] = None
    user_name: Optional[StrictStr] = Field(default=None, alias="UserName")
    md5_hash: Optional[StrictStr] = Field(default=None, alias="Md5Hash")
    locality: Optional[StrictStr] = Field(default=None, alias="Locality")
    super_admin: Optional[StrictBool] = Field(default=None, alias="SuperAdmin")
    ttl: Optional[StrictInt] = Field(default=None, alias="TTL")
    token: Optional[StrictStr] = Field(default=None, alias="Token")
    access_token: Optional[StrictStr] = Field(default=None, alias="AccessToken")
    group_name: Optional[StrictStr] = Field(default=None, alias="GroupName")
    device: Optional[StrictStr] = Field(default=None, alias="Device")
    device_type: Optional[StrictStr] = Field(default=None, alias="DeviceType")
    user_type: Optional[StrictStr] = Field(default=None, alias="UserType")
    status: Optional[StatusDetails] = Field(default=None, alias="Status")
    user_id: Optional[StrictStr] = Field(default=None, alias="UserId")
    properties: Optional[Dict[str, StrictStr]] = Field(default=None, alias="Properties")
    email: Optional[StrictStr] = Field(default=None, alias="Email")
    server: Optional[StrictStr] = Field(default=None, alias="Server")
    push_server: Optional[StrictStr] = Field(default=None, alias="PushServer")
    __properties: ClassVar[List[str]] = ["Id", "EntityId", "DatabaseName", "DatabaseServer", "PrivateDatabaseServer", "DatabaseUser", "DatabasePassword", "AppName", "sid_registration", "UserName", "Md5Hash", "Locality", "SuperAdmin", "TTL", "Token", "AccessToken", "GroupName", "Device", "DeviceType", "UserType", "Status", "UserId", "Properties", "Email", "Server", "PushServer"]

    @field_validator('locality')
    def locality_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['EU', 'US', 'AS']):
            raise ValueError("must be one of enum values ('EU', 'US', 'AS')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BaseSession from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "sid_registration",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of status
        if self.status:
            _dict['Status'] = self.status.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BaseSession from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Id": obj.get("Id"),
            "EntityId": obj.get("EntityId"),
            "DatabaseName": obj.get("DatabaseName"),
            "DatabaseServer": obj.get("DatabaseServer"),
            "PrivateDatabaseServer": obj.get("PrivateDatabaseServer"),
            "DatabaseUser": obj.get("DatabaseUser"),
            "DatabasePassword": obj.get("DatabasePassword"),
            "AppName": obj.get("AppName"),
            "sid_registration": obj.get("sid_registration"),
            "UserName": obj.get("UserName"),
            "Md5Hash": obj.get("Md5Hash"),
            "Locality": obj.get("Locality"),
            "SuperAdmin": obj.get("SuperAdmin"),
            "TTL": obj.get("TTL"),
            "Token": obj.get("Token"),
            "AccessToken": obj.get("AccessToken"),
            "GroupName": obj.get("GroupName"),
            "Device": obj.get("Device"),
            "DeviceType": obj.get("DeviceType"),
            "UserType": obj.get("UserType"),
            "Status": StatusDetails.from_dict(obj["Status"]) if obj.get("Status") is not None else None,
            "UserId": obj.get("UserId"),
            "Properties": obj.get("Properties"),
            "Email": obj.get("Email"),
            "Server": obj.get("Server"),
            "PushServer": obj.get("PushServer")
        })
        return _obj


