# coding: utf-8

"""
    Email API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: email
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.email.models.email_template_type import EmailTemplateType
from typing import Optional, Set
from typing_extensions import Self

class EmailTemplate(BaseModel):
    """
    EmailTemplate
    """ # noqa: E501
    pk_email_template_row_id: Optional[StrictInt] = Field(default=None, alias="pkEmailTemplateRowId")
    name: Optional[StrictStr] = Field(default=None, alias="Name")
    enabled: Optional[StrictBool] = Field(default=None, alias="Enabled")
    template_type: Optional[StrictStr] = Field(default=None, alias="TemplateType")
    template_type_definition: Optional[EmailTemplateType] = Field(default=None, alias="TemplateTypeDefinition")
    subject: Optional[StrictStr] = Field(default=None, alias="Subject")
    condition: Optional[StrictStr] = Field(default=None, alias="Condition")
    preview_before_generating: Optional[StrictBool] = Field(default=None, alias="PreviewBeforeGenerating")
    html: Optional[StrictBool] = Field(default=None, alias="HTML")
    attach_pdf: Optional[StrictBool] = Field(default=None, alias="AttachPDF")
    body: Optional[StrictStr] = Field(default=None, alias="Body")
    fk_email_account_row_id: Optional[StrictInt] = Field(default=None, alias="fkEmailAccountRowId")
    prompt_preview_reference_number: Optional[StrictStr] = Field(default=None, alias="PromptPreviewReferenceNumber")
    __properties: ClassVar[List[str]] = ["pkEmailTemplateRowId", "Name", "Enabled", "TemplateType", "TemplateTypeDefinition", "Subject", "Condition", "PreviewBeforeGenerating", "HTML", "AttachPDF", "Body", "fkEmailAccountRowId", "PromptPreviewReferenceNumber"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EmailTemplate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "prompt_preview_reference_number",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of template_type_definition
        if self.template_type_definition:
            _dict['TemplateTypeDefinition'] = self.template_type_definition.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EmailTemplate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pkEmailTemplateRowId": obj.get("pkEmailTemplateRowId"),
            "Name": obj.get("Name"),
            "Enabled": obj.get("Enabled"),
            "TemplateType": obj.get("TemplateType"),
            "TemplateTypeDefinition": EmailTemplateType.from_dict(obj["TemplateTypeDefinition"]) if obj.get("TemplateTypeDefinition") is not None else None,
            "Subject": obj.get("Subject"),
            "Condition": obj.get("Condition"),
            "PreviewBeforeGenerating": obj.get("PreviewBeforeGenerating"),
            "HTML": obj.get("HTML"),
            "AttachPDF": obj.get("AttachPDF"),
            "Body": obj.get("Body"),
            "fkEmailAccountRowId": obj.get("fkEmailAccountRowId"),
            "PromptPreviewReferenceNumber": obj.get("PromptPreviewReferenceNumber")
        })
        return _obj


