# coding: utf-8

"""
    Generic Listings API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: genericlistings
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.genericlistings.models.tuple_int32_int32 import TupleInt32Int32
from typing import Optional, Set
from typing_extensions import Self

class InventorySearchParameters(BaseModel):
    """
    InventorySearchParameters
    """ # noqa: E501
    selected_regions: Optional[List[TupleInt32Int32]] = Field(default=None, alias="SelectedRegions")
    token: Optional[StrictStr] = Field(default=None, alias="Token")
    inventory_item_ids: Optional[List[StrictStr]] = Field(default=None, alias="InventoryItemIds")
    channel_id: Optional[StrictInt] = Field(default=None, alias="ChannelId")
    __properties: ClassVar[List[str]] = ["SelectedRegions", "Token", "InventoryItemIds", "ChannelId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InventorySearchParameters from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in selected_regions (list)
        _items = []
        if self.selected_regions:
            for _item_selected_regions in self.selected_regions:
                if _item_selected_regions:
                    _items.append(_item_selected_regions.to_dict())
            _dict['SelectedRegions'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InventorySearchParameters from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "SelectedRegions": [TupleInt32Int32.from_dict(_item) for _item in obj["SelectedRegions"]] if obj.get("SelectedRegions") is not None else None,
            "Token": obj.get("Token"),
            "InventoryItemIds": obj.get("InventoryItemIds"),
            "ChannelId": obj.get("ChannelId")
        })
        return _obj


