# coding: utf-8

"""
    Import and Export API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: importexport
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.importexport.models.filters import Filters
from linnworks_api.generated.importexport.models.sub_query_output_mapping_selection_field import SubQueryOutputMappingSelectionField
from typing import Optional, Set
from typing_extensions import Self

class ExportColumn(BaseModel):
    """
    ExportColumn
    """ # noqa: E501
    order: Optional[StrictInt] = Field(default=None, alias="Order")
    filters: Optional[Filters] = Field(default=None, alias="Filters")
    export_to_file: Optional[StrictBool] = Field(default=None, alias="ExportToFile")
    sub_query_selection: Optional[List[SubQueryOutputMappingSelectionField]] = Field(default=None, alias="SubQuerySelection")
    file_column: Optional[StrictStr] = Field(default=None, alias="FileColumn")
    column: Optional[StrictStr] = Field(default=None, alias="Column")
    expression: Optional[StrictStr] = Field(default=None, alias="Expression")
    default_value: Optional[StrictStr] = Field(default=None, alias="DefaultValue")
    visible: Optional[StrictBool] = Field(default=None, alias="Visible")
    __properties: ClassVar[List[str]] = ["Order", "Filters", "ExportToFile", "SubQuerySelection", "FileColumn", "Column", "Expression", "DefaultValue", "Visible"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ExportColumn from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of filters
        if self.filters:
            _dict['Filters'] = self.filters.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in sub_query_selection (list)
        _items = []
        if self.sub_query_selection:
            for _item_sub_query_selection in self.sub_query_selection:
                if _item_sub_query_selection:
                    _items.append(_item_sub_query_selection.to_dict())
            _dict['SubQuerySelection'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ExportColumn from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Order": obj.get("Order"),
            "Filters": Filters.from_dict(obj["Filters"]) if obj.get("Filters") is not None else None,
            "ExportToFile": obj.get("ExportToFile"),
            "SubQuerySelection": [SubQueryOutputMappingSelectionField.from_dict(_item) for _item in obj["SubQuerySelection"]] if obj.get("SubQuerySelection") is not None else None,
            "FileColumn": obj.get("FileColumn"),
            "Column": obj.get("Column"),
            "Expression": obj.get("Expression"),
            "DefaultValue": obj.get("DefaultValue"),
            "Visible": obj.get("Visible")
        })
        return _obj


