# coding: utf-8

"""
    Import and Export API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: importexport
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from importlib import import_module
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set

from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from linnworks_api.generated.importexport.models.export_feed_bucket import ExportFeedBucket
    from linnworks_api.generated.importexport.models.export_feed_dropbox import ExportFeedDropbox
    from linnworks_api.generated.importexport.models.export_feed_ftp import ExportFeedFTP
    from linnworks_api.generated.importexport.models.export_feed_ftps import ExportFeedFTPS
    from linnworks_api.generated.importexport.models.export_feed_http import ExportFeedHTTP
    from linnworks_api.generated.importexport.models.export_feed_sftp import ExportFeedSFTP

class ExportGenericFeed(BaseModel):
    """
    ExportGenericFeed
    """ # noqa: E501
    feed_type: Optional[StrictStr] = Field(default=None, alias="FeedType")
    file_name: Optional[StrictStr] = Field(default=None, alias="FileName")
    file_path: Optional[StrictStr] = Field(default=None, alias="FilePath")
    temp_file_name: Optional[StrictStr] = Field(default=None, alias="TempFileName")
    if_file_exist: Optional[StrictStr] = Field(default=None, alias="IfFileExist")
    discriminator: StrictStr
    __properties: ClassVar[List[str]] = ["FeedType", "FileName", "FilePath", "TempFileName", "IfFileExist", "discriminator"]

    @field_validator('feed_type')
    def feed_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['FTP', 'SFTP', 'BUCKET', 'DROPBOX', 'HTTP', 'FTPS']):
            raise ValueError("must be one of enum values ('FTP', 'SFTP', 'BUCKET', 'DROPBOX', 'HTTP', 'FTPS')")
        return value

    @field_validator('if_file_exist')
    def if_file_exist_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Overwride', 'Overwrite', 'Append']):
            raise ValueError("must be one of enum values ('Overwride', 'Overwrite', 'Append')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    # JSON field name that stores the object type
    __discriminator_property_name: ClassVar[str] = 'discriminator'

    # discriminator mappings
    __discriminator_value_class_map: ClassVar[Dict[str, str]] = {
        'ExportFeedBucket': 'ExportFeedBucket','ExportFeedDropbox': 'ExportFeedDropbox','ExportFeedFTP': 'ExportFeedFTP','ExportFeedFTPS': 'ExportFeedFTPS','ExportFeedHTTP': 'ExportFeedHTTP','ExportFeedSFTP': 'ExportFeedSFTP'
    }

    @classmethod
    def get_discriminator_value(cls, obj: Dict[str, Any]) -> Optional[str]:
        """Returns the discriminator value (object type) of the data"""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Union[ExportFeedBucket, ExportFeedDropbox, ExportFeedFTP, ExportFeedFTPS, ExportFeedHTTP, ExportFeedSFTP]]:
        """Create an instance of ExportGenericFeed from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "feed_type",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Optional[Union[ExportFeedBucket, ExportFeedDropbox, ExportFeedFTP, ExportFeedFTPS, ExportFeedHTTP, ExportFeedSFTP]]:
        """Create an instance of ExportGenericFeed from a dict"""
        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type ==  'ExportFeedBucket':
            return import_module("linnworks_api.generated.importexport.models.export_feed_bucket").ExportFeedBucket.from_dict(obj)
        if object_type ==  'ExportFeedDropbox':
            return import_module("linnworks_api.generated.importexport.models.export_feed_dropbox").ExportFeedDropbox.from_dict(obj)
        if object_type ==  'ExportFeedFTP':
            return import_module("linnworks_api.generated.importexport.models.export_feed_ftp").ExportFeedFTP.from_dict(obj)
        if object_type ==  'ExportFeedFTPS':
            return import_module("linnworks_api.generated.importexport.models.export_feed_ftps").ExportFeedFTPS.from_dict(obj)
        if object_type ==  'ExportFeedHTTP':
            return import_module("linnworks_api.generated.importexport.models.export_feed_http").ExportFeedHTTP.from_dict(obj)
        if object_type ==  'ExportFeedSFTP':
            return import_module("linnworks_api.generated.importexport.models.export_feed_sftp").ExportFeedSFTP.from_dict(obj)

        raise ValueError("ExportGenericFeed failed to lookup discriminator value from " +
                            json.dumps(obj) + ". Discriminator property name: " + cls.__discriminator_property_name +
                            ", mapping: " + json.dumps(cls.__discriminator_value_class_map))


