# coding: utf-8

"""
    Import and Export API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: importexport
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ScheduleConfiguration(BaseModel):
    """
    ScheduleConfiguration
    """ # noqa: E501
    repetition_type: Optional[StrictStr] = Field(default=None, alias="RepetitionType")
    one_time_date: Optional[datetime] = Field(default=None, alias="OneTimeDate")
    daily_frequency: Optional[StrictStr] = Field(default=None, alias="DailyFrequency")
    occurs_frequency_starting_date: Optional[datetime] = Field(default=None, alias="OccursFrequencyStartingDate")
    occurs_frequency_every_x: Optional[StrictInt] = Field(default=None, alias="OccursFrequencyEveryX")
    weekly_days: Optional[StrictStr] = Field(default=None, alias="WeeklyDays")
    occurs_frequency: Optional[StrictStr] = Field(default=None, alias="OccursFrequency")
    occurs_once_at_time: Optional[StrictStr] = Field(default=None, alias="OccursOnceAtTime")
    occurs_every_hours: Optional[StrictInt] = Field(default=None, alias="OccursEveryHours")
    starting_time: Optional[StrictStr] = Field(default=None, alias="StartingTime")
    ending_time: Optional[StrictStr] = Field(default=None, alias="EndingTime")
    enabled: Optional[StrictBool] = Field(default=None, alias="Enabled")
    __properties: ClassVar[List[str]] = ["RepetitionType", "OneTimeDate", "DailyFrequency", "OccursFrequencyStartingDate", "OccursFrequencyEveryX", "WeeklyDays", "OccursFrequency", "OccursOnceAtTime", "OccursEveryHours", "StartingTime", "EndingTime", "Enabled"]

    @field_validator('repetition_type')
    def repetition_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['OneTime', 'Recurrent']):
            raise ValueError("must be one of enum values ('OneTime', 'Recurrent')")
        return value

    @field_validator('daily_frequency')
    def daily_frequency_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Daily', 'Weekly']):
            raise ValueError("must be one of enum values ('Daily', 'Weekly')")
        return value

    @field_validator('occurs_frequency')
    def occurs_frequency_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['OneTime', 'Recurrent']):
            raise ValueError("must be one of enum values ('OneTime', 'Recurrent')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ScheduleConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ScheduleConfiguration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "RepetitionType": obj.get("RepetitionType"),
            "OneTimeDate": obj.get("OneTimeDate"),
            "DailyFrequency": obj.get("DailyFrequency"),
            "OccursFrequencyStartingDate": obj.get("OccursFrequencyStartingDate"),
            "OccursFrequencyEveryX": obj.get("OccursFrequencyEveryX"),
            "WeeklyDays": obj.get("WeeklyDays"),
            "OccursFrequency": obj.get("OccursFrequency"),
            "OccursOnceAtTime": obj.get("OccursOnceAtTime"),
            "OccursEveryHours": obj.get("OccursEveryHours"),
            "StartingTime": obj.get("StartingTime"),
            "EndingTime": obj.get("EndingTime"),
            "Enabled": obj.get("Enabled")
        })
        return _obj


