# coding: utf-8

"""
    Inventory API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: inventory
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class AdjustmentOptions(BaseModel):
    """
    AdjustmentOptions
    """ # noqa: E501
    title: Optional[StrictBool] = Field(default=None, description="Product title", alias="Title")
    price: Optional[StrictBool] = Field(default=None, description="Product price", alias="Price")
    description: Optional[StrictBool] = Field(default=None, description="Product description", alias="Description")
    add_extended_properties: Optional[StrictBool] = Field(default=None, description="If product extended properties needs to be added", alias="AddExtendedProperties")
    revise_extended_properties: Optional[StrictBool] = Field(default=None, description="Revise product extended properties", alias="ReviseExtendedProperties")
    update_images: Optional[StrictBool] = Field(default=None, description="Update product images", alias="UpdateImages")
    variation_attributes: Optional[StrictBool] = Field(default=None, description="Product variation attributes", alias="VariationAttributes")
    reload_all_images: Optional[StrictBool] = Field(default=None, description="Reload all images for the template", alias="ReloadAllImages")
    remove_old_attributes: Optional[StrictBool] = Field(default=None, description="Removes old attributes", alias="RemoveOldAttributes")
    __properties: ClassVar[List[str]] = ["Title", "Price", "Description", "AddExtendedProperties", "ReviseExtendedProperties", "UpdateImages", "VariationAttributes", "ReloadAllImages", "RemoveOldAttributes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdjustmentOptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdjustmentOptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Title": obj.get("Title"),
            "Price": obj.get("Price"),
            "Description": obj.get("Description"),
            "AddExtendedProperties": obj.get("AddExtendedProperties"),
            "ReviseExtendedProperties": obj.get("ReviseExtendedProperties"),
            "UpdateImages": obj.get("UpdateImages"),
            "VariationAttributes": obj.get("VariationAttributes"),
            "ReloadAllImages": obj.get("ReloadAllImages"),
            "RemoveOldAttributes": obj.get("RemoveOldAttributes")
        })
        return _obj


