# coding: utf-8

"""
    Inventory API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: inventory
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.inventory.models.api_result_response_guid import APIResultResponseGuid
from typing import Optional, Set
from typing_extensions import Self

class BatchedAPIResponseGuid(BaseModel):
    """
    BatchedAPIResponseGuid
    """ # noqa: E501
    results: Optional[List[APIResultResponseGuid]] = Field(default=None, alias="Results")
    total_results: Optional[StrictInt] = Field(default=None, alias="TotalResults")
    result_status: Optional[StrictStr] = Field(default=None, alias="ResultStatus")
    __properties: ClassVar[List[str]] = ["Results", "TotalResults", "ResultStatus"]

    @field_validator('result_status')
    def result_status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['NOTSET', 'SUCCESSFUL', 'PARTIALLY_SUCCESSFUL', 'FAILED']):
            raise ValueError("must be one of enum values ('NOTSET', 'SUCCESSFUL', 'PARTIALLY_SUCCESSFUL', 'FAILED')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BatchedAPIResponseGuid from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "total_results",
            "result_status",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in results (list)
        _items = []
        if self.results:
            for _item_results in self.results:
                if _item_results:
                    _items.append(_item_results.to_dict())
            _dict['Results'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BatchedAPIResponseGuid from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Results": [APIResultResponseGuid.from_dict(_item) for _item in obj["Results"]] if obj.get("Results") is not None else None,
            "TotalResults": obj.get("TotalResults"),
            "ResultStatus": obj.get("ResultStatus")
        })
        return _obj


