# coding: utf-8

"""
    Inventory API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: inventory
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class Column(BaseModel):
    """
    Column
    """ # noqa: E501
    column_name: Optional[StrictStr] = Field(default=None, alias="ColumnName")
    display_name: Optional[StrictStr] = Field(default=None, alias="DisplayName")
    export_name: Optional[StrictStr] = Field(default=None, alias="ExportName")
    group: Optional[StrictStr] = Field(default=None, alias="Group")
    var_field: Optional[StrictStr] = Field(default=None, alias="Field")
    sort_direction: Optional[StrictStr] = Field(default=None, alias="SortDirection")
    width: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Width")
    is_editable: Optional[StrictBool] = Field(default=None, alias="IsEditable")
    __properties: ClassVar[List[str]] = ["ColumnName", "DisplayName", "ExportName", "Group", "Field", "SortDirection", "Width", "IsEditable"]

    @field_validator('column_name')
    def column_name_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['SKU', 'Title', 'VariationGroupName', 'RetailPrice', 'PurchasePrice', 'Tracked', 'Barcode', 'Available', 'MinimumLevel', 'InOrder', 'StockLevel', 'StockValue', 'Due', 'BinRack', 'Category', 'Image', 'Weight', 'DimHeight', 'DimWidth', 'DimDepth', 'CreatedDate', 'ModifiedDate', 'SerialNumberScanRequired', 'BatchNumberScanRequired', 'BatchType', 'JIT', 'ReorderAmount', 'ReorderDate', 'AverageConsumption', 'DefaultSupplier']):
            raise ValueError("must be one of enum values ('SKU', 'Title', 'VariationGroupName', 'RetailPrice', 'PurchasePrice', 'Tracked', 'Barcode', 'Available', 'MinimumLevel', 'InOrder', 'StockLevel', 'StockValue', 'Due', 'BinRack', 'Category', 'Image', 'Weight', 'DimHeight', 'DimWidth', 'DimDepth', 'CreatedDate', 'ModifiedDate', 'SerialNumberScanRequired', 'BatchNumberScanRequired', 'BatchType', 'JIT', 'ReorderAmount', 'ReorderDate', 'AverageConsumption', 'DefaultSupplier')")
        return value

    @field_validator('group')
    def group_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['General', 'Stock', 'Location']):
            raise ValueError("must be one of enum values ('General', 'Stock', 'Location')")
        return value

    @field_validator('var_field')
    def var_field_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Int', 'Double', 'String', 'Boolean', 'Select', 'Date', 'Datetime2']):
            raise ValueError("must be one of enum values ('Int', 'Double', 'String', 'Boolean', 'Select', 'Date', 'Datetime2')")
        return value

    @field_validator('sort_direction')
    def sort_direction_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['None', 'Descending', 'Ascending']):
            raise ValueError("must be one of enum values ('None', 'Descending', 'Ascending')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Column from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "display_name",
            "export_name",
            "group",
            "var_field",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Column from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ColumnName": obj.get("ColumnName"),
            "DisplayName": obj.get("DisplayName"),
            "ExportName": obj.get("ExportName"),
            "Group": obj.get("Group"),
            "Field": obj.get("Field"),
            "SortDirection": obj.get("SortDirection"),
            "Width": obj.get("Width"),
            "IsEditable": obj.get("IsEditable")
        })
        return _obj


