# coding: utf-8

"""
    Inventory API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: inventory
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.inventory.models.config_item_list_item import ConfigItemListItem
from typing import Optional, Set
from typing_extensions import Self

class ConfigItemExternal(BaseModel):
    """
    ConfigItemExternal
    """ # noqa: E501
    list_values: Optional[List[ConfigItemListItem]] = Field(default=None, alias="ListValues")
    value_type: Optional[StrictStr] = Field(default=None, alias="ValueType")
    config_item_id: Optional[StrictStr] = Field(default=None, alias="ConfigItemId")
    name: Optional[StrictStr] = Field(default=None, alias="Name")
    description: Optional[StrictStr] = Field(default=None, alias="Description")
    group_name: Optional[StrictStr] = Field(default=None, alias="GroupName")
    sort_order: Optional[StrictInt] = Field(default=None, alias="SortOrder")
    selected_value: Optional[StrictStr] = Field(default=None, alias="SelectedValue")
    reg_ex_validation: Optional[StrictStr] = Field(default=None, alias="RegExValidation")
    reg_ex_error: Optional[StrictStr] = Field(default=None, alias="RegExError")
    must_be_specified: Optional[StrictBool] = Field(default=None, alias="MustBeSpecified")
    read_only: Optional[StrictBool] = Field(default=None, alias="ReadOnly")
    hides_header_attribute: Optional[StrictBool] = Field(default=None, alias="HidesHeaderAttribute")
    __properties: ClassVar[List[str]] = ["ListValues", "ValueType", "ConfigItemId", "Name", "Description", "GroupName", "SortOrder", "SelectedValue", "RegExValidation", "RegExError", "MustBeSpecified", "ReadOnly", "HidesHeaderAttribute"]

    @field_validator('value_type')
    def value_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['STRING', 'INT', 'DOUBLE', 'BOOLEAN', 'PASSWORD', 'LIST', 'URL', 'BUTTON']):
            raise ValueError("must be one of enum values ('STRING', 'INT', 'DOUBLE', 'BOOLEAN', 'PASSWORD', 'LIST', 'URL', 'BUTTON')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ConfigItemExternal from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in list_values (list)
        _items = []
        if self.list_values:
            for _item_list_values in self.list_values:
                if _item_list_values:
                    _items.append(_item_list_values.to_dict())
            _dict['ListValues'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ConfigItemExternal from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ListValues": [ConfigItemListItem.from_dict(_item) for _item in obj["ListValues"]] if obj.get("ListValues") is not None else None,
            "ValueType": obj.get("ValueType"),
            "ConfigItemId": obj.get("ConfigItemId"),
            "Name": obj.get("Name"),
            "Description": obj.get("Description"),
            "GroupName": obj.get("GroupName"),
            "SortOrder": obj.get("SortOrder"),
            "SelectedValue": obj.get("SelectedValue"),
            "RegExValidation": obj.get("RegExValidation"),
            "RegExError": obj.get("RegExError"),
            "MustBeSpecified": obj.get("MustBeSpecified"),
            "ReadOnly": obj.get("ReadOnly"),
            "HidesHeaderAttribute": obj.get("HidesHeaderAttribute")
        })
        return _obj


