# coding: utf-8

"""
    Inventory API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: inventory
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from linnworks_api.generated.inventory.models.country_region import CountryRegion
from typing import Optional, Set
from typing_extensions import Self

class Country(BaseModel):
    """
    Country
    """ # noqa: E501
    country_id: Optional[StrictStr] = Field(default=None, alias="CountryId")
    country_name: Optional[StrictStr] = Field(default=None, alias="CountryName")
    country_code: Optional[StrictStr] = Field(default=None, alias="CountryCode")
    continent: Optional[StrictStr] = Field(default=None, alias="Continent")
    currency: Optional[StrictStr] = Field(default=None, alias="Currency")
    customs_required: Optional[StrictBool] = Field(default=None, alias="CustomsRequired")
    tax_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="TaxRate")
    address_format: Optional[StrictStr] = Field(default=None, alias="AddressFormat")
    regions: Optional[List[CountryRegion]] = Field(default=None, alias="Regions")
    regions_count: Optional[StrictInt] = Field(default=None, alias="RegionsCount")
    __properties: ClassVar[List[str]] = ["CountryId", "CountryName", "CountryCode", "Continent", "Currency", "CustomsRequired", "TaxRate", "AddressFormat", "Regions", "RegionsCount"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Country from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in regions (list)
        _items = []
        if self.regions:
            for _item_regions in self.regions:
                if _item_regions:
                    _items.append(_item_regions.to_dict())
            _dict['Regions'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Country from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "CountryId": obj.get("CountryId"),
            "CountryName": obj.get("CountryName"),
            "CountryCode": obj.get("CountryCode"),
            "Continent": obj.get("Continent"),
            "Currency": obj.get("Currency"),
            "CustomsRequired": obj.get("CustomsRequired"),
            "TaxRate": obj.get("TaxRate"),
            "AddressFormat": obj.get("AddressFormat"),
            "Regions": [CountryRegion.from_dict(_item) for _item in obj["Regions"]] if obj.get("Regions") is not None else None,
            "RegionsCount": obj.get("RegionsCount")
        })
        return _obj


