# coding: utf-8

"""
    Inventory API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: inventory
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.inventory.models.custom_attribute_typed_argument import CustomAttributeTypedArgument
from typing import Optional, Set
from typing_extensions import Self

class CustomAttributeData(BaseModel):
    """
    CustomAttributeData
    """ # noqa: E501
    attribute_type: Optional[StrictStr] = Field(default=None, alias="AttributeType")
    constructor: Optional[ConstructorInfo] = Field(default=None, alias="Constructor")
    constructor_arguments: Optional[List[CustomAttributeTypedArgument]] = Field(default=None, alias="ConstructorArguments")
    named_arguments: Optional[List[CustomAttributeNamedArgument]] = Field(default=None, alias="NamedArguments")
    __properties: ClassVar[List[str]] = ["AttributeType", "Constructor", "ConstructorArguments", "NamedArguments"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CustomAttributeData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "attribute_type",
            "constructor_arguments",
            "named_arguments",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of constructor
        if self.constructor:
            _dict['Constructor'] = self.constructor.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in constructor_arguments (list)
        _items = []
        if self.constructor_arguments:
            for _item_constructor_arguments in self.constructor_arguments:
                if _item_constructor_arguments:
                    _items.append(_item_constructor_arguments.to_dict())
            _dict['ConstructorArguments'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in named_arguments (list)
        _items = []
        if self.named_arguments:
            for _item_named_arguments in self.named_arguments:
                if _item_named_arguments:
                    _items.append(_item_named_arguments.to_dict())
            _dict['NamedArguments'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CustomAttributeData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "AttributeType": obj.get("AttributeType"),
            "Constructor": ConstructorInfo.from_dict(obj["Constructor"]) if obj.get("Constructor") is not None else None,
            "ConstructorArguments": [CustomAttributeTypedArgument.from_dict(_item) for _item in obj["ConstructorArguments"]] if obj.get("ConstructorArguments") is not None else None,
            "NamedArguments": [CustomAttributeNamedArgument.from_dict(_item) for _item in obj["NamedArguments"]] if obj.get("NamedArguments") is not None else None
        })
        return _obj

from linnworks_api.generated.inventory.models.constructor_info import ConstructorInfo
from linnworks_api.generated.inventory.models.custom_attribute_named_argument import CustomAttributeNamedArgument
# TODO: Rewrite to not use raise_errors
CustomAttributeData.model_rebuild(raise_errors=False)

