# coding: utf-8

"""
    Inventory API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: inventory
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class Filter(BaseModel):
    """
    Filter
    """ # noqa: E501
    filter_name: Optional[StrictStr] = Field(default=None, alias="FilterName")
    display_name: Optional[StrictStr] = Field(default=None, alias="DisplayName")
    filter_name_exact: Optional[List[StrictStr]] = Field(default=None, alias="FilterNameExact")
    var_field: Optional[StrictStr] = Field(default=None, alias="Field")
    condition: Optional[StrictStr] = Field(default=None, alias="Condition")
    condition_display_name: Optional[StrictStr] = Field(default=None, alias="ConditionDisplayName")
    value: Optional[StrictStr] = Field(default=None, alias="Value")
    __properties: ClassVar[List[str]] = ["FilterName", "DisplayName", "FilterNameExact", "Field", "Condition", "ConditionDisplayName", "Value"]

    @field_validator('filter_name')
    def filter_name_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['General', 'SKU', 'Title', 'RetailPrice', 'PurchasePrice', 'Tracked', 'Barcode', 'VariationGroupName', 'Available', 'MinimumLevel', 'InOrder', 'StockLevel', 'StockValue', 'Due', 'BinRack', 'Category', 'ChannelSKU', 'SupplierCode', 'eBayId', 'AmazonASIN', 'Image', 'ExtendedProperty', 'ExtendedPropertyName', 'Channel', 'CreatedDate', 'ModifiedDate', 'SerialNumberScanRequired', 'BatchNumberScanRequired', 'BatchType', 'BatchNumber', 'Weight', 'DimHeight', 'DimWidth', 'DimDepth', 'JIT', 'ReorderAmount', 'ReorderDate', 'AverageConsumption', 'DefaultSupplier', 'GeneralWithSeparatingWords']):
            raise ValueError("must be one of enum values ('General', 'SKU', 'Title', 'RetailPrice', 'PurchasePrice', 'Tracked', 'Barcode', 'VariationGroupName', 'Available', 'MinimumLevel', 'InOrder', 'StockLevel', 'StockValue', 'Due', 'BinRack', 'Category', 'ChannelSKU', 'SupplierCode', 'eBayId', 'AmazonASIN', 'Image', 'ExtendedProperty', 'ExtendedPropertyName', 'Channel', 'CreatedDate', 'ModifiedDate', 'SerialNumberScanRequired', 'BatchNumberScanRequired', 'BatchType', 'BatchNumber', 'Weight', 'DimHeight', 'DimWidth', 'DimDepth', 'JIT', 'ReorderAmount', 'ReorderDate', 'AverageConsumption', 'DefaultSupplier', 'GeneralWithSeparatingWords')")
        return value

    @field_validator('var_field')
    def var_field_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Int', 'Double', 'String', 'Boolean', 'Select', 'Date', 'Channel', 'Other', 'Datetime2', 'Calculated']):
            raise ValueError("must be one of enum values ('Int', 'Double', 'String', 'Boolean', 'Select', 'Date', 'Channel', 'Other', 'Datetime2', 'Calculated')")
        return value

    @field_validator('condition')
    def condition_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Equals', 'Contains', 'Less', 'Greater', 'NotEquals', 'NotContains', 'Exists', 'Listed', 'NotListed', 'HasError', 'OnlyErrors', 'NoErrors', 'HasWarning', 'LastDays', 'OlderThan', 'Next', 'Is', 'InTheFeed', 'NotInTheFeed', 'Creating', 'Updating', 'Deleting']):
            raise ValueError("must be one of enum values ('Equals', 'Contains', 'Less', 'Greater', 'NotEquals', 'NotContains', 'Exists', 'Listed', 'NotListed', 'HasError', 'OnlyErrors', 'NoErrors', 'HasWarning', 'LastDays', 'OlderThan', 'Next', 'Is', 'InTheFeed', 'NotInTheFeed', 'Creating', 'Updating', 'Deleting')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Filter from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "display_name",
            "var_field",
            "condition_display_name",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Filter from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "FilterName": obj.get("FilterName"),
            "DisplayName": obj.get("DisplayName"),
            "FilterNameExact": obj.get("FilterNameExact"),
            "Field": obj.get("Field"),
            "Condition": obj.get("Condition"),
            "ConditionDisplayName": obj.get("ConditionDisplayName"),
            "Value": obj.get("Value")
        })
        return _obj


