# coding: utf-8

"""
    Inventory API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: inventory
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class GetImagesInBulkResponseImage(BaseModel):
    """
    Image response item.
    """ # noqa: E501
    sku: Optional[StrictStr] = Field(default=None, description="SKU", alias="SKU")
    is_main: Optional[StrictBool] = Field(default=None, description="Is main image", alias="IsMain")
    pk_row_id: Optional[StrictStr] = Field(default=None, description="Image row id", alias="pkRowId")
    checksum_value: Optional[StrictStr] = Field(default=None, description="Checksum", alias="ChecksumValue")
    raw_checksum: Optional[StrictStr] = Field(default=None, description="Raw file checksum (original and unaltered)", alias="RawChecksum")
    sort_order: Optional[StrictInt] = Field(default=None, description="Sort order", alias="SortOrder")
    stock_item_id: Optional[StrictStr] = Field(default=None, description="Stockitem id", alias="StockItemId")
    full_source: Optional[StrictStr] = Field(default=None, description="Full image path", alias="FullSource")
    full_source_thumbnail: Optional[StrictStr] = Field(default=None, description="Thumbnail image path", alias="FullSourceThumbnail")
    __properties: ClassVar[List[str]] = ["SKU", "IsMain", "pkRowId", "ChecksumValue", "RawChecksum", "SortOrder", "StockItemId", "FullSource", "FullSourceThumbnail"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetImagesInBulkResponseImage from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetImagesInBulkResponseImage from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "SKU": obj.get("SKU"),
            "IsMain": obj.get("IsMain"),
            "pkRowId": obj.get("pkRowId"),
            "ChecksumValue": obj.get("ChecksumValue"),
            "RawChecksum": obj.get("RawChecksum"),
            "SortOrder": obj.get("SortOrder"),
            "StockItemId": obj.get("StockItemId"),
            "FullSource": obj.get("FullSource"),
            "FullSourceThumbnail": obj.get("FullSourceThumbnail")
        })
        return _obj


