# coding: utf-8

"""
    Inventory API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: inventory
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.inventory.models.channel_setting_audit import ChannelSettingAudit
from linnworks_api.generated.inventory.models.config_button import ConfigButton
from linnworks_api.generated.inventory.models.config_channel_location_binding import ConfigChannelLocationBinding
from linnworks_api.generated.inventory.models.config_item_boolean import ConfigItemBoolean
from linnworks_api.generated.inventory.models.config_item_date_time import ConfigItemDateTime
from linnworks_api.generated.inventory.models.config_item_double import ConfigItemDouble
from linnworks_api.generated.inventory.models.config_item_external import ConfigItemExternal
from linnworks_api.generated.inventory.models.config_item_int32 import ConfigItemInt32
from linnworks_api.generated.inventory.models.config_item_string import ConfigItemString
from linnworks_api.generated.inventory.models.config_payment_method_mapping import ConfigPaymentMethodMapping
from linnworks_api.generated.inventory.models.config_postal_service_mapping import ConfigPostalServiceMapping
from linnworks_api.generated.inventory.models.config_property_boolean import ConfigPropertyBoolean
from linnworks_api.generated.inventory.models.config_property_selection_list_select_string_value_option_guid import ConfigPropertySelectionListSelectStringValueOptionGuid
from linnworks_api.generated.inventory.models.config_property_selection_list_select_string_value_option_string import ConfigPropertySelectionListSelectStringValueOptionString
from linnworks_api.generated.inventory.models.config_property_string import ConfigPropertyString
from linnworks_api.generated.inventory.models.config_rule import ConfigRule
from linnworks_api.generated.inventory.models.config_stock_location_binding import ConfigStockLocationBinding
from typing import Optional, Set
from typing_extensions import Self

class HeaderConfig(BaseModel):
    """
    HeaderConfig
    """ # noqa: E501
    source_version: Optional[ConfigItemString] = Field(default=None, alias="SourceVersion")
    enabled: Optional[ConfigItemBoolean] = Field(default=None, alias="Enabled")
    channel_tag: Optional[ConfigItemString] = Field(default=None, alias="ChannelTag")
    channel_location_binding: Optional[ConfigChannelLocationBinding] = Field(default=None, alias="ChannelLocationBinding")
    is_multi_location: Optional[ConfigItemBoolean] = Field(default=None, alias="IsMultiLocation")
    auto_populated_locations: Optional[ConfigItemBoolean] = Field(default=None, alias="AutoPopulatedLocations")
    can_modify_locations_on_channel: Optional[ConfigItemBoolean] = Field(default=None, alias="CanModifyLocationsOnChannel")
    bopis_supported: Optional[ConfigItemBoolean] = Field(default=None, alias="BopisSupported")
    process_pos_orders: Optional[ConfigPropertyBoolean] = Field(default=None, alias="ProcessPosOrders")
    despatch_notes: Optional[ConfigItemBoolean] = Field(default=None, alias="DespatchNotes")
    cancellation_notes: Optional[ConfigItemBoolean] = Field(default=None, alias="CancellationNotes")
    auto_respond_cancellation_requests: Optional[ConfigItemBoolean] = Field(default=None, alias="AutoRespondCancellationRequests")
    cancellation_response_type: Optional[ConfigPropertySelectionListSelectStringValueOptionString] = Field(default=None, alias="CancellationResponseType")
    refund_notes: Optional[ConfigItemBoolean] = Field(default=None, alias="RefundNotes")
    download_refunds: Optional[ConfigItemBoolean] = Field(default=None, alias="DownloadRefunds")
    return_notes: Optional[ConfigItemBoolean] = Field(default=None, alias="ReturnNotes")
    download_returns: Optional[ConfigItemBoolean] = Field(default=None, alias="DownloadReturns")
    order_save_location: Optional[ConfigPropertySelectionListSelectStringValueOptionGuid] = Field(default=None, alias="OrderSaveLocation")
    order_sync_date: Optional[ConfigItemDateTime] = Field(default=None, alias="OrderSyncDate")
    order_cancellation_check_date: Optional[ConfigItemDateTime] = Field(default=None, alias="OrderCancellationCheckDate")
    config_discount: Optional[ConfigPropertySelectionListSelectStringValueOptionString] = Field(default=None, alias="ConfigDiscount")
    order_download_error_count: Optional[ConfigItemInt32] = Field(default=None, alias="OrderDownloadErrorCount")
    order_download_global_error_count: Optional[ConfigItemInt32] = Field(default=None, alias="OrderDownloadGlobalErrorCount")
    order_despatch_error_count: Optional[ConfigItemInt32] = Field(default=None, alias="OrderDespatchErrorCount")
    order_despatch_global_error_count: Optional[ConfigItemInt32] = Field(default=None, alias="OrderDespatchGlobalErrorCount")
    order_cancellation_check_error_count: Optional[ConfigItemInt32] = Field(default=None, alias="OrderCancellationCheckErrorCount")
    order_cancellation_check_global_error_count: Optional[ConfigItemInt32] = Field(default=None, alias="OrderCancellationCheckGlobalErrorCount")
    rma_download_error_count: Optional[ConfigItemInt32] = Field(default=None, alias="RmaDownloadErrorCount")
    rma_download_global_error_count: Optional[ConfigItemInt32] = Field(default=None, alias="RmaDownloadGlobalErrorCount")
    hides_header_attributes: Optional[ConfigPropertyBoolean] = Field(default=None, alias="HidesHeaderAttributes")
    inventory_sync: Optional[ConfigItemBoolean] = Field(default=None, alias="InventorySync")
    stock_location_binding: Optional[ConfigStockLocationBinding] = Field(default=None, alias="StockLocationBinding")
    max_listed: Optional[ConfigItemInt32] = Field(default=None, alias="MaxListed")
    stock_percentage: Optional[ConfigItemDouble] = Field(default=None, alias="StockPercentage")
    end_when: Optional[ConfigItemInt32] = Field(default=None, alias="EndWhen")
    inv_sync_error_count: Optional[ConfigItemInt32] = Field(default=None, alias="InvSyncErrorCount")
    extract_inventory: Optional[ConfigPropertyBoolean] = Field(default=None, alias="ExtractInventory")
    extract_inventory_variation_mapping_property_name: Optional[ConfigPropertyString] = Field(default=None, alias="ExtractInventoryVariationMappingPropertyName")
    price_change: Optional[ConfigItemBoolean] = Field(default=None, alias="PriceChange")
    price_change_error_count: Optional[ConfigItemInt32] = Field(default=None, alias="PriceChangeErrorCount")
    is_inventory_sync_trigger_enabled: Optional[ConfigPropertyBoolean] = Field(default=None, alias="IsInventorySyncTriggerEnabled")
    is_listing_scan_running: Optional[ConfigItemBoolean] = Field(default=None, alias="IsListingScanRunning")
    listing_scan_start_update_date: Optional[ConfigItemDateTime] = Field(default=None, alias="ListingScanStartUpdateDate")
    last_listing_update_date: Optional[ConfigItemDateTime] = Field(default=None, alias="LastListingUpdateDate")
    estimated_inventory_scan_complete: Optional[ConfigItemDateTime] = Field(default=None, alias="EstimatedInventoryScanComplete")
    is_header_only: Optional[StrictBool] = Field(default=None, alias="IsHeaderOnly")
    is_hidden: Optional[StrictBool] = Field(default=None, alias="IsHidden")
    display_name: Optional[StrictStr] = Field(default=None, alias="DisplayName")
    dynamic_properties: Optional[List[ConfigItemExternal]] = Field(default=None, alias="DynamicProperties")
    config_discount_typed: Optional[StrictStr] = Field(default=None, alias="ConfigDiscountTyped")
    postal_service_mapping: Optional[ConfigPostalServiceMapping] = Field(default=None, alias="PostalServiceMapping")
    payment_method_mapping: Optional[ConfigPaymentMethodMapping] = Field(default=None, alias="PaymentMethodMapping")
    pk_channel_id: Optional[StrictInt] = Field(default=None, alias="PkChannelId")
    source: Optional[StrictStr] = Field(default=None, alias="Source")
    source_type: Optional[StrictStr] = Field(default=None, alias="SourceType")
    fulfillment_service_enabled: Optional[StrictBool] = Field(default=None, alias="FulfillmentServiceEnabled")
    fulfillment_location: Optional[StrictStr] = Field(default=None, alias="FulfillmentLocation")
    concurrency_key: Optional[StrictStr] = Field(default=None, alias="ConcurrencyKey")
    rules: Optional[List[ConfigRule]] = Field(default=None, alias="Rules")
    buttons: Optional[List[ConfigButton]] = Field(default=None, alias="Buttons")
    sub_source: Optional[StrictStr] = Field(default=None, alias="SubSource")
    header_audit_values: Optional[List[ChannelSettingAudit]] = Field(default=None, alias="HeaderAuditValues")
    __properties: ClassVar[List[str]] = ["SourceVersion", "Enabled", "ChannelTag", "ChannelLocationBinding", "IsMultiLocation", "AutoPopulatedLocations", "CanModifyLocationsOnChannel", "BopisSupported", "ProcessPosOrders", "DespatchNotes", "CancellationNotes", "AutoRespondCancellationRequests", "CancellationResponseType", "RefundNotes", "DownloadRefunds", "ReturnNotes", "DownloadReturns", "OrderSaveLocation", "OrderSyncDate", "OrderCancellationCheckDate", "ConfigDiscount", "OrderDownloadErrorCount", "OrderDownloadGlobalErrorCount", "OrderDespatchErrorCount", "OrderDespatchGlobalErrorCount", "OrderCancellationCheckErrorCount", "OrderCancellationCheckGlobalErrorCount", "RmaDownloadErrorCount", "RmaDownloadGlobalErrorCount", "HidesHeaderAttributes", "InventorySync", "StockLocationBinding", "MaxListed", "StockPercentage", "EndWhen", "InvSyncErrorCount", "ExtractInventory", "ExtractInventoryVariationMappingPropertyName", "PriceChange", "PriceChangeErrorCount", "IsInventorySyncTriggerEnabled", "IsListingScanRunning", "ListingScanStartUpdateDate", "LastListingUpdateDate", "EstimatedInventoryScanComplete", "IsHeaderOnly", "IsHidden", "DisplayName", "DynamicProperties", "ConfigDiscountTyped", "PostalServiceMapping", "PaymentMethodMapping", "PkChannelId", "Source", "SourceType", "FulfillmentServiceEnabled", "FulfillmentLocation", "ConcurrencyKey", "Rules", "Buttons", "SubSource", "HeaderAuditValues"]

    @field_validator('config_discount_typed')
    def config_discount_typed_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['AllEvenly', 'ItemsThenPostage', 'PostageThenItems']):
            raise ValueError("must be one of enum values ('AllEvenly', 'ItemsThenPostage', 'PostageThenItems')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HeaderConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "is_header_only",
            "display_name",
            "source",
            "source_type",
            "fulfillment_service_enabled",
            "fulfillment_location",
            "concurrency_key",
            "rules",
            "buttons",
            "header_audit_values",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of source_version
        if self.source_version:
            _dict['SourceVersion'] = self.source_version.to_dict()
        # override the default output from pydantic by calling `to_dict()` of enabled
        if self.enabled:
            _dict['Enabled'] = self.enabled.to_dict()
        # override the default output from pydantic by calling `to_dict()` of channel_tag
        if self.channel_tag:
            _dict['ChannelTag'] = self.channel_tag.to_dict()
        # override the default output from pydantic by calling `to_dict()` of channel_location_binding
        if self.channel_location_binding:
            _dict['ChannelLocationBinding'] = self.channel_location_binding.to_dict()
        # override the default output from pydantic by calling `to_dict()` of is_multi_location
        if self.is_multi_location:
            _dict['IsMultiLocation'] = self.is_multi_location.to_dict()
        # override the default output from pydantic by calling `to_dict()` of auto_populated_locations
        if self.auto_populated_locations:
            _dict['AutoPopulatedLocations'] = self.auto_populated_locations.to_dict()
        # override the default output from pydantic by calling `to_dict()` of can_modify_locations_on_channel
        if self.can_modify_locations_on_channel:
            _dict['CanModifyLocationsOnChannel'] = self.can_modify_locations_on_channel.to_dict()
        # override the default output from pydantic by calling `to_dict()` of bopis_supported
        if self.bopis_supported:
            _dict['BopisSupported'] = self.bopis_supported.to_dict()
        # override the default output from pydantic by calling `to_dict()` of process_pos_orders
        if self.process_pos_orders:
            _dict['ProcessPosOrders'] = self.process_pos_orders.to_dict()
        # override the default output from pydantic by calling `to_dict()` of despatch_notes
        if self.despatch_notes:
            _dict['DespatchNotes'] = self.despatch_notes.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cancellation_notes
        if self.cancellation_notes:
            _dict['CancellationNotes'] = self.cancellation_notes.to_dict()
        # override the default output from pydantic by calling `to_dict()` of auto_respond_cancellation_requests
        if self.auto_respond_cancellation_requests:
            _dict['AutoRespondCancellationRequests'] = self.auto_respond_cancellation_requests.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cancellation_response_type
        if self.cancellation_response_type:
            _dict['CancellationResponseType'] = self.cancellation_response_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of refund_notes
        if self.refund_notes:
            _dict['RefundNotes'] = self.refund_notes.to_dict()
        # override the default output from pydantic by calling `to_dict()` of download_refunds
        if self.download_refunds:
            _dict['DownloadRefunds'] = self.download_refunds.to_dict()
        # override the default output from pydantic by calling `to_dict()` of return_notes
        if self.return_notes:
            _dict['ReturnNotes'] = self.return_notes.to_dict()
        # override the default output from pydantic by calling `to_dict()` of download_returns
        if self.download_returns:
            _dict['DownloadReturns'] = self.download_returns.to_dict()
        # override the default output from pydantic by calling `to_dict()` of order_save_location
        if self.order_save_location:
            _dict['OrderSaveLocation'] = self.order_save_location.to_dict()
        # override the default output from pydantic by calling `to_dict()` of order_sync_date
        if self.order_sync_date:
            _dict['OrderSyncDate'] = self.order_sync_date.to_dict()
        # override the default output from pydantic by calling `to_dict()` of order_cancellation_check_date
        if self.order_cancellation_check_date:
            _dict['OrderCancellationCheckDate'] = self.order_cancellation_check_date.to_dict()
        # override the default output from pydantic by calling `to_dict()` of config_discount
        if self.config_discount:
            _dict['ConfigDiscount'] = self.config_discount.to_dict()
        # override the default output from pydantic by calling `to_dict()` of order_download_error_count
        if self.order_download_error_count:
            _dict['OrderDownloadErrorCount'] = self.order_download_error_count.to_dict()
        # override the default output from pydantic by calling `to_dict()` of order_download_global_error_count
        if self.order_download_global_error_count:
            _dict['OrderDownloadGlobalErrorCount'] = self.order_download_global_error_count.to_dict()
        # override the default output from pydantic by calling `to_dict()` of order_despatch_error_count
        if self.order_despatch_error_count:
            _dict['OrderDespatchErrorCount'] = self.order_despatch_error_count.to_dict()
        # override the default output from pydantic by calling `to_dict()` of order_despatch_global_error_count
        if self.order_despatch_global_error_count:
            _dict['OrderDespatchGlobalErrorCount'] = self.order_despatch_global_error_count.to_dict()
        # override the default output from pydantic by calling `to_dict()` of order_cancellation_check_error_count
        if self.order_cancellation_check_error_count:
            _dict['OrderCancellationCheckErrorCount'] = self.order_cancellation_check_error_count.to_dict()
        # override the default output from pydantic by calling `to_dict()` of order_cancellation_check_global_error_count
        if self.order_cancellation_check_global_error_count:
            _dict['OrderCancellationCheckGlobalErrorCount'] = self.order_cancellation_check_global_error_count.to_dict()
        # override the default output from pydantic by calling `to_dict()` of rma_download_error_count
        if self.rma_download_error_count:
            _dict['RmaDownloadErrorCount'] = self.rma_download_error_count.to_dict()
        # override the default output from pydantic by calling `to_dict()` of rma_download_global_error_count
        if self.rma_download_global_error_count:
            _dict['RmaDownloadGlobalErrorCount'] = self.rma_download_global_error_count.to_dict()
        # override the default output from pydantic by calling `to_dict()` of hides_header_attributes
        if self.hides_header_attributes:
            _dict['HidesHeaderAttributes'] = self.hides_header_attributes.to_dict()
        # override the default output from pydantic by calling `to_dict()` of inventory_sync
        if self.inventory_sync:
            _dict['InventorySync'] = self.inventory_sync.to_dict()
        # override the default output from pydantic by calling `to_dict()` of stock_location_binding
        if self.stock_location_binding:
            _dict['StockLocationBinding'] = self.stock_location_binding.to_dict()
        # override the default output from pydantic by calling `to_dict()` of max_listed
        if self.max_listed:
            _dict['MaxListed'] = self.max_listed.to_dict()
        # override the default output from pydantic by calling `to_dict()` of stock_percentage
        if self.stock_percentage:
            _dict['StockPercentage'] = self.stock_percentage.to_dict()
        # override the default output from pydantic by calling `to_dict()` of end_when
        if self.end_when:
            _dict['EndWhen'] = self.end_when.to_dict()
        # override the default output from pydantic by calling `to_dict()` of inv_sync_error_count
        if self.inv_sync_error_count:
            _dict['InvSyncErrorCount'] = self.inv_sync_error_count.to_dict()
        # override the default output from pydantic by calling `to_dict()` of extract_inventory
        if self.extract_inventory:
            _dict['ExtractInventory'] = self.extract_inventory.to_dict()
        # override the default output from pydantic by calling `to_dict()` of extract_inventory_variation_mapping_property_name
        if self.extract_inventory_variation_mapping_property_name:
            _dict['ExtractInventoryVariationMappingPropertyName'] = self.extract_inventory_variation_mapping_property_name.to_dict()
        # override the default output from pydantic by calling `to_dict()` of price_change
        if self.price_change:
            _dict['PriceChange'] = self.price_change.to_dict()
        # override the default output from pydantic by calling `to_dict()` of price_change_error_count
        if self.price_change_error_count:
            _dict['PriceChangeErrorCount'] = self.price_change_error_count.to_dict()
        # override the default output from pydantic by calling `to_dict()` of is_inventory_sync_trigger_enabled
        if self.is_inventory_sync_trigger_enabled:
            _dict['IsInventorySyncTriggerEnabled'] = self.is_inventory_sync_trigger_enabled.to_dict()
        # override the default output from pydantic by calling `to_dict()` of is_listing_scan_running
        if self.is_listing_scan_running:
            _dict['IsListingScanRunning'] = self.is_listing_scan_running.to_dict()
        # override the default output from pydantic by calling `to_dict()` of listing_scan_start_update_date
        if self.listing_scan_start_update_date:
            _dict['ListingScanStartUpdateDate'] = self.listing_scan_start_update_date.to_dict()
        # override the default output from pydantic by calling `to_dict()` of last_listing_update_date
        if self.last_listing_update_date:
            _dict['LastListingUpdateDate'] = self.last_listing_update_date.to_dict()
        # override the default output from pydantic by calling `to_dict()` of estimated_inventory_scan_complete
        if self.estimated_inventory_scan_complete:
            _dict['EstimatedInventoryScanComplete'] = self.estimated_inventory_scan_complete.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in dynamic_properties (list)
        _items = []
        if self.dynamic_properties:
            for _item_dynamic_properties in self.dynamic_properties:
                if _item_dynamic_properties:
                    _items.append(_item_dynamic_properties.to_dict())
            _dict['DynamicProperties'] = _items
        # override the default output from pydantic by calling `to_dict()` of postal_service_mapping
        if self.postal_service_mapping:
            _dict['PostalServiceMapping'] = self.postal_service_mapping.to_dict()
        # override the default output from pydantic by calling `to_dict()` of payment_method_mapping
        if self.payment_method_mapping:
            _dict['PaymentMethodMapping'] = self.payment_method_mapping.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in rules (list)
        _items = []
        if self.rules:
            for _item_rules in self.rules:
                if _item_rules:
                    _items.append(_item_rules.to_dict())
            _dict['Rules'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in buttons (list)
        _items = []
        if self.buttons:
            for _item_buttons in self.buttons:
                if _item_buttons:
                    _items.append(_item_buttons.to_dict())
            _dict['Buttons'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in header_audit_values (list)
        _items = []
        if self.header_audit_values:
            for _item_header_audit_values in self.header_audit_values:
                if _item_header_audit_values:
                    _items.append(_item_header_audit_values.to_dict())
            _dict['HeaderAuditValues'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HeaderConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "SourceVersion": ConfigItemString.from_dict(obj["SourceVersion"]) if obj.get("SourceVersion") is not None else None,
            "Enabled": ConfigItemBoolean.from_dict(obj["Enabled"]) if obj.get("Enabled") is not None else None,
            "ChannelTag": ConfigItemString.from_dict(obj["ChannelTag"]) if obj.get("ChannelTag") is not None else None,
            "ChannelLocationBinding": ConfigChannelLocationBinding.from_dict(obj["ChannelLocationBinding"]) if obj.get("ChannelLocationBinding") is not None else None,
            "IsMultiLocation": ConfigItemBoolean.from_dict(obj["IsMultiLocation"]) if obj.get("IsMultiLocation") is not None else None,
            "AutoPopulatedLocations": ConfigItemBoolean.from_dict(obj["AutoPopulatedLocations"]) if obj.get("AutoPopulatedLocations") is not None else None,
            "CanModifyLocationsOnChannel": ConfigItemBoolean.from_dict(obj["CanModifyLocationsOnChannel"]) if obj.get("CanModifyLocationsOnChannel") is not None else None,
            "BopisSupported": ConfigItemBoolean.from_dict(obj["BopisSupported"]) if obj.get("BopisSupported") is not None else None,
            "ProcessPosOrders": ConfigPropertyBoolean.from_dict(obj["ProcessPosOrders"]) if obj.get("ProcessPosOrders") is not None else None,
            "DespatchNotes": ConfigItemBoolean.from_dict(obj["DespatchNotes"]) if obj.get("DespatchNotes") is not None else None,
            "CancellationNotes": ConfigItemBoolean.from_dict(obj["CancellationNotes"]) if obj.get("CancellationNotes") is not None else None,
            "AutoRespondCancellationRequests": ConfigItemBoolean.from_dict(obj["AutoRespondCancellationRequests"]) if obj.get("AutoRespondCancellationRequests") is not None else None,
            "CancellationResponseType": ConfigPropertySelectionListSelectStringValueOptionString.from_dict(obj["CancellationResponseType"]) if obj.get("CancellationResponseType") is not None else None,
            "RefundNotes": ConfigItemBoolean.from_dict(obj["RefundNotes"]) if obj.get("RefundNotes") is not None else None,
            "DownloadRefunds": ConfigItemBoolean.from_dict(obj["DownloadRefunds"]) if obj.get("DownloadRefunds") is not None else None,
            "ReturnNotes": ConfigItemBoolean.from_dict(obj["ReturnNotes"]) if obj.get("ReturnNotes") is not None else None,
            "DownloadReturns": ConfigItemBoolean.from_dict(obj["DownloadReturns"]) if obj.get("DownloadReturns") is not None else None,
            "OrderSaveLocation": ConfigPropertySelectionListSelectStringValueOptionGuid.from_dict(obj["OrderSaveLocation"]) if obj.get("OrderSaveLocation") is not None else None,
            "OrderSyncDate": ConfigItemDateTime.from_dict(obj["OrderSyncDate"]) if obj.get("OrderSyncDate") is not None else None,
            "OrderCancellationCheckDate": ConfigItemDateTime.from_dict(obj["OrderCancellationCheckDate"]) if obj.get("OrderCancellationCheckDate") is not None else None,
            "ConfigDiscount": ConfigPropertySelectionListSelectStringValueOptionString.from_dict(obj["ConfigDiscount"]) if obj.get("ConfigDiscount") is not None else None,
            "OrderDownloadErrorCount": ConfigItemInt32.from_dict(obj["OrderDownloadErrorCount"]) if obj.get("OrderDownloadErrorCount") is not None else None,
            "OrderDownloadGlobalErrorCount": ConfigItemInt32.from_dict(obj["OrderDownloadGlobalErrorCount"]) if obj.get("OrderDownloadGlobalErrorCount") is not None else None,
            "OrderDespatchErrorCount": ConfigItemInt32.from_dict(obj["OrderDespatchErrorCount"]) if obj.get("OrderDespatchErrorCount") is not None else None,
            "OrderDespatchGlobalErrorCount": ConfigItemInt32.from_dict(obj["OrderDespatchGlobalErrorCount"]) if obj.get("OrderDespatchGlobalErrorCount") is not None else None,
            "OrderCancellationCheckErrorCount": ConfigItemInt32.from_dict(obj["OrderCancellationCheckErrorCount"]) if obj.get("OrderCancellationCheckErrorCount") is not None else None,
            "OrderCancellationCheckGlobalErrorCount": ConfigItemInt32.from_dict(obj["OrderCancellationCheckGlobalErrorCount"]) if obj.get("OrderCancellationCheckGlobalErrorCount") is not None else None,
            "RmaDownloadErrorCount": ConfigItemInt32.from_dict(obj["RmaDownloadErrorCount"]) if obj.get("RmaDownloadErrorCount") is not None else None,
            "RmaDownloadGlobalErrorCount": ConfigItemInt32.from_dict(obj["RmaDownloadGlobalErrorCount"]) if obj.get("RmaDownloadGlobalErrorCount") is not None else None,
            "HidesHeaderAttributes": ConfigPropertyBoolean.from_dict(obj["HidesHeaderAttributes"]) if obj.get("HidesHeaderAttributes") is not None else None,
            "InventorySync": ConfigItemBoolean.from_dict(obj["InventorySync"]) if obj.get("InventorySync") is not None else None,
            "StockLocationBinding": ConfigStockLocationBinding.from_dict(obj["StockLocationBinding"]) if obj.get("StockLocationBinding") is not None else None,
            "MaxListed": ConfigItemInt32.from_dict(obj["MaxListed"]) if obj.get("MaxListed") is not None else None,
            "StockPercentage": ConfigItemDouble.from_dict(obj["StockPercentage"]) if obj.get("StockPercentage") is not None else None,
            "EndWhen": ConfigItemInt32.from_dict(obj["EndWhen"]) if obj.get("EndWhen") is not None else None,
            "InvSyncErrorCount": ConfigItemInt32.from_dict(obj["InvSyncErrorCount"]) if obj.get("InvSyncErrorCount") is not None else None,
            "ExtractInventory": ConfigPropertyBoolean.from_dict(obj["ExtractInventory"]) if obj.get("ExtractInventory") is not None else None,
            "ExtractInventoryVariationMappingPropertyName": ConfigPropertyString.from_dict(obj["ExtractInventoryVariationMappingPropertyName"]) if obj.get("ExtractInventoryVariationMappingPropertyName") is not None else None,
            "PriceChange": ConfigItemBoolean.from_dict(obj["PriceChange"]) if obj.get("PriceChange") is not None else None,
            "PriceChangeErrorCount": ConfigItemInt32.from_dict(obj["PriceChangeErrorCount"]) if obj.get("PriceChangeErrorCount") is not None else None,
            "IsInventorySyncTriggerEnabled": ConfigPropertyBoolean.from_dict(obj["IsInventorySyncTriggerEnabled"]) if obj.get("IsInventorySyncTriggerEnabled") is not None else None,
            "IsListingScanRunning": ConfigItemBoolean.from_dict(obj["IsListingScanRunning"]) if obj.get("IsListingScanRunning") is not None else None,
            "ListingScanStartUpdateDate": ConfigItemDateTime.from_dict(obj["ListingScanStartUpdateDate"]) if obj.get("ListingScanStartUpdateDate") is not None else None,
            "LastListingUpdateDate": ConfigItemDateTime.from_dict(obj["LastListingUpdateDate"]) if obj.get("LastListingUpdateDate") is not None else None,
            "EstimatedInventoryScanComplete": ConfigItemDateTime.from_dict(obj["EstimatedInventoryScanComplete"]) if obj.get("EstimatedInventoryScanComplete") is not None else None,
            "IsHeaderOnly": obj.get("IsHeaderOnly"),
            "IsHidden": obj.get("IsHidden"),
            "DisplayName": obj.get("DisplayName"),
            "DynamicProperties": [ConfigItemExternal.from_dict(_item) for _item in obj["DynamicProperties"]] if obj.get("DynamicProperties") is not None else None,
            "ConfigDiscountTyped": obj.get("ConfigDiscountTyped"),
            "PostalServiceMapping": ConfigPostalServiceMapping.from_dict(obj["PostalServiceMapping"]) if obj.get("PostalServiceMapping") is not None else None,
            "PaymentMethodMapping": ConfigPaymentMethodMapping.from_dict(obj["PaymentMethodMapping"]) if obj.get("PaymentMethodMapping") is not None else None,
            "PkChannelId": obj.get("PkChannelId"),
            "Source": obj.get("Source"),
            "SourceType": obj.get("SourceType"),
            "FulfillmentServiceEnabled": obj.get("FulfillmentServiceEnabled"),
            "FulfillmentLocation": obj.get("FulfillmentLocation"),
            "ConcurrencyKey": obj.get("ConcurrencyKey"),
            "Rules": [ConfigRule.from_dict(_item) for _item in obj["Rules"]] if obj.get("Rules") is not None else None,
            "Buttons": [ConfigButton.from_dict(_item) for _item in obj["Buttons"]] if obj.get("Buttons") is not None else None,
            "SubSource": obj.get("SubSource"),
            "HeaderAuditValues": [ChannelSettingAudit.from_dict(_item) for _item in obj["HeaderAuditValues"]] if obj.get("HeaderAuditValues") is not None else None
        })
        return _obj


