# coding: utf-8

"""
    Inventory API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: inventory
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class InventoryUpdateInventoryItemLevelsRequest(BaseModel):
    """
    InventoryUpdateInventoryItemLevelsRequest
    """ # noqa: E501
    inventory_item_id: Optional[StrictStr] = Field(default=None, description="Stock Item Id", alias="inventoryItemId")
    field_name: Optional[StrictStr] = Field(default=None, description="Name of field updated", alias="fieldName")
    field_value: Optional[StrictStr] = Field(default=None, description="Input value", alias="fieldValue")
    location_id: Optional[StrictStr] = Field(default=None, description="Location Id", alias="locationId")
    change_source: Optional[StrictStr] = Field(default=None, alias="changeSource")
    __properties: ClassVar[List[str]] = ["inventoryItemId", "fieldName", "fieldValue", "locationId", "changeSource"]

    @field_validator('field_name')
    def field_name_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['SKU', 'Title', 'VariationGroupName', 'RetailPrice', 'PurchasePrice', 'Tracked', 'Barcode', 'Available', 'MinimumLevel', 'InOrder', 'StockLevel', 'StockValue', 'Due', 'BinRack', 'Category', 'Image', 'Weight', 'DimHeight', 'DimWidth', 'DimDepth', 'CreatedDate', 'ModifiedDate', 'SerialNumberScanRequired', 'BatchNumberScanRequired', 'BatchType', 'JIT', 'ReorderAmount', 'ReorderDate', 'AverageConsumption', 'DefaultSupplier']):
            raise ValueError("must be one of enum values ('SKU', 'Title', 'VariationGroupName', 'RetailPrice', 'PurchasePrice', 'Tracked', 'Barcode', 'Available', 'MinimumLevel', 'InOrder', 'StockLevel', 'StockValue', 'Due', 'BinRack', 'Category', 'Image', 'Weight', 'DimHeight', 'DimWidth', 'DimDepth', 'CreatedDate', 'ModifiedDate', 'SerialNumberScanRequired', 'BatchNumberScanRequired', 'BatchType', 'JIT', 'ReorderAmount', 'ReorderDate', 'AverageConsumption', 'DefaultSupplier')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InventoryUpdateInventoryItemLevelsRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InventoryUpdateInventoryItemLevelsRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "inventoryItemId": obj.get("inventoryItemId"),
            "fieldName": obj.get("fieldName"),
            "fieldValue": obj.get("fieldValue"),
            "locationId": obj.get("locationId"),
            "changeSource": obj.get("changeSource")
        })
        return _obj


