# coding: utf-8

"""
    Inventory API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: inventory
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.inventory.models.column import Column
from linnworks_api.generated.inventory.models.filter import Filter
from linnworks_api.generated.inventory.models.inventory_channel import InventoryChannel
from typing import Optional, Set
from typing_extensions import Self

class InventoryView(BaseModel):
    """
    InventoryView
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, alias="Id")
    name: Optional[StrictStr] = Field(default=None, alias="Name")
    mode: Optional[StrictStr] = Field(default=None, alias="Mode")
    source: Optional[StrictStr] = Field(default=None, alias="Source")
    sub_source: Optional[StrictStr] = Field(default=None, alias="SubSource")
    country_code: Optional[StrictStr] = Field(default=None, alias="CountryCode")
    country_name: Optional[StrictStr] = Field(default=None, alias="CountryName")
    listing: Optional[StrictStr] = Field(default=None, alias="Listing")
    show_only_changed: Optional[StrictBool] = Field(default=None, alias="ShowOnlyChanged")
    include_products: Optional[StrictStr] = Field(default=None, alias="IncludeProducts")
    filters: Optional[List[Filter]] = Field(default=None, alias="Filters")
    columns: Optional[List[Column]] = Field(default=None, alias="Columns")
    channels: Optional[List[InventoryChannel]] = Field(default=None, alias="Channels")
    __properties: ClassVar[List[str]] = ["Id", "Name", "Mode", "Source", "SubSource", "CountryCode", "CountryName", "Listing", "ShowOnlyChanged", "IncludeProducts", "Filters", "Columns", "Channels"]

    @field_validator('mode')
    def mode_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['All', 'Listed', 'NotListed', 'Errors']):
            raise ValueError("must be one of enum values ('All', 'Listed', 'NotListed', 'Errors')")
        return value

    @field_validator('listing')
    def listing_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['All', 'Variations', 'NonVariations', 'SingleItems']):
            raise ValueError("must be one of enum values ('All', 'Variations', 'NonVariations', 'SingleItems')")
        return value

    @field_validator('include_products')
    def include_products_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['All', 'Archived', 'NotArchived']):
            raise ValueError("must be one of enum values ('All', 'Archived', 'NotArchived')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InventoryView from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in filters (list)
        _items = []
        if self.filters:
            for _item_filters in self.filters:
                if _item_filters:
                    _items.append(_item_filters.to_dict())
            _dict['Filters'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in columns (list)
        _items = []
        if self.columns:
            for _item_columns in self.columns:
                if _item_columns:
                    _items.append(_item_columns.to_dict())
            _dict['Columns'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in channels (list)
        _items = []
        if self.channels:
            for _item_channels in self.channels:
                if _item_channels:
                    _items.append(_item_channels.to_dict())
            _dict['Channels'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InventoryView from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Id": obj.get("Id"),
            "Name": obj.get("Name"),
            "Mode": obj.get("Mode"),
            "Source": obj.get("Source"),
            "SubSource": obj.get("SubSource"),
            "CountryCode": obj.get("CountryCode"),
            "CountryName": obj.get("CountryName"),
            "Listing": obj.get("Listing"),
            "ShowOnlyChanged": obj.get("ShowOnlyChanged"),
            "IncludeProducts": obj.get("IncludeProducts"),
            "Filters": [Filter.from_dict(_item) for _item in obj["Filters"]] if obj.get("Filters") is not None else None,
            "Columns": [Column.from_dict(_item) for _item in obj["Columns"]] if obj.get("Columns") is not None else None,
            "Channels": [InventoryChannel.from_dict(_item) for _item in obj["Channels"]] if obj.get("Channels") is not None else None
        })
        return _obj


