# coding: utf-8

"""
    Inventory API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: inventory
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class MemberInfo(BaseModel):
    """
    MemberInfo
    """ # noqa: E501
    member_type: Optional[StrictStr] = Field(default=None, alias="MemberType")
    name: Optional[StrictStr] = Field(default=None, alias="Name")
    declaring_type: Optional[StrictStr] = Field(default=None, alias="DeclaringType")
    reflected_type: Optional[StrictStr] = Field(default=None, alias="ReflectedType")
    custom_attributes: Optional[List[CustomAttributeData]] = Field(default=None, alias="CustomAttributes")
    metadata_token: Optional[StrictInt] = Field(default=None, alias="MetadataToken")
    module: Optional[Dict[str, Any]] = Field(default=None, alias="Module")
    __properties: ClassVar[List[str]] = ["MemberType", "Name", "DeclaringType", "ReflectedType", "CustomAttributes", "MetadataToken", "Module"]

    @field_validator('member_type')
    def member_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Constructor', 'Event', 'Field', 'Method', 'Property', 'TypeInfo', 'Custom', 'NestedType', 'All']):
            raise ValueError("must be one of enum values ('Constructor', 'Event', 'Field', 'Method', 'Property', 'TypeInfo', 'Custom', 'NestedType', 'All')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MemberInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "member_type",
            "name",
            "declaring_type",
            "reflected_type",
            "custom_attributes",
            "metadata_token",
            "module",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in custom_attributes (list)
        _items = []
        if self.custom_attributes:
            for _item_custom_attributes in self.custom_attributes:
                if _item_custom_attributes:
                    _items.append(_item_custom_attributes.to_dict())
            _dict['CustomAttributes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MemberInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "MemberType": obj.get("MemberType"),
            "Name": obj.get("Name"),
            "DeclaringType": obj.get("DeclaringType"),
            "ReflectedType": obj.get("ReflectedType"),
            "CustomAttributes": [CustomAttributeData.from_dict(_item) for _item in obj["CustomAttributes"]] if obj.get("CustomAttributes") is not None else None,
            "MetadataToken": obj.get("MetadataToken"),
            "Module": obj.get("Module")
        })
        return _obj

from linnworks_api.generated.inventory.models.custom_attribute_data import CustomAttributeData
# TODO: Rewrite to not use raise_errors
MemberInfo.model_rebuild(raise_errors=False)

