# coding: utf-8

"""
    Inventory API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: inventory
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class StockItemComposition(BaseModel):
    """
    StockItemComposition
    """ # noqa: E501
    linked_stock_item_id: Optional[StrictStr] = Field(default=None, alias="LinkedStockItemId")
    item_title: Optional[StrictStr] = Field(default=None, alias="ItemTitle")
    sku: Optional[StrictStr] = Field(default=None, alias="SKU")
    quantity: Optional[StrictInt] = Field(default=None, alias="Quantity")
    purchase_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="PurchasePrice")
    inventory_tracking_type: Optional[StrictInt] = Field(default=None, alias="InventoryTrackingType")
    dim_height: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="DimHeight")
    dim_width: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="DimWidth")
    dim_depth: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="DimDepth")
    weight: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Weight")
    package_group_id: Optional[StrictStr] = Field(default=None, alias="PackageGroupId")
    tax_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="TaxRate")
    stock_item_id: Optional[StrictStr] = Field(default=None, alias="StockItemId")
    stock_item_int_id: Optional[StrictInt] = Field(default=None, alias="StockItemIntId")
    __properties: ClassVar[List[str]] = ["LinkedStockItemId", "ItemTitle", "SKU", "Quantity", "PurchasePrice", "InventoryTrackingType", "DimHeight", "DimWidth", "DimDepth", "Weight", "PackageGroupId", "TaxRate", "StockItemId", "StockItemIntId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StockItemComposition from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StockItemComposition from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "LinkedStockItemId": obj.get("LinkedStockItemId"),
            "ItemTitle": obj.get("ItemTitle"),
            "SKU": obj.get("SKU"),
            "Quantity": obj.get("Quantity"),
            "PurchasePrice": obj.get("PurchasePrice"),
            "InventoryTrackingType": obj.get("InventoryTrackingType"),
            "DimHeight": obj.get("DimHeight"),
            "DimWidth": obj.get("DimWidth"),
            "DimDepth": obj.get("DimDepth"),
            "Weight": obj.get("Weight"),
            "PackageGroupId": obj.get("PackageGroupId"),
            "TaxRate": obj.get("TaxRate"),
            "StockItemId": obj.get("StockItemId"),
            "StockItemIntId": obj.get("StockItemIntId")
        })
        return _obj


